/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RenderUtil;

public class NightVisionGoggles
extends AdventArmour {
    private static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("aoa3", "textures/gui/overlay/helmet/night_vision_goggles.png");

    public NightVisionGoggles() {
        super(ItemUtil.customArmourMaterial("aoa3:night_vision_goggles", 27, new int[]{2, 2, 2, 2}, 10, SoundEvents.f_11675_, 1.0f), ArmorItem.Type.HELMET);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.ALL;
    }

    @Override
    public void onEffectTick(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots) {
        plData.player().m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300, 0, true, false));
    }

    @Override
    public void onUnequip(ServerPlayerDataManager plData, @Nullable EquipmentSlot slot) {
        MobEffectInstance nightVision = plData.player().m_21124_(MobEffects.f_19611_);
        if (nightVision != null && nightVision.m_19557_() < 300) {
            plData.player().m_21195_(MobEffects.f_19611_);
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public void renderHelmetOverlay(ItemStack stack, Player player, int width, int height, float partialTick) {
                RenderUtil.prepRenderTexture(OVERLAY_TEXTURE);
                RenderUtil.renderFullscreenTexture();
            }
        });
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
        tooltip.add((Component)this.anySetEffectHeader());
    }
}

