/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class BiogenicArmour
extends AdventArmour {
    public BiogenicArmour(ArmorItem.Type slot) {
        super(ItemUtil.customArmourMaterial("aoa3:biogenic", 38, new int[]{3, 6, 8, 3}, 10, SoundEvents.f_11675_, 3.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.BIOGENIC;
    }

    @Override
    public void onEffectTick(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots) {
        if (slots == null) {
            if (plData.player().m_20069_()) {
                plData.player().m_20301_(-10);
            }
            if (plData.player().m_204029_(FluidTags.f_13131_)) {
                plData.player().m_7292_(new MobEffectInstance(MobEffects.f_19611_, 300, 0, true, false));
            } else {
                MobEffectInstance nightVision = plData.player().m_21124_(MobEffects.f_19611_);
                if (nightVision != null && nightVision.m_19557_() <= 300) {
                    plData.player().m_21195_(MobEffects.f_19611_);
                }
            }
        }
    }

    @Override
    public void onPostAttackReceived(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingDamageEvent event) {
        if (slots != null && DamageUtil.isMeleeDamage(event.getSource()) && event.getSource().m_7639_() instanceof LivingEntity) {
            ((LivingEntity)event.getSource().m_7639_()).m_7292_(new MobEffectInstance(MobEffects.f_19597_, (int)event.getAmount() * 3 * slots.size(), slots.size() >= 2 ? 1 : 0, false, true));
        }
    }

    @Override
    public void onUnequip(ServerPlayerDataManager plData, @Nullable EquipmentSlot slot) {
        MobEffectInstance nightVision;
        if (slot == null && (nightVision = plData.player().m_21124_(MobEffects.f_19611_)) != null && nightVision.m_19557_() <= 300) {
            plData.player().m_21195_(MobEffects.f_19611_);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.biogenic_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.biogenic_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add((Component)LocaleUtil.getFormattedItemDescriptionText("item.aoa3.biogenic_armour.desc.3", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

