/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.thrown;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.content.entity.projectile.HardProjectile;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.misc.HellfireProjectileEntity;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.EntityUtil;

public class HellfireEntity
extends BaseBullet
implements HardProjectile,
ItemSupplier {
    private float explosionStrength = 1.5f;
    private LivingEntity shooter;
    private BaseGun gun;

    public HellfireEntity(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public HellfireEntity(Level world) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.HELLFIRE.get()), world);
    }

    public HellfireEntity(LivingEntity shooter, BaseGun gun) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.HELLFIRE.get()), shooter, gun, 1.0f, 0, 1.5f);
        this.shooter = shooter;
        this.gun = gun;
    }

    public HellfireEntity(LivingEntity shooter, BaseGun gun, InteractionHand hand, int maxAge, int piercingValue) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.HELLFIRE.get()), shooter, gun, hand, maxAge, 1.0f, piercingValue);
    }

    public HellfireEntity(Level world, double x, double y, double z) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.HELLFIRE.get()), world, x, y, z);
    }

    @Override
    public float m_7139_() {
        return 0.075f;
    }

    public void setExplosionStrength(float strength) {
        this.explosionStrength = strength;
    }

    @Override
    protected void m_6532_(HitResult result) {
        if (result instanceof BlockHitResult && this.f_19797_ <= 1 && this.m_19749_() == null) {
            return;
        }
        super.m_6532_(result);
    }

    @Override
    public void doBlockImpact(Vec3 impactLocation, Direction face, BlockPos blockPos) {
        this.explode(impactLocation);
    }

    @Override
    public void doEntityImpact(Entity target, Vec3 impactLocation) {
        this.explode(impactLocation);
    }

    protected void explode(Vec3 position) {
        int count = 0;
        for (LivingEntity e : this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(7.0), EntityUtil.Predicates.HOSTILE_MOB)) {
            this.f_19853_.m_7967_((Entity)new HellfireProjectileEntity(this, e.m_20185_(), e.m_20186_(), e.m_20189_()));
            e.m_20254_(10);
            ++count;
        }
        if (this.shooter instanceof Player) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)AoASounds.HELLFIRE_IMPACT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            if (count >= 20 && this.shooter instanceof ServerPlayer) {
                AdvancementUtil.completeAdvancement((ServerPlayer)this.shooter, new ResourceLocation("aoa3", "overworld/heckfire"), "20_target_hellfire");
            }
        }
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)AoAWeapons.HELLFIRE.get());
    }
}

