/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.mob;

import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.AoAExplosions;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.entity.mob.overworld.BombCarrierEntity;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.library.object.explosion.StandardExplosion;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BombCarrierDynamiteEntity
extends BaseMobProjectile
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public BombCarrierDynamiteEntity(Level world, Vec3 position, BombCarrierEntity owner) {
        super((EntityType<? extends ThrowableProjectile>)((EntityType)AoAProjectiles.BOMB_CARRIER_DYNAMITE.get()), world, owner, BaseMobProjectile.Type.PHYSICAL);
        this.m_7678_(position.f_82479_, position.f_82480_, position.f_82481_, this.f_19796_.m_188501_() * 360.0f, 0.0f);
    }

    public BombCarrierDynamiteEntity(EntityType<? extends BombCarrierDynamiteEntity> entityType, Level level) {
        super(entityType, level);
        this.shooter = null;
        if (level.m_5776_()) {
            new SoundBuilder((Supplier<SoundEvent>)AoASounds.LIT_FUSE).followEntity((Entity)this).category(SoundSource.HOSTILE).execute();
        }
    }

    @Override
    public float m_7139_() {
        return 0.05f;
    }

    protected void m_5790_(EntityHitResult hitResult) {
        this.explode(hitResult.m_82450_());
    }

    protected void m_8060_(BlockHitResult hitResult) {
        this.explode(hitResult.m_82450_());
    }

    private void explode(Vec3 position) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            new StandardExplosion(AoAExplosions.BOMB_CARRIER_DYNAMITE, serverLevel, (Entity)this, position).m_46061_();
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }
}

