/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.mob;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BaseMobProjectile
extends ThrowableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache animatableCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected Type projectileType;
    protected AoARangedAttacker shooter;

    public BaseMobProjectile(EntityType<? extends ThrowableProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public BaseMobProjectile(EntityType<? extends ThrowableProjectile> entityType, Level world, AoARangedAttacker shooter, double posX, double posY, double posZ, Type projectileType) {
        super(entityType, world);
        this.m_6034_(posX, posY, posZ);
        this.m_20334_(this.f_19796_.m_188583_() / 33.0 + 0.03, -2.0, this.f_19796_.m_188583_() / 33.0 + 0.03);
        this.projectileType = projectileType;
        this.shooter = shooter;
    }

    public BaseMobProjectile(EntityType<? extends ThrowableProjectile> entityType, Level world, AoARangedAttacker shooter, Entity target, Type projectileType) {
        this(entityType, world, shooter, target.m_20185_(), target.m_20186_() + 25.0, target.m_20189_(), projectileType);
    }

    public BaseMobProjectile(EntityType<? extends ThrowableProjectile> entityType, Level world, AoARangedAttacker shooter, Type projectileType) {
        super(entityType, world);
        if (shooter instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)shooter;
            this.m_5602_((Entity)owner);
            this.m_6034_(owner.m_20185_(), owner.m_20186_() + (double)owner.m_20192_() - (double)0.1f, owner.m_20189_());
        }
        this.projectileType = projectileType;
        this.shooter = shooter;
    }

    public Type getProjectileType() {
        return this.projectileType;
    }

    public float m_7139_() {
        return 0.0f;
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ > 500) {
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult result) {
        if ((result.m_6662_() != HitResult.Type.BLOCK || this.f_19853_.m_8055_(BlockPos.m_274446_((Position)result.m_82450_())).m_60767_().m_76334_()) && !this.f_19853_.f_46443_) {
            if (result instanceof EntityHitResult) {
                EntityHitResult entityHitResult = (EntityHitResult)result;
                if (entityHitResult.m_82443_() == this.shooter || this.shooter == null) {
                    return;
                }
                this.m_5790_(entityHitResult);
                this.shooter.doRangedAttackEntity(this, entityHitResult.m_82443_());
            } else if (result instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)result;
                if (this.shooter != null) {
                    this.m_8060_(blockHitResult);
                    this.shooter.doRangedAttackBlock(this, this.f_19853_.m_8055_(BlockPos.m_274446_((Position)result.m_82450_())), BlockPos.m_274446_((Position)result.m_82450_()), blockHitResult.m_82434_());
                }
            }
            this.m_146870_();
        }
    }

    public boolean m_6128_() {
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{DefaultAnimations.genericLivingController((GeoAnimatable)this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableCache;
    }

    public boolean m_6072_() {
        return false;
    }

    public static enum Type {
        MAGIC,
        PHYSICAL,
        GUN,
        ENERGY;

    }
}

