/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.projectile.arrow;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.registration.entity.AoAProjectiles;
import net.tslat.aoa3.content.item.weapon.bow.BaseBow;
import net.tslat.aoa3.content.item.weapon.crossbow.BaseCrossbow;

public class CustomArrowEntity
extends Arrow {
    protected BaseBow bow;
    protected BaseCrossbow crossbow;
    private boolean ignoreExplosions = false;
    private Entity cachedOwner = null;

    public CustomArrowEntity(EntityType<? extends Arrow> type, Level world) {
        super(type, world);
    }

    public CustomArrowEntity(Level world, double x, double y, double z) {
        super((EntityType)AoAProjectiles.ARROW.get(), world);
        this.m_6034_(x, y, z);
    }

    public CustomArrowEntity(Level world, BaseBow bow, LivingEntity shooter, double baseDamage) {
        super((EntityType)AoAProjectiles.ARROW.get(), world);
        this.m_5602_((Entity)shooter);
        this.m_36781_(baseDamage);
        this.bow = bow;
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_());
    }

    public CustomArrowEntity(Level world, BaseCrossbow crossbow, LivingEntity shooter, double baseDamage) {
        super((EntityType)AoAProjectiles.ARROW.get(), world);
        this.m_5602_((Entity)shooter);
        this.m_36781_(baseDamage);
        this.crossbow = crossbow;
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_());
    }

    public static CustomArrowEntity fromArrow(AbstractArrow baseArrow, BaseBow bow, LivingEntity shooter, double baseDamage) {
        CustomArrowEntity arrow = new CustomArrowEntity((EntityType<? extends Arrow>)((EntityType)AoAProjectiles.ARROW.get()), baseArrow.f_19853_);
        arrow.m_5602_((Entity)shooter);
        arrow.m_36781_(baseDamage);
        arrow.m_36735_(baseArrow.m_150123_());
        arrow.m_36762_(baseArrow.m_36792_());
        arrow.m_20254_(baseArrow.m_20094_());
        CustomArrowEntity.duplicateArrowVelocity(baseArrow, (AbstractArrow)arrow);
        arrow.m_6034_(shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_());
        if (baseArrow instanceof Arrow) {
            Arrow baseArrowEntity = (Arrow)baseArrow;
            arrow.f_36855_ = baseArrowEntity.f_36855_;
            arrow.f_36852_ = baseArrowEntity.f_36852_;
            arrow.m_36882_(baseArrowEntity.m_36889_());
        }
        arrow.bow = bow;
        return arrow;
    }

    public static CustomArrowEntity fromArrow(AbstractArrow baseArrow, BaseCrossbow crossbow, LivingEntity shooter, double baseDamage) {
        CustomArrowEntity arrow = new CustomArrowEntity((EntityType<? extends Arrow>)((EntityType)AoAProjectiles.ARROW.get()), baseArrow.f_19853_);
        arrow.m_5602_((Entity)shooter);
        arrow.m_36781_(baseDamage);
        arrow.m_36735_(baseArrow.m_150123_());
        arrow.m_36762_(baseArrow.m_36792_());
        arrow.m_20254_(baseArrow.m_20094_());
        CustomArrowEntity.duplicateArrowVelocity(baseArrow, (AbstractArrow)arrow);
        arrow.m_6034_(shooter.m_20185_(), shooter.m_20188_() - (double)0.1f, shooter.m_20189_());
        if (baseArrow instanceof Arrow) {
            Arrow baseArrowEntity = (Arrow)baseArrow;
            arrow.f_36855_ = baseArrowEntity.f_36855_;
            arrow.f_36852_ = baseArrowEntity.f_36852_;
            arrow.m_36882_(baseArrowEntity.m_36889_());
        }
        arrow.crossbow = crossbow;
        return arrow;
    }

    protected static void duplicateArrowVelocity(AbstractArrow source, AbstractArrow target) {
        target.m_20256_(source.m_20184_());
        target.m_146926_(source.m_146909_());
        target.m_146922_(source.m_146908_());
        target.f_19860_ = source.f_19860_;
        target.f_19859_ = source.f_19859_;
    }

    @Nullable
    public Entity m_19749_() {
        if (this.cachedOwner != null && this.cachedOwner.m_6084_()) {
            return this.cachedOwner;
        }
        this.cachedOwner = super.m_19749_();
        return this.cachedOwner;
    }

    public void m_8119_() {
        if (this.bow != null) {
            this.bow.onArrowTick(this, this.m_19749_());
        } else if (this.crossbow != null) {
            this.crossbow.onArrowTick(this, this.m_19749_());
        }
        super.m_8119_();
    }

    public boolean m_6128_() {
        return this.ignoreExplosions;
    }

    public void setIgnoreExplosions() {
        this.ignoreExplosions = true;
    }

    protected void m_6532_(HitResult rayTrace) {
        if (rayTrace.m_6662_() == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)rayTrace);
        } else if (rayTrace.m_6662_() == HitResult.Type.BLOCK) {
            BlockState blockstate;
            BlockHitResult blockTrace = (BlockHitResult)rayTrace;
            this.f_36696_ = blockstate = this.f_19853_.m_8055_(blockTrace.m_82425_());
            Vec3 Vec32 = blockTrace.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            if (this.bow != null) {
                this.bow.onBlockHit(this, blockTrace, this.m_19749_());
            } else if (this.crossbow != null) {
                this.crossbow.onBlockHit(this, blockTrace, this.m_19749_());
            }
            this.m_20256_(Vec32);
            Vec3 Vector3d1 = Vec32.m_82541_().m_82490_((double)0.05f);
            this.m_20343_(this.m_20185_() - Vector3d1.f_82479_, this.m_20186_() - Vector3d1.f_82480_, this.m_20189_() - Vector3d1.f_82481_);
            this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            this.f_36703_ = true;
            this.f_36706_ = 7;
            this.m_36762_(false);
            this.m_36767_((byte)0);
            this.m_36740_(SoundEvents.f_11685_);
            this.m_36793_(false);
            if (this.f_36702_ != null) {
                this.f_36702_.clear();
            }
            if (this.f_36701_ != null) {
                this.f_36701_.clear();
            }
            blockstate.m_60669_(this.f_19853_, blockstate, blockTrace, (Projectile)this);
        }
    }

    protected void m_5790_(EntityHitResult rayTrace) {
        DamageSource source;
        Entity shooter;
        Entity target = rayTrace.m_82443_();
        float drawPower = (float)this.m_20184_().m_82553_();
        double damage = this.m_36789_();
        boolean critical = this.m_36792_();
        if (this.bow != null) {
            damage = this.bow.getArrowDamage(this, target, damage, drawPower, critical);
        } else if (this.crossbow != null) {
            damage = this.crossbow.getArrowDamage(this, target, damage, drawPower, critical);
        }
        damage = Math.max(damage, 0.0);
        if (this.m_36796_() > 0) {
            if (this.f_36701_ == null) {
                this.f_36701_ = new IntOpenHashSet(5);
            }
            if (this.f_36702_ == null) {
                this.f_36702_ = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.f_36701_.size() >= this.m_36796_() + 1) {
                this.m_146870_();
                return;
            }
            this.f_36701_.add(target.m_19879_());
        }
        if ((shooter = this.m_19749_()) == null) {
            source = this.m_269291_().m_269418_((AbstractArrow)this, (Entity)this);
        } else {
            source = this.m_269291_().m_269418_((AbstractArrow)this, shooter);
            if (shooter instanceof LivingEntity) {
                ((LivingEntity)shooter).m_21335_(target);
            }
        }
        boolean isEnderman = target.m_6095_() == EntityType.f_20566_;
        int fireTimer = target.m_20094_();
        if (this.m_6060_() && !isEnderman) {
            target.m_20254_(5);
        }
        if (target.m_6469_(source, (float)damage)) {
            if (isEnderman) {
                return;
            }
            if (this.bow != null) {
                this.bow.onEntityHit(this, target, shooter, damage, drawPower);
            } else if (this.crossbow != null) {
                this.crossbow.onEntityHit(this, target, shooter, damage, drawPower);
            }
            if (target instanceof LivingEntity) {
                Vec3 Vec32;
                LivingEntity livingTarget = (LivingEntity)target;
                if (!this.f_19853_.f_46443_ && this.m_36796_() <= 0) {
                    livingTarget.m_21317_(livingTarget.m_21234_() + 1);
                }
                if (this.m_150123_() > 0 && (Vec32 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.m_150123_() * 0.6)).m_82556_() > 0.0) {
                    livingTarget.m_5997_(Vec32.f_82479_, 0.1, Vec32.f_82481_);
                }
                if (!this.f_19853_.f_46443_ && shooter instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingTarget, (Entity)shooter);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)shooter), (Entity)livingTarget);
                }
                this.m_7761_(livingTarget);
                if (livingTarget != shooter && livingTarget instanceof Player && shooter instanceof ServerPlayer) {
                    ((ServerPlayer)shooter).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
                if (!target.m_6084_() && this.f_36702_ != null) {
                    this.f_36702_.add(livingTarget);
                }
                if (!this.f_19853_.f_46443_ && shooter instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)shooter;
                    if (this.f_36702_ != null && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverPlayer, (Collection)this.f_36702_);
                    } else if (!target.m_6084_() && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverPlayer, List.of(target));
                    }
                }
            }
            this.m_5496_(this.m_36784_(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            if (this.m_36796_() <= 0) {
                this.m_146870_();
            }
        } else {
            target.m_7311_(fireTimer);
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
            if (!this.f_19853_.f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            }
        }
    }
}

