/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.npc.ambient;

import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoANpcs;
import net.tslat.aoa3.content.entity.base.AoAAmbientNPC;
import net.tslat.aoa3.library.builder.ParticleBuilder;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class DryadSpriteEntity
extends AoAAmbientNPC {
    private static final EntityDataHolder<Integer> VARIANT = EntityDataHolder.register(DryadSpriteEntity.class, EntityDataSerializers.f_135028_, 0, entity -> entity.variant, (entity, value) -> {
        entity.variant = value;
    });
    private static final EntityDataHolder<Optional<UUID>> OWNER = EntityDataHolder.register(DryadSpriteEntity.class, EntityDataSerializers.f_135041_, Optional.empty(), entity -> entity.owner, (entity, uuid) -> {
        entity.owner = uuid;
    });
    private static final EntityDataHolder<Integer> SUCCESS_TIMER = EntityDataHolder.register(DryadSpriteEntity.class, EntityDataSerializers.f_135028_, -1, entity -> entity.successTimer, (entity, value) -> {
        entity.successTimer = value;
    });
    private int variant = 0;
    private Optional<UUID> owner = Optional.empty();
    private int successTimer = -1;

    public DryadSpriteEntity(EntityType<? extends DryadSpriteEntity> entityType, Level world) {
        super(entityType, world);
    }

    public DryadSpriteEntity(Player owner) {
        super((EntityType<? extends PathfinderMob>)((EntityType)AoANpcs.DRYAD_SPRITE.get()), owner.f_19853_);
        OWNER.set((Entity)this, Optional.of(owner.m_20148_()));
        VARIANT.set((Entity)this, this.rand().randomNumberUpTo(6));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.registerDataParams(VARIANT, OWNER, SUCCESS_TIMER);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag nbt) {
        VARIANT.set((Entity)this, this.rand().randomNumberUpTo(6));
        return super.m_6518_(world, difficulty, reason, spawnData, nbt);
    }

    @Override
    @Nullable
    protected String getInteractMessage(ItemStack heldItem) {
        if (heldItem.m_41619_()) {
            return this.m_6095_().m_20675_() + ".interact.empty";
        }
        if (!ItemUtil.isHoe(heldItem.m_41720_())) {
            return this.m_6095_().m_20675_() + ".interact.incorrect";
        }
        return null;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!source.m_276093_(DamageTypes.f_268724_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_6084_() && this.isOwner((Entity)player) && SUCCESS_TIMER.is((Entity)this, -1)) {
            ItemStack heldStack = player.m_21120_(hand);
            if (OWNER.get((Entity)this).isEmpty()) {
                OWNER.set((Entity)this, Optional.of(player.m_20148_()));
            }
            if (ItemUtil.isHoe(heldStack.m_41720_())) {
                if (heldStack.m_41720_() == this.getVariant().getTool()) {
                    if (!this.f_19853_.m_5776_()) {
                        SUCCESS_TIMER.set((Entity)this, 44);
                        player.m_5993_((Entity)this, 1, this.f_19853_.m_269111_().m_269075_(player));
                        this.f_21344_.m_26573_();
                        this.m_21557_(true);
                        this.m_20334_(0.0, 0.0, 0.0);
                    }
                } else {
                    this.m_146870_();
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)AoASounds.ENTITY_DRYAD_SPRITE_UNHAPPY.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    for (int i = 0; i < 20; ++i) {
                        AoAPackets.messageAllPlayersTrackingEntity(new ServerParticlePacket(ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.f_123792_, (Entity)this).velocity(RandomUtil.randomScaledGaussianValue((double)0.02), RandomUtil.randomScaledGaussianValue((double)0.02), RandomUtil.randomScaledGaussianValue((double)0.02))), (Entity)this);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public Variant getVariant() {
        return Variant.byNumber(VARIANT.get((Entity)this));
    }

    public void m_6043_() {
        super.m_6043_();
        if (!this.m_213877_() && this.f_19797_ > 100 && SUCCESS_TIMER.is((Entity)this, -1)) {
            this.m_146870_();
        }
    }

    protected void m_8024_() {
        if (this.successTimer > 0) {
            SUCCESS_TIMER.set((Entity)this, this.successTimer - 1);
        } else if (this.successTimer == 0) {
            ServerParticlePacket packet = new ServerParticlePacket();
            for (int i = 0; i < 20; ++i) {
                packet.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.f_123748_, (Entity)this).velocity(this.rand().randomScaledGaussianValue(0.02), this.rand().randomScaledGaussianValue(0.02), this.rand().randomScaledGaussianValue(0.02)));
            }
            AoAPackets.messageAllPlayersTrackingEntity(packet, (Entity)this);
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)AoASounds.ENTITY_DRYAD_SPRITE_HAPPY.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            OWNER.get((Entity)this).ifPresent(ownerId -> {
                Player player = this.f_19853_.m_46003_(ownerId);
                this.m_21153_(0.0f);
                if (player != null) {
                    this.m_6668_(this.f_19853_.m_269111_().m_269075_(player));
                }
            });
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, state -> {
            if (SUCCESS_TIMER.get((Entity)this) >= 0) {
                return state.setAndContinue(AoAAnimations.SUCCEED);
            }
            return state.setAndContinue(state.isMoving() ? DefaultAnimations.WALK : DefaultAnimations.IDLE);
        })});
    }

    public boolean isOwner(Entity entity) {
        return OWNER.get((Entity)this).map(value -> value.equals(entity.m_20148_())).orElse(false);
    }

    public static enum Variant {
        WOOD(0, () -> Items.f_42424_),
        STONE(1, () -> Items.f_42429_),
        IRON(2, () -> Items.f_42387_),
        GOLD(3, () -> Items.f_42434_),
        DIAMOND(4, () -> Items.f_42392_),
        NETHERITE(5, () -> Items.f_42397_);

        private final int number;
        private final Supplier<Item> tool;

        private Variant(int number, Supplier<Item> tool) {
            this.number = number;
            this.tool = tool;
        }

        public int getNumber() {
            return this.number;
        }

        public Item getTool() {
            return this.tool.get();
        }

        public static Variant byNumber(int number) {
            return switch (number) {
                case 1 -> STONE;
                case 2 -> IRON;
                case 3 -> GOLD;
                case 4 -> DIAMOND;
                case 5 -> NETHERITE;
                default -> WOOD;
            };
        }
    }
}

