/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class YetiEntity
extends AoAMeleeMob<YetiEntity> {
    private static final int STRIKE = 0;
    private static final int SWING = 1;

    public YetiEntity(EntityType<? extends YetiEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 1.9375f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_YETI_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_YETI_DEATH.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_YETI_HURT.get();
    }

    @Override
    public BrainActivityGroup<YetiEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> {
            Player pl;
            return target instanceof Player && ((pl = (Player)target).m_7500_() || pl.m_5833_()) || this.m_20238_(target.m_20182_()) > Math.pow(this.m_21133_(Attributes.f_22277_), 2.0);
        }), new SetWalkTargetToAttackTarget(), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new AnimatableMeleeAttack(7).attackInterval(entity -> 16).whenStarting(entity -> ATTACK_STATE.set((Entity)entity, 0)).whenStopping(entity -> BrainUtils.setSpecialCooldown((LivingEntity)this, (int)16)), (Object)3), Pair.of((Object)new AnimatableMeleeAttack(4).attackInterval(entity -> 14).whenStarting(entity -> ATTACK_STATE.set((Entity)entity, 1)).whenStopping(entity -> BrainUtils.setSpecialCooldown((LivingEntity)this, (int)14)), (Object)1)}).startCondition(entity -> !BrainUtils.isOnSpecialCooldown((LivingEntity)this))});
    }

    @Override
    protected void onAttack(Entity target) {
        super.onAttack(target);
        if (ATTACK_STATE.is((Entity)this, 1) && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            DamageUtil.doScaledKnockback(livingTarget, (LivingEntity)this, 1.1f, 1.0, 1.25, 1.0);
        }
    }

    @Override
    protected int getAttackSwingDuration() {
        return ATTACK_STATE.is((Entity)this, 0) ? 16 : 14;
    }

    @Override
    protected int getPreAttackTime() {
        return ATTACK_STATE.is((Entity)this, 0) ? 7 : 4;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkController((GeoAnimatable)this), AoAAnimations.dynamicAttackController(this, state -> ATTACK_STATE.is((Entity)this, 0) ? DefaultAnimations.ATTACK_STRIKE : DefaultAnimations.ATTACK_SWING)});
    }
}

