/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAMobEffects;
import net.tslat.aoa3.content.entity.ai.mob.TelegraphedMeleeAttackGoal;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.builder.ParticleBuilder;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.library.constant.ScreenImageEffect;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class WoodGiantEntity
extends AoAMeleeMob<WoodGiantEntity> {
    public static final EntityDataHolder<Integer> STAGE = EntityDataHolder.register(WoodGiantEntity.class, EntityDataSerializers.f_135028_, 0, WoodGiantEntity::getStage, WoodGiantEntity::setStage);
    private final AttributeModifier STAGE_ARMOUR_MOD = new AttributeModifier(UUID.fromString("076a790a-a765-4313-b517-527b758e839f"), "StageArmourModifier", 1.0, AttributeModifier.Operation.ADDITION){

        public double m_22218_() {
            return 35 - Math.max(0, WoodGiantEntity.this.getStage() + 1) * 10;
        }
    };
    private final AttributeModifier STAGE_TOUGHNESS_MOD = new AttributeModifier(UUID.fromString("3977cd08-2bbe-48ed-b66e-557ada8565b9"), "StageToughnessModifier", 1.0, AttributeModifier.Operation.ADDITION){

        public double m_22218_() {
            return 50 - Math.max(0, WoodGiantEntity.this.getStage() + 1) * 15;
        }
    };
    private int lastMeleeHit = 0;
    private int stage = 0;

    public WoodGiantEntity(EntityType<? extends WoodGiantEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
        this.f_19793_ = 1.5f;
    }

    @Override
    protected Brain.Provider<WoodGiantEntity> m_5490_() {
        return Brain.m_21923_(List.of(MemoryModuleType.f_26372_), (Collection)ImmutableList.of());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, new TelegraphedMeleeAttackGoal<WoodGiantEntity>(this).preAttackTime(this.getPreAttackTime()).attackInterval(this.m_21304_()));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.registerDataParams(STAGE);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        EntityUtil.applyAttributeModifierSafely((LivingEntity)this, Attributes.f_22284_, this.STAGE_ARMOUR_MOD, false);
        EntityUtil.applyAttributeModifierSafely((LivingEntity)this, Attributes.f_22285_, this.STAGE_TOUGHNESS_MOD, false);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 2.875f;
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.TREE_FALL.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.WOODY_HIT.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.WOODY_THUMP.get();
    }

    public boolean m_6094_() {
        return false;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 6;
    }

    @Override
    protected void onHurt(DamageSource source, float amount) {
        if (!this.f_19853_.m_5776_() && DamageUtil.isMeleeDamage(source)) {
            this.lastMeleeHit = this.f_19797_;
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                ServerPlayer pl;
                LivingEntity attacker = (LivingEntity)entity;
                ServerParticlePacket particlePacket = new ServerParticlePacket();
                ItemStack weapon = attacker.m_21120_(InteractionHand.MAIN_HAND);
                if (weapon.m_41735_(Blocks.f_49999_.m_49966_())) {
                    this.lastMeleeHit += 100;
                    particlePacket.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49999_.m_49966_()), (Entity)this).spawnNTimes(10));
                    if (this.m_21223_() <= 0.0f && attacker instanceof ServerPlayer) {
                        pl = (ServerPlayer)attacker;
                        pl.m_8960_().m_135988_(AdvancementUtil.getAdvancement(AdventOfAscension.id("i_axed_you_a_question")), "tool_kill");
                    }
                }
                if (this.getStage() < 3) {
                    STAGE.set((Entity)this, this.getStage() + 1);
                    particlePacket.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49999_.m_49966_()), (Entity)this).spawnNTimes(5));
                    if (!(attacker instanceof ServerPlayer) || !(pl = (ServerPlayer)attacker).m_7500_()) {
                        if (attacker instanceof ServerPlayer) {
                            ServerPlayer pl2 = (ServerPlayer)attacker;
                            new ScreenImageEffect(ScreenImageEffect.Type.BLOOD).duration(80).randomScale().coloured(255, 0, 0, 127).sendToPlayer(pl2);
                        }
                        attacker.m_147207_(new EffectBuilder((MobEffect)AoAMobEffects.BLEEDING.get(), 600).hideParticles().build(), (Entity)this);
                    }
                    new SoundBuilder((SoundEvent)AoASounds.HEAVY_WOOD_SHATTER.get()).followEntity((Entity)this).isMonster().execute();
                }
                AoAPackets.messageNearbyPlayers(particlePacket, (ServerLevel)this.f_19853_, this.m_20182_(), 20.0);
            }
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("WoodStage")) {
            STAGE.set((Entity)this, compound.m_128451_("WoodStage"));
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("WoodStage", STAGE.get((Entity)this).intValue());
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.f_19797_ - this.lastMeleeHit > 600) {
            int stage = this.getStage();
            this.lastMeleeHit = this.f_19797_;
            if (stage > 0 && stage <= 3) {
                STAGE.set((Entity)this, stage - 1);
                this.m_5634_(20.0f);
            }
        }
    }

    private void setStage(int stage) {
        this.stage = stage;
        if (!this.f_19853_.m_5776_()) {
            int oldStage = this.getStage();
            EntityUtil.reapplyAttributeModifier((LivingEntity)this, Attributes.f_22284_, this.STAGE_ARMOUR_MOD, false);
            EntityUtil.reapplyAttributeModifier((LivingEntity)this, Attributes.f_22285_, this.STAGE_TOUGHNESS_MOD, false);
            if (oldStage < stage) {
                ServerParticlePacket packet = new ServerParticlePacket(10);
                for (int i = 0; i < 10; ++i) {
                    packet.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49999_.m_49966_()), (Entity)this));
                }
                AoAPackets.messageNearbyPlayers(packet, (ServerLevel)this.f_19853_, this.m_20182_(), 20.0);
            }
        }
    }

    public int getStage() {
        return this.stage;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkController((GeoAnimatable)this), AoAAnimations.genericAttackAnimation(this, DefaultAnimations.ATTACK_SLAM)});
    }
}

