/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidType;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.base.AoARangedMob;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyLivingEntitySensor;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.TreeSpiritSpriteEntity;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableRangedAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.CustomHeldBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRetaliateTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class TreeSpiritEntity
extends AoARangedMob<TreeSpiritEntity> {
    private static final RawAnimation ACTIVATE = RawAnimation.begin().thenPlay("misc.activate").thenLoop("misc.active_idle");
    private static final RawAnimation DEACTIVATE = RawAnimation.begin().thenPlay("misc.deactivate");

    public TreeSpiritEntity(EntityType<? extends TreeSpiritEntity> entityType, Level world) {
        super((EntityType<? extends AoARangedMob>)entityType, world);
        IMMOBILE.set((Entity)this, true);
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12634_;
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.TREE_FALL.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return null;
    }

    @Override
    public List<ExtendedSensor<TreeSpiritEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor(), new AggroBasedNearbyLivingEntitySensor().setPredicate((target, entity) -> {
            OwnableEntity tamedEntity;
            return target instanceof OwnableEntity && (tamedEntity = (OwnableEntity)target).m_21805_() != null;
        }).setScanRate(entity -> 40), new HurtBySensor()});
    }

    @Override
    public BrainActivityGroup<TreeSpiritEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new CustomHeldBehaviour(owner -> {
            if (ATTACK_STATE.is((Entity)owner, 1) && BrainUtils.getTargetOfEntity((LivingEntity)owner) == null) {
                ATTACK_STATE.set((Entity)owner, 0);
            }
        })});
    }

    @Override
    public BrainActivityGroup<TreeSpiritEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new SetRetaliateTarget().attackablePredicate(entity -> {
            Player player;
            return entity.m_6084_() && (!(entity instanceof Player) || !(player = (Player)entity).m_7500_()) && this.m_20238_(entity.m_20182_()) < Math.pow(this.m_21133_((Attribute)AoAAttributes.AGGRO_RANGE.get()), 2.0);
        }).whenStarting(owner -> ATTACK_STATE.set((Entity)owner, 1)).startCondition(entity -> this.f_19853_.m_46791_() != Difficulty.PEACEFUL)});
    }

    @Override
    public BrainActivityGroup<TreeSpiritEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> {
            Player pl;
            return !target.m_6084_() || this.f_19853_.m_46791_() == Difficulty.PEACEFUL || target instanceof Player && ((pl = (Player)target).m_7500_() || pl.m_5833_()) || this.m_20238_(target.m_20182_()) > Math.pow(this.m_21133_(Attributes.f_22277_), 2.0);
        }), new AnimatableRangedAttack(15).attackInterval(entity -> RandomUtil.randomNumberBetween((int)15, (int)35)).startCondition(entity -> this.f_19853_.m_46791_() != Difficulty.PEACEFUL)});
    }

    @Override
    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @javax.annotation.Nullable SpawnGroupData spawnGroupData, @javax.annotation.Nullable CompoundTag nbt) {
        this.m_19890_(Math.floor(this.m_20185_()) + 0.5, this.m_20186_(), Math.floor(this.m_20189_()) + 0.5, 0.0f, 0.0f);
        this.m_146867_();
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, nbt);
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 2.4f;
    }

    public Component m_7755_() {
        if (ATTACK_STATE.is((Entity)this, 0)) {
            return Component.m_237115_((String)"entity.aoa3.dead_tree");
        }
        return super.m_7755_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean wasMaxHealth;
        if (source.m_276093_(DamageTypes.f_268724_)) {
            return super.m_6469_(source, amount);
        }
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            amount *= 1.25f;
        }
        boolean bl = wasMaxHealth = this.m_6084_() && this.m_21223_() == this.m_21233_();
        if (super.m_6469_(source, amount)) {
            Player player;
            if (!this.f_19853_.f_46443_ && wasMaxHealth && (player = PlayerUtil.getPlayerOrOwnerIfApplicable(source.m_7639_())) instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)player;
                if (this.m_21223_() <= 0.0f) {
                    AdvancementUtil.completeAdvancement(pl, AdventOfAscension.id("overworld/mightiest_tree_in_the_forest"), "tree_spirit_instakill");
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_6123_(Player player) {
    }

    protected void m_7324_(Entity entity) {
    }

    public boolean m_5829_() {
        return true;
    }

    protected boolean m_8028_() {
        return false;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Living", 1, state -> {
            if (ATTACK_STATE.is((Entity)this, 1)) {
                return state.setAndContinue(ACTIVATE);
            }
            if (state.getController().getCurrentRawAnimation() != null) {
                return state.setAndContinue(DEACTIVATE);
            }
            return PlayState.STOP;
        })});
    }

    @Override
    @javax.annotation.Nullable
    protected SoundEvent getShootSound() {
        return (SoundEvent)AoASounds.ENTITY_TREE_SPIRIT_SHOOT.get();
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    @Override
    public void doRangedAttackEntity(@javax.annotation.Nullable BaseMobProjectile projectile, Entity target) {
        if (target instanceof TreeSpiritEntity) {
            return;
        }
        super.doRangedAttackEntity(projectile, target);
    }

    @Override
    public void onProjectileAttack(@javax.annotation.Nullable BaseMobProjectile projectile, Entity target) {
        this.f_19853_.m_6263_(null, projectile.m_20185_(), projectile.m_20186_(), projectile.m_20189_(), (SoundEvent)AoASounds.ENTITY_TREE_SPIRIT_SPRITE_IMPACT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    @Override
    public void m_6504_(LivingEntity target, float distanceFactor) {
        this.f_19853_.m_7967_((Entity)this.getNewProjectileInstance());
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getShootSound(), SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new TreeSpiritSpriteEntity(this, (Entity)this.m_5448_());
    }
}

