/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld;

import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.base.AoARangedMob;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.CyanShotEntity;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class SeaTrollEntity
extends AoARangedMob<SeaTrollEntity> {
    public SeaTrollEntity(EntityType<? extends SeaTrollEntity> entityType, Level world) {
        super((EntityType<? extends AoARangedMob>)entityType, world);
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.625f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_GOBLIN_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_GOBLIN_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_GOBLIN_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return (SoundEvent)AoASounds.ENTITY_WIZARD_SHOOT.get();
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new CyanShotEntity(this, BaseMobProjectile.Type.MAGIC);
    }

    @Override
    public void onProjectileAttack(BaseMobProjectile projectile, Entity target) {
        EntityUtil.applyPotions(target, new EffectBuilder(MobEffects.f_19597_, 120));
    }

    @Override
    protected int getAttackSwingDuration() {
        return 16;
    }

    @Override
    protected int getPreAttackTime() {
        return 10;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController((GeoAnimatable)this), AoAAnimations.genericAttackAnimation(this, DefaultAnimations.ATTACK_SHOOT)});
    }
}

