/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAMobs;
import net.tslat.aoa3.content.entity.ai.mob.TelegraphedMeleeAttackGoal;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.mob.overworld.BushBabyEntity;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class LeafyGiantEntity
extends AoAMeleeMob<LeafyGiantEntity> {
    private int nextBushBaby = RandomUtil.randomNumberBetween((int)150, (int)500);

    public LeafyGiantEntity(EntityType<? extends LeafyGiantEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
        this.f_19793_ = 1.5f;
    }

    @Override
    protected Brain.Provider<LeafyGiantEntity> m_5490_() {
        return Brain.m_21923_(List.of(MemoryModuleType.f_26372_), (Collection)ImmutableList.of());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, new TelegraphedMeleeAttackGoal<LeafyGiantEntity>(this).preAttackTime(this.getPreAttackTime()).attackInterval(this.m_21304_()));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 12.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 3.0f;
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.BRANCHES_BREAKING.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.LEAFY_THUD.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.HEAVY_FOLIAGE_THUMP.get();
    }

    public boolean m_6094_() {
        return false;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 6;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        double preAttackHealth = this.m_21223_();
        double halfHealth = (double)this.m_21233_() * 0.5;
        boolean success = super.m_6469_(source, amount);
        if (success && (double)this.m_21223_() <= halfHealth && preAttackHealth > halfHealth) {
            this.m_20331_(true);
            LeafyGiantEntity target = this.m_5448_() != null ? this.m_5448_() : this;
            for (int i = 0; i < 10; ++i) {
                this.spawnBushBaby((LivingEntity)target);
            }
        }
        return success;
    }

    @Override
    protected void m_8024_() {
        if (this.m_20147_() && this.f_19797_ % 30 == 0) {
            List bushBabies = EntityRetrievalUtil.getEntities((Entity)this, (double)40.0, new EntityPredicate().isAlive().is((EntityType)AoAMobs.BUSH_BABY.get()));
            if (bushBabies.isEmpty()) {
                this.m_20331_(false);
            } else {
                bushBabies.forEach(bushBaby -> bushBaby.m_7292_(new EffectBuilder(MobEffects.f_19619_, 35).isAmbient().build()));
            }
        }
        if (this.nextBushBaby <= this.f_19797_) {
            LivingEntity target = this.m_5448_();
            if (target == null) {
                return;
            }
            this.nextBushBaby = this.f_19797_ + RandomUtil.randomNumberBetween((int)150, (int)500);
            if (EntityRetrievalUtil.getEntities((Entity)this, (double)10.0, new EntityPredicate((Entity)this).isAlive().is((EntityType)AoAMobs.BUSH_BABY.get())).size() < 5) {
                this.spawnBushBaby(target);
            }
        }
    }

    protected void spawnBushBaby(@Nonnull LivingEntity target) {
        if (this.f_19853_.m_5776_()) {
            return;
        }
        BushBabyEntity bushBaby = (BushBabyEntity)((Object)EntitySpawningUtil.spawnEntity((ServerLevel)this.f_19853_, (EntityType)AoAMobs.BUSH_BABY.get(), (Vec3i)BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20191_().f_82292_, (double)this.m_20189_()), MobSpawnType.MOB_SUMMONED));
        if (bushBaby == null) {
            return;
        }
        bushBaby.m_20334_(Mth.m_14008_((double)((target.m_20185_() - this.m_20185_()) * (double)0.2f), (double)-0.85, (double)0.5), 0.7, Mth.m_14008_((double)((target.m_20189_() - this.m_20189_()) * (double)0.2f), (double)-0.85, (double)0.85));
        BrainUtils.setTargetOfEntity((LivingEntity)bushBaby, (LivingEntity)target);
        bushBaby.f_19789_ = -10.0f;
        if (this.m_6060_()) {
            bushBaby.m_20254_(this.m_20094_() / 20);
        }
        if (this.m_21223_() < 0.5f * this.m_21233_()) {
            this.m_20331_(true);
            bushBaby.m_7292_(new EffectBuilder(MobEffects.f_19619_, 35).isAmbient().build());
        }
    }

    @Override
    protected void onAttack(Entity target) {
        if (this.m_6060_()) {
            target.m_20254_(this.m_20094_() / 20);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkController((GeoAnimatable)this), AoAAnimations.genericAttackAnimation(this, DefaultAnimations.ATTACK_SLAM)});
    }
}

