/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAMobs;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.mob.overworld.ChargerEntity;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class KingChargerEntity
extends AoAMeleeMob<KingChargerEntity> {
    private int nextChargerSpawn = 0;

    public KingChargerEntity(EntityType<? extends KingChargerEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
    }

    @Override
    public BrainActivityGroup<KingChargerEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new TargetOrRetaliate().useMemory(MemoryModuleType.f_148206_).attackablePredicate(entity -> {
            Player player;
            return entity.m_6084_() && (!(entity instanceof Player) || !(player = (Player)entity).m_7500_());
        }).whenStopping(entity -> EntityRetrievalUtil.getEntities((Entity)entity, (double)40.0, ally -> ally instanceof ChargerEntity).forEach(charger -> BrainUtils.setTargetOfEntity((LivingEntity)charger, (LivingEntity)BrainUtils.getTargetOfEntity((LivingEntity)entity)))), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.9f), new Idle().runFor(entity -> entity.m_217043_().m_216339_(30, 60))})});
    }

    @Override
    public BrainActivityGroup<KingChargerEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new SetWalkTargetToAttackTarget().speedMod(1.125f), new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration())});
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 1.84375f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_CHARGER_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_KING_CHARGER_HURT.get();
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 7;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.nextChargerSpawn < this.f_19797_) {
            ChargerEntity charger;
            LivingEntity target = this.m_5448_();
            if (target != null && (charger = (ChargerEntity)((Object)EntitySpawningUtil.spawnEntity((ServerLevel)this.f_19853_, (EntityType)AoAMobs.CHARGER.get(), (Vec3i)RandomUtil.getRandomPositionWithinRange((BlockPos)target.m_20183_(), (int)40, (int)10, (int)40, (int)30, (int)0, (int)30, (boolean)true, (Level)this.f_19853_, (int)2, (state, statePos) -> true), MobSpawnType.MOB_SUMMONED))) != null) {
                BrainUtils.setTargetOfEntity((LivingEntity)charger, (LivingEntity)target);
            }
            this.nextChargerSpawn = this.f_19797_ + RandomUtil.randomNumberBetween((int)80, (int)140);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkRunIdleController((Entity)this), AoAAnimations.genericAttackAnimation(this, DefaultAnimations.ATTACK_BITE)});
    }
}

