/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.ai.movehelper.UnderwaterWalkingMovementController;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SeekRandomNearbyPosition;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class ChomperEntity
extends AoAMeleeMob<ChomperEntity> {
    public ChomperEntity(EntityType<? extends ChomperEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
        this.f_21342_ = new UnderwaterWalkingMovementController((PathfinderMob)this);
        this.setParts(new AoAEntityPart<ChomperEntity>(this, this.m_20205_(), 0.65f, 0.0f, 0.2f, this.m_20205_()).setDamageMultiplier(1.25f), new AoAEntityPart<ChomperEntity>(this, this.m_20205_(), 0.4375f, 0.0f, 0.225f, -this.m_20205_()).setDamageMultiplier(0.9f), new AoAEntityPart<ChomperEntity>(this, 0.4375f, 0.3125f, 0.0f, 0.25f, -this.m_20205_() * 1.775f).setDamageMultiplier(0.75f));
    }

    public PathNavigation m_21573_() {
        return super.m_21573_();
    }

    @Override
    public List<ExtendedSensor<ChomperEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor(), new NearbyLivingEntitySensor().setPredicate((target, entity) -> {
            OwnableEntity tamedEntity;
            EntityDimensions entitySize = target.m_6972_(Pose.STANDING);
            if (entitySize.f_20377_ <= 0.5f && entitySize.f_20378_ <= 0.75f) {
                return true;
            }
            return target instanceof OwnableEntity && (tamedEntity = (OwnableEntity)target).m_21805_() != null;
        }).setScanRate(entity -> 40), new HurtBySensor()});
    }

    @Override
    public BrainActivityGroup<ChomperEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new WalkOrRunToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<ChomperEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new TargetOrRetaliate().useMemory(MemoryModuleType.f_148206_), new OneRandomBehaviour(new ExtendedBehaviour[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new SeekRandomNearbyPosition().speedModifier(0.8f).validPositions((entity, state) -> state.m_60819_().m_205070_(FluidTags.f_13131_)).startCondition(entity -> entity.f_19853_.m_46461_() && !entity.m_20069_()), new SetRandomWalkTarget().speedModifier(0.7f)}), new Idle().runFor(entity -> entity.m_217043_().m_216339_(30, 60))})});
    }

    @Override
    public BrainActivityGroup<ChomperEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new SetWalkTargetToAttackTarget().speedMod(1.05f), new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration())});
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.75f;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return type != ForgeMod.WATER_TYPE.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return EntityUtil.isEntityMoving((Entity)this) ? null : (SoundEvent)AoASounds.ENTITY_CHOMPER_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_HEAVY_STEP.get();
    }

    @Override
    protected int getAttackSwingDuration() {
        return 12;
    }

    @Override
    protected int getPreAttackTime() {
        return 5;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkRunIdleController((Entity)this), AoAAnimations.genericAttackAnimation(this, DefaultAnimations.ATTACK_BITE)});
    }
}

