/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld;

import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.IExtensibleEnum;
import net.minecraftforge.common.Tags;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.world.gen.BiomeMatcher;
import net.tslat.aoa3.library.object.CachedFunction;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class ChargerEntity
extends AoAMeleeMob<ChargerEntity> {
    private static final EntityDataHolder<String> TYPE = EntityDataHolder.register(ChargerEntity.class, EntityDataSerializers.f_135030_, Type.DEFAULT.name, entity -> entity.type.name, (entity, value) -> {
        entity.type = Type.fromString(value);
    });
    private Type type = Type.DEFAULT;

    public ChargerEntity(EntityType<? extends AoAMeleeMob> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.registerDataParams(TYPE);
    }

    @Override
    public BrainActivityGroup<ChargerEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new SetWalkTargetToAttackTarget().speedMod(1.125f), new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration())});
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        spawnData = super.m_6518_(world, difficulty, reason, spawnData, dataTag);
        if (world.m_5518_().m_75831_(this.m_20183_(), 0) == 0) {
            TYPE.set((Entity)this, Type.VOID.name);
        } else {
            Holder biome = world.m_204166_(this.m_20183_());
            for (Type type : Type.values()) {
                if (type == Type.DEFAULT || !type.canSpawnType(world.m_6018_(), this.m_20183_(), (Holder<Biome>)biome)) continue;
                TYPE.set((Entity)this, type.name);
                break;
            }
        }
        return spawnData;
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 1.275f;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_CHARGER_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_CHARGER_HURT.get();
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 7;
    }

    public Type getVariant() {
        return this.type;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{AoAAnimations.genericWalkRunSwimIdleController(this), AoAAnimations.genericAttackAnimation(this, DefaultAnimations.ATTACK_BITE)});
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128359_("ChargerType", TYPE.get((Entity)this));
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("ChargerType")) {
            TYPE.set((Entity)this, compound.m_128461_("ChargerType"));
        }
    }

    protected ResourceLocation m_7582_() {
        return this.getVariant() == Type.VOID ? AdventOfAscension.id("entities/void_charger") : super.m_7582_();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Type implements IExtensibleEnum
    {
        DEFAULT("", null),
        DESERT("desert", level -> new BiomeMatcher.Builder((ServerLevel)level).mustBe(Tags.Biomes.IS_HOT).atLeastOneOf(Tags.Biomes.IS_SANDY).build()),
        HILL("hill", level -> new BiomeMatcher.Builder((ServerLevel)level).mustBe(Tags.Biomes.IS_MOUNTAIN).cannotBe(Tags.Biomes.IS_SNOWY).build()),
        SEA("sea", level -> new BiomeMatcher.Builder((ServerLevel)level).atLeastOneOf(BiomeTags.f_207603_, BiomeTags.f_207605_, BiomeTags.f_207604_).cannotBe(Tags.Biomes.IS_SNOWY).build()),
        SNOW("snow", level -> new BiomeMatcher.Builder((ServerLevel)level).mustBe(Tags.Biomes.IS_SNOWY).build()),
        SWAMP("swamp", level -> new BiomeMatcher.Builder((ServerLevel)level).mustBe(Tags.Biomes.IS_SWAMP).cannotBe(Tags.Biomes.IS_SNOWY).build()),
        VOID("void", null){

            @Override
            public boolean canSpawnType(ServerLevel level, BlockPos position, Holder<Biome> biome) {
                return level.m_45524_(position, 0) == 0;
            }
        };

        public final String name;
        @javax.annotation.Nullable
        private final CachedFunction<ServerLevel, BiomeMatcher> spawnBiomeMatcher;

        private Type(String prefix, Function<ServerLevel, BiomeMatcher> spawnBiomeMatcher) {
            this.name = prefix;
            this.spawnBiomeMatcher = spawnBiomeMatcher == null ? null : CachedFunction.of(spawnBiomeMatcher);
        }

        public boolean canSpawnType(ServerLevel level, BlockPos position, Holder<Biome> biome) {
            return this.spawnBiomeMatcher == null || ((BiomeMatcher)this.spawnBiomeMatcher.apply(level)).test(biome);
        }

        public static Type fromString(String typeName) {
            for (Type type : Type.values()) {
                if (!type.name.equals(typeName)) continue;
                return type;
            }
            return DEFAULT;
        }

        public static Type create(String name, String prefix, @javax.annotation.Nullable Function<ServerLevel, BiomeMatcher> spawnBiomeMatcher) {
            throw new IllegalStateException("Enum not extended");
        }
    }
}

