/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.nether;

import com.mojang.datafixers.util.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.particletype.CustomisableParticleType;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.common.registration.entity.AoAMobEffects;
import net.tslat.aoa3.common.registration.entity.AoAMobs;
import net.tslat.aoa3.content.entity.base.AoAMonster;
import net.tslat.aoa3.content.entity.base.AoARangedMob;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.FireballEntity;
import net.tslat.aoa3.library.builder.ParticleBuilder;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableRangedAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.ConditionlessHeldAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.CustomDelayedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRetaliateTarget;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class NethengeicBeastEntity
extends AoARangedMob<NethengeicBeastEntity> {
    private static final EntityDataAccessor<Boolean> FLAME_AURA = SynchedEntityData.m_135353_(NethengeicBeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final RawAnimation FLAMETHROWER_ANIM = RawAnimation.begin().thenPlay("attack.flamethrower.start").thenPlay("attack.flamethrower.hold");
    private static final RawAnimation FLAMETHROWER_RELEASE_ANIM = RawAnimation.begin().thenPlay("attack.flamethrower.end");
    private static final RawAnimation FIRE_AURA_ANIM = RawAnimation.begin().thenPlay("misc.fire_aura");
    private static final RawAnimation FIRE_SPIN_ANIM = RawAnimation.begin().thenPlay("attack.fire_spin");
    private static final int FIREBALL = 0;
    private static final int FLAMETHROWER_OPEN = 1;
    private static final int FLAMETHROWER = 2;

    public NethengeicBeastEntity(EntityType<? extends NethengeicBeastEntity> entityType, Level world) {
        super((EntityType<? extends AoARangedMob>)entityType, world);
    }

    @Override
    public BrainActivityGroup<NethengeicBeastEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new WalkOrRunToWalkTarget().startCondition(entity -> (Boolean)IMMOBILE.get((Entity)this) == false), new FloatToSurfaceOfFluid()});
    }

    @Override
    public BrainActivityGroup<NethengeicBeastEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new SetRetaliateTarget(), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.9f), new Idle().runFor(entity -> entity.m_217043_().m_216339_(30, 60))})});
    }

    @Override
    public BrainActivityGroup<NethengeicBeastEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new AnimatableRangedAttack(0).attackInterval(entity -> entity.m_217043_().m_216332_(10, 20)).attackRadius(24.0f).whenStarting(entity -> ATTACK_STATE.set((Entity)this, 0)).whenStopping(entity -> BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)10)), (Object)30), Pair.of((Object)new CustomDelayedBehaviour(20).whenActivating(entity -> this.toggleAura()).cooldownFor(entity -> entity.m_217043_().m_216332_(180, 360)).whenStarting(entity -> {
            this.triggerAnim("posing", "fire_aura");
            if (!this.hasAura()) {
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)AoASounds.ENTITY_NETHENGEIC_BEAST_FLAME_AURA_ACTIVATE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        }).whenStopping(entity -> BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)25)), (Object)1), Pair.of((Object)((Object)new FlamethrowerAttack()), (Object)7), Pair.of((Object)((Object)new FlameSpinAttack()), (Object)7)}).startCondition(entity -> !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get())))});
    }

    @Override
    public int calculateKillXp() {
        int xp = super.calculateKillXp();
        return xp > 0 ? xp + 15 : 0;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundEvents.f_11705_;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new FireballEntity(this.f_19853_, this, BaseMobProjectile.Type.PHYSICAL);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(FLAME_AURA, (Object)false);
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 3.375f;
    }

    public int m_8085_() {
        return 10;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11784_;
    }

    @Override
    @javax.annotation.Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_NETHENGEIC_BEAST_HURT.get();
    }

    @Override
    @javax.annotation.Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_NETHENGEIC_BEAST_DEATH.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return null;
    }

    public boolean hasAura() {
        return (Boolean)this.m_20088_().m_135370_(FLAME_AURA);
    }

    public void toggleAura() {
        this.m_20088_().m_135381_(FLAME_AURA, (Object)((Boolean)this.m_20088_().m_135370_(FLAME_AURA) == false ? 1 : 0));
    }

    public boolean canSwimInFluidType(FluidType type) {
        return type != ForgeMod.EMPTY_TYPE.get();
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_() != AoAMobEffects.NETHENGEIC_CURSE.get() && super.m_7301_(effect);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.m_5776_()) {
            if (this.hasAura()) {
                for (int i = 0; i < 3; ++i) {
                    double cos = Math.cos(this.m_20185_() * RandomUtil.randomValueBetween((double)-1.0, (double)1.0));
                    double sin = Math.sin(this.m_20189_() * RandomUtil.randomValueBetween((double)-1.0, (double)1.0));
                    double startX = cos * (double)this.m_20205_() + this.m_20185_();
                    double startZ = sin * (double)this.m_20205_() + this.m_20189_();
                    double startY = this.m_20187_();
                    ParticleBuilder.forPos(new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.FIRE_AURA.get()), 0.25f, 5.0f, 1.0f, 1.0f, 1.0f, 0.75f, this.m_19879_()), startX, startY, startZ).velocity(RandomUtil.fiftyFifty() ? -1.0 : 1.0, RandomUtil.fiftyFifty() ? -1.0 : 1.0, RandomUtil.fiftyFifty() ? -1.0 : 1.0).spawnParticles();
                }
            }
            ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + RandomUtil.randomValueBetween((double)-0.2f, (double)0.2f), this.m_20188_() - 1.0 + RandomUtil.randomValueBetween((double)-0.2f, (double)0.2f), this.m_20189_() + RandomUtil.randomValueBetween((double)-0.2f, (double)0.2f)).spawnParticles();
            if (this.m_217043_().m_188503_(10) == 0) {
                ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20188_() - 1.0, this.m_20189_()).spawnParticles();
                if (this.m_20184_().m_165925_() == 0.0) {
                    ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_123800_, this.m_20185_(), this.m_20188_() - 1.0, this.m_20189_()).spawnParticles();
                }
            }
        } else if (this.hasAura() && BrainUtils.getTargetOfEntity((LivingEntity)this) == null) {
            this.toggleAura();
        }
    }

    @Override
    public void doRangedAttackEntity(@Nullable BaseMobProjectile projectile, Entity target) {
        super.doRangedAttackEntity(projectile, target);
        if (projectile == null) {
            DamageUtil.safelyDealDamage(DamageUtil.positionedEntityDamage(AoADamageTypes.MOB_FLAMETHROWER, (Entity)this, this.m_20182_()), target, 1.0f);
            if (RandomUtil.oneInNChance((int)4) && target.m_20094_() < 300) {
                target.m_20254_((int)Math.ceil((float)Math.max(0, target.m_20094_()) / 20.0f) + 1);
            }
        }
    }

    @Override
    public void onProjectileAttack(@Nullable BaseMobProjectile projectile, Entity target) {
        target.m_20254_((int)Math.ceil((float)Math.max(0, target.m_20094_()) / 20.0f) + 3);
    }

    @Override
    public void doRangedAttackBlock(@Nullable BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
        if (ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)projectile.m_19749_()) && projectile instanceof FireballEntity) {
            BlockPos firePos = pos.m_121955_(sideHit.m_122436_());
            if (!this.f_19853_.m_8055_(firePos).m_60767_().m_76336_() && !this.f_19853_.m_8055_(firePos = pos.m_121945_(Direction.UP)).m_60767_().m_76336_()) {
                return;
            }
            this.f_19853_.m_7731_(firePos, Blocks.f_50083_.m_49966_(), 3);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.hasAura()) {
            if (DamageUtil.isMeleeDamage(source)) {
                Entity entity = source.m_7640_();
                if (entity instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)entity;
                    DamageUtil.safelyDealDamage(DamageUtil.entityDamage(AoADamageTypes.MOB_FIRE_RECOIL, (Entity)this), (Entity)attacker, 3.0f);
                    attacker.m_20254_((int)Math.ceil((float)Math.max(0, attacker.m_20094_()) / 20.0f) + 2);
                    attacker.m_7292_(new MobEffectInstance((MobEffect)AoAMobEffects.NETHENGEIC_CURSE.get(), 200));
                }
            } else if (DamageUtil.isEnergyDamage(source)) {
                this.m_5634_(amount);
                return false;
            }
        }
        return super.m_6469_(source, amount);
    }

    public static boolean checkSpawnConditions(EntityType<?> entityType, LevelAccessor levelAccessor, MobSpawnType spawnReason, BlockPos blockPos, RandomSource rand) {
        Level level;
        block3: {
            block2: {
                if (!(levelAccessor instanceof Level)) break block2;
                level = (Level)levelAccessor;
                if (spawnReason == MobSpawnType.STRUCTURE || spawnReason == MobSpawnType.NATURAL) break block3;
            }
            return true;
        }
        return EntityRetrievalUtil.getEntities((Level)level, (AABB)new AABB((double)(blockPos.m_123341_() - 15), (double)(blockPos.m_123342_() - 2), (double)(blockPos.m_123343_() - 15), (double)(blockPos.m_123341_() + 15), (double)(blockPos.m_123342_() + 2), (double)(blockPos.m_123343_() + 15)), entity -> entity.m_6095_() == AoAMobs.NETHENGEIC_BEAST.get()).isEmpty();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController((GeoAnimatable)this)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "living", 0, event -> {
            if (!ATTACK_STATE.is((Entity)this, 2)) {
                event.getController().setAnimationSpeed((double)(1.0f + (1.0f - this.m_21223_() / this.m_21233_()) * 5.0f));
                event.getController().setAnimation(DefaultAnimations.LIVING);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{AoAAnimations.genericHeldPoseController(this, FLAMETHROWER_ANIM, FLAMETHROWER_RELEASE_ANIM, entity -> ATTACK_STATE.isAny((Entity)entity, 1, 2)).triggerableAnim("fire_aura", FIRE_AURA_ANIM).triggerableAnim("fire_spin", FIRE_SPIN_ANIM)});
    }

    private static class FlamethrowerAttack
    extends ConditionlessHeldAttack<NethengeicBeastEntity> {
        public FlamethrowerAttack() {
            this.requiresTarget();
            this.onTick(entity -> {
                if (this.getRunningTime() <= 24) {
                    return true;
                }
                AoAMonster.ATTACK_STATE.set((Entity)entity, 2);
                Vec3 position = entity.m_20182_();
                double baseX = position.f_82479_;
                double baseY = entity.m_20188_() - 1.0;
                double baseZ = position.f_82481_;
                ServerParticlePacket packet = new ServerParticlePacket(ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_123755_, baseX, baseY, baseZ));
                for (int i = 0; i < 5; ++i) {
                    Vec3 velocity = this.target.m_146892_().m_82492_(baseX + RandomUtil.randomScaledGaussianValue((double)0.5), baseY + RandomUtil.randomScaledGaussianValue((double)0.5), baseZ + RandomUtil.randomScaledGaussianValue((double)0.5)).m_82541_().m_82490_(0.75);
                    packet.particle(ParticleBuilder.forPos(new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.BURNING_FLAME.get()), 0.35f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, entity.m_19879_()), baseX, baseY, baseZ).velocity(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_));
                    packet.particle(ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_175834_, baseX, baseY, baseZ).velocity(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_));
                }
                AoAPackets.messageNearbyPlayers(packet, (ServerLevel)entity.f_19853_, EntityUtil.getEntityCenter((Entity)entity), 64.0);
                if (this.getRunningTime() % 9 == 0 || this.getRunningTime() % 19 == 0) {
                    entity.m_5496_((SoundEvent)AoASounds.FLAMETHROWER.get(), 2.0f, 1.0f);
                }
                return true;
            });
            this.startCondition(entity -> {
                double aggroRange;
                LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26372_);
                if (target == null) {
                    return false;
                }
                double dist = target.m_20280_((Entity)entity);
                return dist <= (aggroRange = entity.m_21133_((Attribute)AoAAttributes.AGGRO_RANGE.get())) * aggroRange && BrainUtils.canSee((LivingEntity)entity, (LivingEntity)target);
            });
            this.stopIf(entity -> {
                double distanceCutoff;
                LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26372_);
                if (target == null) {
                    return true;
                }
                double dist = target.m_20280_((Entity)entity);
                return dist > (distanceCutoff = entity.m_21133_(Attributes.f_22277_) * 0.75) * distanceCutoff || this.getRunningTime() > 80 && entity.m_217043_().m_188503_(100) == 0 || !BrainUtils.canSee((LivingEntity)entity, (LivingEntity)target);
            });
            this.cooldownFor(entity -> 160);
            this.whenStopping(entity -> {
                BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)20);
                AoAMonster.ATTACK_STATE.set((Entity)entity, 0);
            });
            this.whenStarting(entity -> AoAMonster.ATTACK_STATE.set((Entity)entity, 1));
        }
    }

    private static class FlameSpinAttack
    extends ConditionlessHeldAttack<NethengeicBeastEntity> {
        public FlameSpinAttack() {
            this.requiresTarget();
            this.runFor(entity -> 20);
            this.onTick(entity -> {
                if (this.getRunningTime() <= 5) {
                    return true;
                }
                ServerParticlePacket packet = new ServerParticlePacket();
                for (int i = -180; i <= 180; i += 8) {
                    double angle = Math.toRadians(i * entity.f_19797_);
                    double x = entity.m_20185_() + 2.0 * Math.cos(angle);
                    double y = entity.m_20186_() + (double)1.3f;
                    double z = entity.m_20189_() + 2.0 * Math.sin(angle);
                    double velocityX = x - entity.m_20185_();
                    double velocityZ = z - entity.m_20189_();
                    packet.particle(ParticleBuilder.forPos(new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.BURNING_FLAME.get()), 0.35f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, entity.m_19879_()), x, y, z).velocity(velocityX, -0.6f, velocityZ));
                    packet.particle(ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_175834_, x, y, z).velocity(velocityX, -0.6f, velocityZ));
                    packet.particle(ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_123762_, x, y, z));
                }
                AoAPackets.messageNearbyPlayers(packet, (ServerLevel)entity.f_19853_, EntityUtil.getEntityCenter((Entity)entity), 64.0);
                if (this.getRunningTime() % 9 == 0 || this.getRunningTime() % 19 == 0) {
                    entity.m_5496_((SoundEvent)AoASounds.FLAMETHROWER.get(), 2.0f, 1.0f);
                }
                return true;
            });
            this.startCondition(entity -> {
                if (entity.hasAura()) {
                    return false;
                }
                LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
                if (target == null) {
                    return false;
                }
                return entity.m_20280_((Entity)target) < 25.0 || !EntityRetrievalUtil.getEntities((Entity)entity, (double)5.0, entity2 -> PlayerUtil.getPlayerOrOwnerIfApplicable(entity2) != null).isEmpty();
            });
            this.cooldownFor(entity -> entity.m_217043_().m_216332_(100, 140));
            this.whenStarting(entity -> entity.triggerAnim("posing", "fire_spin"));
            this.whenStopping(entity -> BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)20));
        }
    }
}

