/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.nether;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.AoASoundBuilderPacket;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.particletype.CustomisableParticleType;
import net.tslat.aoa3.common.registration.AoAExplosions;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.library.builder.ParticleBuilder;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.library.object.explosion.StandardExplosion;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.ConditionlessAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class LittleBamEntity
extends AoAMeleeMob<LittleBamEntity> {
    public LittleBamEntity(EntityType<? extends LittleBamEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
        this.m_21441_(BlockPathTypes.LAVA, 4.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 1.4375f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12239_;
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12242_;
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12244_;
    }

    public float m_6100_() {
        return 2.0f;
    }

    @Override
    public List<ExtendedSensor<LittleBamEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor().setPredicate((player, entity) -> !PiglinAi.m_34808_((LivingEntity)player)), new NearbyLivingEntitySensor().setPredicate((target, entity) -> {
            OwnableEntity tamedEntity;
            return target instanceof OwnableEntity && (tamedEntity = (OwnableEntity)target).m_21805_() != null;
        }).setScanRate(entity -> 40), new HurtBySensor()});
    }

    @Override
    public BrainActivityGroup<LittleBamEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new SetWalkTargetToAttackTarget(), new ConditionlessAttack(this.getAttackSwingDuration()).attack(mob -> {
            new StandardExplosion(AoAExplosions.LITTLE_BAM_OVERLOAD, (ServerLevel)this.m_9236_(), (Entity)this, this.m_20165_(0.5), this.m_20227_(1.0), this.m_20246_(0.5)).m_46061_();
            this.m_146870_();
        }).requiresTarget().startCondition(entity -> {
            LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
            return target != null && entity.m_21574_().m_148306_((Entity)target) && entity.m_217066_(target);
        }).whenStarting(entity -> {
            this.m_21573_().m_26573_();
            IMMOBILE.set((Entity)entity, true);
            ServerParticlePacket packet = new ServerParticlePacket();
            double targetX = this.m_20165_(0.5);
            double targetY = this.m_20227_(1.25);
            double targetZ = this.m_20246_(0.5);
            for (int i = 0; i < 10; ++i) {
                double x = this.m_20208_(0.5);
                double y = this.m_20187_();
                double z = this.m_20262_(0.5);
                packet.particle(ParticleBuilder.forPos(new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.FLICKERING_SPARKLER.get()), 0.25f, 25.0f, 0x7C0000), x, y, z).velocity((x - targetX) * 2.0, (y - targetY) * 2.0, (z - targetZ) * 2.0));
            }
            AoAPackets.messageNearbyPlayers(packet, (ServerLevel)this.m_9236_(), this.m_20182_(), 64.0);
            AoAPackets.messageAllPlayersTrackingEntity(new AoASoundBuilderPacket(new SoundBuilder((SoundEvent)AoASounds.ENTITY_LITTLE_BAM_CHARGE.get()).followEntity((Entity)this)), (Entity)this);
        })});
    }

    public boolean canSwimInFluidType(FluidType type) {
        return type == ForgeMod.LAVA_TYPE.get() || super.canSwimInFluidType(type);
    }

    @Override
    protected int getAttackSwingDuration() {
        return 61;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController((GeoAnimatable)this), AoAAnimations.genericAttackAnimation(this, DefaultAnimations.ATTACK_POWERUP)});
    }
}

