/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.nether;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.builder.ParticleBuilder;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class InfernalEntity
extends AoAMeleeMob<InfernalEntity> {
    public InfernalEntity(EntityType<? extends InfernalEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
        this.m_21441_(BlockPathTypes.LAVA, 4.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 8.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    @Override
    public BrainActivityGroup<InfernalEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> {
            Player pl;
            return target instanceof Player && ((pl = (Player)target).m_7500_() || pl.m_5833_()) || this.m_20238_(target.m_20182_()) > Math.pow(this.m_21133_(Attributes.f_22277_), 2.0);
        }), new SetWalkTargetToAttackTarget(), new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration()).whenActivating(entity -> {
            LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
            BlockPos pos = (target == null ? entity : target).m_20183_();
            BlockState state = this.f_19853_.m_8055_(pos);
            if (state.m_60795_()) {
                pos = pos.m_7495_();
                state = this.f_19853_.m_8055_(pos);
            }
            BlockPos finalPos = pos;
            ServerParticlePacket packet = new ServerParticlePacket(ParticleBuilder.forPos((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), () -> new Vec3((double)((float)finalPos.m_123341_() + RandomUtil.randomValueUpTo((float)1.0f)), (double)((float)finalPos.m_123342_() + 1.1f), (double)((float)finalPos.m_123343_() + RandomUtil.randomValueUpTo((float)1.0f)))).velocity(0.0, 0.5, 0.0).spawnNTimes(3));
            entity.m_5496_((SoundEvent)AoASounds.ROCK_SMASH.get(), 1.0f, 0.2f);
            AoAPackets.messageAllPlayersTrackingEntity(packet, (Entity)entity);
            this.doSlam(finalPos, 0.75f);
        })});
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 3.09375f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12030_;
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_INFERNAL_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_INFERNAL_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_HEAVY_STEP.get();
    }

    @Override
    protected int getAttackSwingDuration() {
        return 22;
    }

    @Override
    protected int getPreAttackTime() {
        return 10;
    }

    private void doSlam(BlockPos fromPos, float chance) {
        ServerParticlePacket packet = new ServerParticlePacket();
        boolean sendPacket = false;
        for (Direction dir : Direction.values()) {
            BlockPos pos;
            if (!RandomUtil.percentChance((float)chance) || this.f_19853_.m_8055_(pos = fromPos.m_121955_(dir.m_122436_())).m_60734_() != Blocks.f_50134_) continue;
            int tickTime = Math.max(1, 1 - pos.m_123333_((Vec3i)fromPos));
            sendPacket = true;
            packet.particle(ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_123744_, (float)pos.m_123341_() + RandomUtil.randomValueUpTo((float)1.0f), (double)pos.m_123342_() + 1.1, (float)pos.m_123343_() + RandomUtil.randomValueUpTo((float)1.0f)));
            this.f_19853_.m_7731_(pos, Blocks.f_50450_.m_49966_(), 3);
            AoAScheduler.scheduleSyncronisedTask(() -> this.doSlam(pos, chance * 0.8f), tickTime);
            AoAScheduler.scheduleSyncronisedTask(() -> {
                if (this.f_19853_.m_8055_(pos).m_60734_() == Blocks.f_50450_) {
                    this.f_19853_.m_7731_(pos, Blocks.f_50134_.m_49966_(), 3);
                }
            }, tickTime + 100);
        }
        if (sendPacket) {
            AoAPackets.messageAllPlayersTrackingEntity(packet, (Entity)this);
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericLivingController((GeoAnimatable)this)});
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController((GeoAnimatable)this)});
        controllers.add(new AnimationController[]{AoAAnimations.genericAttackAnimation(this, DefaultAnimations.ATTACK_STRIKE)});
    }
}

