/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.nether;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.particletype.CustomisableParticleType;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.common.registration.entity.AoAMobEffects;
import net.tslat.aoa3.content.entity.base.AoARangedMob;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.library.builder.ParticleBuilder;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableRangedAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class FlamewalkerEntity
extends AoARangedMob<FlamewalkerEntity> {
    public FlamewalkerEntity(EntityType<? extends FlamewalkerEntity> entityType, Level world) {
        super((EntityType<? extends AoARangedMob>)entityType, world);
        this.m_21441_(BlockPathTypes.LAVA, 4.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 8.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    @Override
    public BrainActivityGroup<FlamewalkerEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new StayWithinDistanceOfAttackTarget(), new FlameWalkerAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration())});
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 2.03125f;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_FLAMEWALKER_AMBIENT.get();
    }

    @Override
    @javax.annotation.Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_FLAMEWALKER_DEATH.get();
    }

    @Override
    @javax.annotation.Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_FLAMEWALKER_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return null;
    }

    public boolean canSwimInFluidType(FluidType type) {
        return type == ForgeMod.LAVA_TYPE.get();
    }

    @Override
    protected int getAttackSwingDuration() {
        return 32;
    }

    @Override
    protected int getPreAttackTime() {
        return 16;
    }

    @Override
    public void m_6504_(LivingEntity target, float distanceFactor) {
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return null;
    }

    @Override
    protected void onHurt(DamageSource source, float amount) {
        if (DamageUtil.isMeleeDamage(source)) {
            Entity target = source.m_7639_();
            target.m_20254_(3);
            if (DamageUtil.safelyDealDamage(DamageUtil.entityDamage(AoADamageTypes.MOB_FIRE_RECOIL, (Entity)this), target, 3.0f) && this.rand().oneInNChance(15)) {
                EntityUtil.applyPotions(target, new EffectBuilder((MobEffect)AoAMobEffects.BURNED.get(), 600));
            }
        }
    }

    @Override
    public void doRangedAttackEntity(@Nullable BaseMobProjectile projectile, Entity target) {
        if (target.m_20094_() < 200) {
            target.m_20254_((int)Math.ceil((float)Math.max(0, target.m_20094_()) / 20.0f) + 1);
        }
        if (DamageUtil.safelyDealDamage(DamageUtil.positionedEntityDamage(AoADamageTypes.MOB_FLAMETHROWER, (Entity)this, this.m_20182_()), target, (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get())) && this.rand().oneInNChance(10)) {
            EntityUtil.applyPotions(target, new EffectBuilder((MobEffect)AoAMobEffects.BURNED.get(), 600));
        }
    }

    public boolean m_6126_() {
        return true;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericLivingController((GeoAnimatable)this), DefaultAnimations.genericWalkIdleController((GeoAnimatable)this), AoAAnimations.genericAttackAnimation(this, DefaultAnimations.ATTACK_STRIKE)});
    }

    private static class FlameWalkerAttack
    extends AnimatableRangedAttack<FlamewalkerEntity> {
        private Vec3 targetingPosition = null;

        public FlameWalkerAttack(int delayTicks) {
            super(delayTicks);
        }

        protected void start(FlamewalkerEntity entity) {
            super.start((LivingEntity)entity);
            this.targetingPosition = this.target.m_20182_().m_82520_((double)(this.target.m_20205_() * 0.5f), 0.0, (double)(this.target.m_20205_() * 0.5f));
            ServerParticlePacket packet = new ServerParticlePacket(ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_175834_, () -> new Vec3(this.targetingPosition.f_82479_ + entity.rand().randomValueBetween(-1.0, 1.0), this.targetingPosition.f_82480_ + (double)0.1f, this.targetingPosition.f_82481_ + entity.rand().randomValueBetween(-1.0, 1.0))).spawnNTimes(10));
            entity.f_19853_.m_6263_(null, this.targetingPosition.f_82479_, this.targetingPosition.f_82480_, this.targetingPosition.f_82481_, (SoundEvent)AoASounds.ENTITY_FLAMEWALKER_FLARE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            AoAPackets.messageAllPlayersTrackingEntity(packet, (Entity)entity);
        }

        protected void doDelayedAction(FlamewalkerEntity entity) {
            if (this.target == null) {
                return;
            }
            if (!BrainUtils.canSee((LivingEntity)entity, (LivingEntity)this.target) || entity.m_20280_((Entity)this.target) > (double)this.attackRadius) {
                return;
            }
            ServerParticlePacket packet = new ServerParticlePacket(15);
            for (int i = 0; i < 15; ++i) {
                packet.particle(ParticleBuilder.forPos(new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.BURNING_FLAME.get()), 0.5f, 2.0f, 1.0f, 1.0f, 1.0f, 1.0f, entity.m_19879_()), this.targetingPosition.f_82479_ + entity.rand().randomValueBetween(-1.0, 1.0), this.targetingPosition.f_82480_, this.targetingPosition.f_82481_ + entity.rand().randomValueBetween(-1.0, 1.0)).velocity(entity.rand().randomValueBetween((double)-0.05f, (double)0.05f), 0.5, entity.rand().randomValueBetween((double)-0.05f, (double)0.05f)));
            }
            AoAPackets.messageAllPlayersTrackingEntity(packet, (Entity)entity);
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26373_, (Object)true, (int)((Integer)this.attackIntervalSupplier.apply(entity)));
        }

        protected void stop(FlamewalkerEntity entity) {
            super.stop((LivingEntity)entity);
            this.targetingPosition = null;
        }
    }
}

