/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.nether;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.particletype.CustomisableParticleType;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.base.AoAMonster;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.library.builder.ParticleBuilder;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.ConditionlessHeldAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;

public class EmbrakeEntity
extends AoAMeleeMob<EmbrakeEntity>
implements AoARangedAttacker {
    private static final RawAnimation BREATH_ATTACK = RawAnimation.begin().thenPlay("attack.breath.start").thenPlay("attack.breath.hold");
    private static final RawAnimation BREATH_ATTACK_END = RawAnimation.begin().thenPlay("attack.breath.end");

    public EmbrakeEntity(EntityType<? extends EmbrakeEntity> entityType, Level world) {
        super((EntityType<? extends AoAMeleeMob>)entityType, world);
        this.setParts(new AoAEntityPart<EmbrakeEntity>(this, this.m_20205_(), this.m_20206_(), 0.0f, 0.0f, this.m_20205_()).setDamageMultiplier(1.25f), new AoAEntityPart<EmbrakeEntity>(this, this.m_20205_(), this.m_20206_(), 0.0f, 0.0f, -this.m_20205_()), new AoAEntityPart<EmbrakeEntity>(this, this.m_20205_() * 0.75f, this.m_20206_() * 0.75f, 0.0f, 0.0f, -this.m_20205_() * 1.875f).setDamageMultiplier(0.75f));
    }

    @Override
    public BrainActivityGroup<EmbrakeEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new AnimatableMeleeAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration()), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new BreathAttack(), new WalkUpToTarget()})})});
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
    }

    @Override
    public void doRangedAttackEntity(@Nullable BaseMobProjectile projectile, Entity target) {
        DamageUtil.safelyDealDamage(DamageUtil.positionedEntityDamage(AoADamageTypes.MOB_FLAMETHROWER, (Entity)this, this.m_20182_()), target, (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()));
        if (RandomUtil.oneInNChance((int)5) && target.m_20094_() < 200) {
            target.m_20254_((int)Math.ceil((float)Math.max(0, target.m_20094_()) / 20.0f) + 1);
        }
    }

    @Override
    public void doRangedAttackBlock(@Nullable BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.8125f;
    }

    public int m_8085_() {
        return 30;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.LARGE_LIZARD_HISS.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_EMBRAKE_DEATH.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_EMBRAKE_HURT.get();
    }

    @Override
    @javax.annotation.Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_DINO_STEP.get();
    }

    @Override
    protected int getPreAttackTime() {
        return 7;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 10;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController((GeoAnimatable)this), AoAAnimations.genericAttackAnimation(this, DefaultAnimations.ATTACK_BITE).triggerableAnim("breath_start", BREATH_ATTACK).triggerableAnim("breath_stop", BREATH_ATTACK_END)});
    }

    private static class BreathAttack
    extends ConditionlessHeldAttack<EmbrakeEntity> {
        public BreathAttack() {
            this.onTick(entity -> {
                if (this.getRunningTime() <= 15) {
                    return true;
                }
                Vec3 position = entity.m_20182_();
                Vec3 direction = position.m_82549_(Vec3.m_82498_((float)0.0f, (float)entity.f_20883_));
                double baseX = direction.f_82479_;
                double baseY = entity.m_20188_() - (double)0.3f;
                double baseZ = direction.f_82481_;
                ServerParticlePacket packet = new ServerParticlePacket(ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_123762_, baseX, baseY, baseZ));
                for (int i = 0; i < 5; ++i) {
                    Vec3 velocity = this.target.m_20182_().m_82492_(position.f_82479_ + RandomUtil.randomScaledGaussianValue((double)0.5), position.f_82480_ + RandomUtil.randomScaledGaussianValue((double)0.5) - 0.3, position.f_82481_ + RandomUtil.randomScaledGaussianValue((double)0.5)).m_82541_().m_82490_(0.75);
                    packet.particle(ParticleBuilder.forPos(new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.BURNING_FLAME.get()), 0.3f, 3.0f, 0.0f, 0.0f, 0.0f, 0.0f, entity.m_19879_()), baseX, baseY, baseZ).velocity(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_));
                    packet.particle(ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_175834_, baseX, baseY, baseZ).velocity(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_));
                }
                AoAPackets.messageNearbyPlayers(packet, (ServerLevel)entity.f_19853_, entity.m_146892_(), 64.0);
                if (this.getRunningTime() % 9 == 0 || this.getRunningTime() % 19 == 0) {
                    entity.m_5496_((SoundEvent)AoASounds.FLAMETHROWER.get(), 2.0f, 1.0f);
                }
                return true;
            });
            this.requiresTarget();
            this.startCondition(entity -> {
                double aggroRange;
                LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26372_);
                if (target == null) {
                    return false;
                }
                double dist = target.m_20280_((Entity)entity);
                return dist <= (aggroRange = entity.m_21133_((Attribute)AoAAttributes.AGGRO_RANGE.get())) * aggroRange && !entity.m_217066_(target) && BrainUtils.canSee((LivingEntity)entity, (LivingEntity)target);
            });
            this.stopIf(entity -> {
                double distanceCutoff;
                LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26372_);
                if (target == null) {
                    return true;
                }
                double dist = target.m_20280_((Entity)entity);
                return dist > (distanceCutoff = entity.m_21133_(Attributes.f_22277_) * 0.75) * distanceCutoff || entity.m_217066_(target) || !BrainUtils.canSee((LivingEntity)entity, (LivingEntity)target);
            });
            this.cooldownFor(entity -> 10);
            this.whenStarting(entity -> {
                entity.triggerAnim("Attack", "breath_start");
                AoAMonster.IMMOBILE.set((Entity)entity, true);
            });
            this.whenStopping(entity -> {
                entity.triggerAnim("Attack", "breath_stop");
                AoAMonster.IMMOBILE.set((Entity)entity, false);
            });
        }
    }

    private static class WalkUpToTarget
    extends SetWalkTargetToAttackTarget<EmbrakeEntity> {
        private WalkUpToTarget() {
        }

        protected void start(EmbrakeEntity entity) {
            Brain brain = entity.m_6274_();
            LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
            if (entity.m_21574_().m_148306_((Entity)target) && BehaviorUtils.m_22632_((Mob)entity, (LivingEntity)target, (int)1)) {
                BrainUtils.clearMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26370_);
            } else {
                BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)target, true));
                BrainUtils.setMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)target, false), this.speedModifier, 4));
            }
        }
    }
}

