/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.gardencia;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.base.AoARangedMob;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.VineWizardShotEntity;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;

public class VineWizardEntity
extends AoARangedMob<VineWizardEntity> {
    private static final AttributeModifier CANDIED_WATER_BUFF = new AttributeModifier(UUID.fromString("d5356e33-40b6-4515-a37b-4377f911f703"), "AoAGardenciaCandiedWaterBuff", 50.0, AttributeModifier.Operation.ADDITION);
    private boolean candiedWater = false;

    public VineWizardEntity(EntityType<? extends VineWizardEntity> entityType, Level world) {
        super((EntityType<? extends AoARangedMob>)entityType, world);
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.875f;
    }

    @Override
    protected void m_7355_(BlockPos pos, BlockState block) {
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return (SoundEvent)AoASounds.ENTITY_VINE_WIZARD_SHOOT.get();
    }

    @Override
    public void m_6504_(@Nonnull LivingEntity target, float bowDamageFactor) {
        this.f_19853_.m_7967_((Entity)new VineWizardShotEntity(this, (Entity)target, BaseMobProjectile.Type.MAGIC));
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return null;
    }

    protected void m_6763_(BlockState state) {
        if (state.m_60734_() == AoABlocks.CANDIED_WATER.get() && !this.candiedWater) {
            EntityUtil.applyAttributeModifierSafely((LivingEntity)this, Attributes.f_22276_, CANDIED_WATER_BUFF, false);
            this.m_21153_(this.m_21223_() * 1.5f);
            this.candiedWater = true;
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.candiedWater) {
            compound.m_128379_("AoACandiedWater", true);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.candiedWater = compound.m_128441_("AoACandiedWater");
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && this.m_21223_() < this.m_21233_()) {
            if (this.m_20069_()) {
                this.m_5634_(0.2f);
            } else if (this.f_19853_.m_46758_(this.m_20183_())) {
                this.m_5634_(0.1f);
            }
        }
    }

    @Override
    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (!this.f_19853_.f_46443_ && this.candiedWater && source.m_7639_() instanceof Player && ItemUtil.findInventoryItem((Player)source.m_7639_(), new ItemStack((ItemLike)AoAItems.BLANK_REALMSTONE.get()), true, 1)) {
            ItemUtil.givePlayerItemOrDrop((Player)source.m_7639_(), new ItemStack((ItemLike)AoAItems.LBOREAN_REALMSTONE.get()));
        }
    }
}

