/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.misc.pixon;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.content.item.tool.misc.InfusionBowl;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;

public abstract class PixonEntity
extends PathfinderMob {
    public long nextHarvestTick = 0L;

    public PixonEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 0.75));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.55));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("Random spawn health bonus", (double)this.f_19796_.m_188503_(30), AttributeModifier.Operation.ADDITION));
        this.m_21153_(this.m_21233_());
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_147207_(MobEffectInstance effectInstanceIn, @Nullable Entity source) {
        return false;
    }

    public boolean m_5801_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public int m_5792_() {
        return 1;
    }

    public boolean canHarvest(ServerPlayer player, ItemStack bowlStack) {
        if (this.f_19853_.m_46467_() >= this.nextHarvestTick && bowlStack.m_41720_() instanceof InfusionBowl) {
            InfusionBowl bowl = (InfusionBowl)bowlStack.m_41720_();
            if (player.m_7500_() || PlayerUtil.doesPlayerHaveLevel((Player)player, (AoASkill)AoASkills.IMBUING.get(), this.getHarvestLevelReq() + bowl.getHarvestReqModifier())) {
                return true;
            }
            PlayerUtil.notifyPlayerOfInsufficientLevel(player, (AoASkill)AoASkills.IMBUING.get(), this.getHarvestLevelReq() + bowl.getHarvestReqModifier());
        }
        return false;
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType reason) {
        if (!EntityUtil.isNaturalSpawnReason(reason)) {
            return true;
        }
        if (!super.m_5545_(world, reason)) {
            return false;
        }
        return false;
    }

    public boolean m_20147_() {
        return true;
    }

    public boolean m_6673_(DamageSource source) {
        return !source.m_276093_(DamageTypes.f_268724_);
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 0.65f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_PIXON_AMBIENT.get();
    }

    protected float m_6121_() {
        return 0.6f;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return null;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    public SoundEvent m_5896_(int heightIn) {
        return null;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    public abstract int getHarvestLevelReq();
}

