/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.brain.task.temp;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.aoa3.common.registration.entity.AoABrainMemories;
import net.tslat.aoa3.common.registration.entity.AoABrainSensors;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class NearbyItemsSensor<E extends Mob>
extends PredicateSensor<ItemEntity, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{(MemoryModuleType)AoABrainMemories.NEARBY_ITEMS.get()});
    protected SquareRadius radius = new SquareRadius(32.0, 16.0);

    public NearbyItemsSensor() {
        super((item, entity) -> entity.m_7243_(item.m_32055_()) && entity.m_142582_((Entity)item));
    }

    public NearbyItemsSensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public NearbyItemsSensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)AoABrainSensors.NEARBY_ITEMS.get();
    }

    protected void doTick(ServerLevel level, E entity) {
        BrainUtils.setMemory(entity, (MemoryModuleType)((MemoryModuleType)AoABrainMemories.NEARBY_ITEMS.get()), (Object)EntityRetrievalUtil.getEntities((Level)level, (AABB)this.radius.inflateAABB(entity.m_20191_()), obj -> {
            if (!(obj instanceof ItemEntity)) return false;
            ItemEntity item = (ItemEntity)obj;
            if (!this.predicate().test(item, entity)) return false;
            return true;
        }));
    }
}

