/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.brain.task.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.library.builder.ParticleBuilder;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.ConditionlessAttack;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class GroundSlamAttack<E extends LivingEntity>
extends ConditionlessAttack<E> {
    private SquareRadius radius = new SquareRadius(10.0, 10.0);

    public GroundSlamAttack(int delayTicks) {
        super(delayTicks);
        this.attack(this::doSlam);
    }

    public GroundSlamAttack<E> radius(int radius) {
        return this.radius(radius, radius);
    }

    public GroundSlamAttack<E> radius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    protected void doSlam(E entity) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        ServerParticlePacket packet = new ServerParticlePacket();
        Level level = entity.m_9236_();
        RandomSource rand = entity.m_217043_();
        int x = entity.m_146903_() - (int)this.radius.xzRadius();
        while ((double)x < (double)entity.m_146903_() + this.radius.xzRadius()) {
            int z = entity.m_146907_() - (int)this.radius.xzRadius();
            while ((double)z < (double)entity.m_146907_() + this.radius.xzRadius()) {
                BlockState groundState = null;
                int y = Math.max(entity.m_146904_() - (int)this.radius.yRadius(), level.m_141937_());
                while ((double)y < (double)entity.m_146904_() + this.radius.yRadius()) {
                    BlockState state = level.m_8055_((BlockPos)pos.m_122178_(x, y, z));
                    if (state.m_60767_().m_76334_()) {
                        groundState = state;
                    } else if (groundState != null) {
                        packet.particle(ParticleBuilder.forPos((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, groundState), () -> new Vec3((double)((float)pos.m_123341_() + rand.m_188501_()), (double)pos.m_123342_() + 0.1, (double)((float)pos.m_123343_() + rand.m_188501_()))).spawnNTimes(3));
                        groundState = null;
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        AoAPackets.messageNearbyPlayers(packet, (ServerLevel)level, entity.m_20182_(), 50.0);
        for (LivingEntity target2 : EntityRetrievalUtil.getEntities(entity, (double)this.radius.xzRadius(), (double)this.radius.yRadius(), (double)this.radius.xzRadius(), target -> {
            Player pl;
            return target.m_6084_() && target.m_20096_() && target instanceof LivingEntity && (!(target instanceof Player) || !(pl = (Player)target).m_7500_());
        })) {
            entity.m_7327_((Entity)target2);
        }
    }
}

