/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.brain.task.custom;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.smartbrainlib.api.core.behaviour.DelayedBehaviour;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class ChargeAttack<E extends PathfinderMob>
extends DelayedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED)});
    protected float speedMod = 1.0f;
    private boolean targetWhenCharging = false;
    private Vec3 chargeVelocity;

    public ChargeAttack(int delayTicks) {
        super(delayTicks);
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    public ChargeAttack<E> speedModifier(float speedMod) {
        this.speedMod = speedMod;
        return this;
    }

    public ChargeAttack<E> targetWhenCharging() {
        this.targetWhenCharging = true;
        return this;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return Math.abs(BrainUtils.getTargetOfEntity(entity).m_20186_() - entity.m_20186_()) < 2.0;
    }

    protected void start(E entity) {
        this.calculateTarget(entity);
        BrainUtils.clearMemories(entity, (MemoryModuleType[])new MemoryModuleType[]{MemoryModuleType.f_26370_, MemoryModuleType.f_26371_, MemoryModuleType.f_26377_});
        entity.m_20334_(0.0, entity.m_20184_().f_82480_, 0.0);
    }

    public void calculateTarget(E entity) {
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        if (target == null) {
            return;
        }
        double moveSpeed = Math.max((double)entity.m_6113_(), entity.m_21133_(Attributes.f_22279_)) * 2.0;
        Vec3 targetPos = new Vec3(target.m_20165_(0.5), 0.0, target.m_20246_(0.5));
        Vec3 entityPos = new Vec3(entity.m_20165_(0.5), 0.0, entity.m_20246_(0.5));
        this.chargeVelocity = targetPos.m_82546_(entityPos).m_82541_().m_82542_(moveSpeed, 0.0, moveSpeed).m_82492_(0.0, entity.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get()), 0.0);
        this.f_22524_ = this.delayFinishedAt + 1L + (long)Math.max(20, (int)(entityPos.m_82554_(targetPos) / (moveSpeed * 0.25)));
        entity.m_7618_(EntityAnchorArgument.Anchor.FEET, targetPos);
    }

    protected boolean canStillUse(ServerLevel level, E entity, long gameTime) {
        return !((PathfinderMob)entity).f_19862_;
    }

    protected void tick(E entity) {
        if (this.delayFinishedAt <= ((PathfinderMob)entity).f_19853_.m_46467_()) {
            entity.m_20115_(3, true);
            entity.m_20256_(this.chargeVelocity);
            entity.m_7618_(EntityAnchorArgument.Anchor.FEET, entity.m_20182_().m_82549_(this.chargeVelocity));
            for (LivingEntity target2 : EntityRetrievalUtil.getEntities((Level)((PathfinderMob)entity).f_19853_, (AABB)entity.m_20191_().m_82369_(this.chargeVelocity), target -> {
                Player pl;
                return target != entity && target.m_6084_() && target instanceof LivingEntity && (!(target instanceof Player) || !(pl = (Player)target).m_7500_());
            })) {
                entity.m_7327_((Entity)target2);
                EntityUtil.pushEntityAway(entity, (Entity)target2, 1.5f);
            }
        }
    }

    protected void doDelayedAction(E entity) {
        if (this.targetWhenCharging) {
            this.calculateTarget(entity);
        }
    }

    protected void stop(E entity) {
        entity.m_20115_(3, false);
    }
}

