/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.brain.sensor;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class AggroBasedNearbyPlayersSensor<E extends LivingEntity>
extends NearbyPlayersSensor<E> {
    private BiPredicate<E, Player> targetablePredicate = Sensor::m_26803_;
    private BiPredicate<E, Player> attackablePredicate = Sensor::m_148312_;

    public AggroBasedNearbyPlayersSensor<E> onlyTargeting(BiPredicate<E, Player> predicate) {
        this.targetablePredicate = predicate;
        return this;
    }

    public AggroBasedNearbyPlayersSensor<E> onlyAttacking(BiPredicate<E, Player> predicate) {
        this.attackablePredicate = predicate;
        return this;
    }

    protected void m_5578_(ServerLevel level, E entity) {
        SquareRadius radius = this.radius;
        if (radius == null) {
            double dist = entity.m_21133_((Attribute)AoAAttributes.AGGRO_RANGE.get());
            radius = new SquareRadius(dist, dist);
        }
        List players = EntityRetrievalUtil.getPlayers((Level)level, (AABB)radius.inflateAABB(entity.m_20191_()), player -> this.predicate().test(player, entity));
        players.sort(Comparator.comparingDouble(arg_0 -> entity.m_20280_(arg_0)));
        ObjectArrayList targetablePlayers = new ObjectArrayList((Collection)players);
        targetablePlayers.removeIf(pl -> !this.targetablePredicate.test(entity, (Player)pl));
        ObjectArrayList attackablePlayers = new ObjectArrayList((Collection)targetablePlayers);
        attackablePlayers.removeIf(pl -> !this.attackablePredicate.test(entity, (Player)pl));
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26367_, (Object)players);
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26368_, targetablePlayers.isEmpty() ? null : (Player)targetablePlayers.get(0));
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_148206_, attackablePlayers.isEmpty() ? null : (Player)attackablePlayers.get(0));
    }
}

