/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.boss.smash;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidType;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.boss.AoABoss;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.content.entity.brain.task.custom.ChargeAttack;
import net.tslat.aoa3.content.entity.brain.task.custom.GroundSlamAttack;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.effectslib.api.util.EffectBuilder;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.CustomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.ReactToUnreachableTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FleeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EliteSmashEntity
extends AoABoss {
    protected static final EntityDataAccessor<Boolean> ENRAGED = SynchedEntityData.m_135353_(EliteSmashEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final AttributeModifier ENRAGED_DAMAGE_MOD = new AttributeModifier(UUID.fromString("104c09f0-28cc-43dd-81c0-10de6b3083bd"), "EnragedDamageModifier", (double)0.95f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier ENRAGED_ARMOUR_MOD = new AttributeModifier(UUID.fromString("bbbdf964-689b-4bcf-9a23-122a7bba682e"), "EnragedArmourModifier", (double)0.9f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier ENRAGED_TOUGHNESS_MOD = new AttributeModifier(UUID.fromString("ac843c67-4731-4e77-85e9-6992bd92ae4b"), "EnragedToughnessModifier", (double)1.1f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final int AXE_SWING_STATE = 0;
    private static final int AXE_SLAM_STATE = 1;
    private static final int CHARGE_STATE = 2;
    private static final RawAnimation WALK_BOTTOM_HALF = RawAnimation.begin().thenPlay("move.walk.bottom_half");
    private static final RawAnimation WALK_TOP_HALF = RawAnimation.begin().thenPlay("move.walk.top_half");
    private static final RawAnimation RUN_BOTTOM_HALF = RawAnimation.begin().thenPlay("move.run.bottom_half");
    private static final RawAnimation RUN_TOP_HALF = RawAnimation.begin().thenPlay("move.run.top_half");
    private static final RawAnimation ENRAGE = RawAnimation.begin().thenPlay("misc.enrage");
    private static final RawAnimation ENRAGED_IDLE = RawAnimation.begin().thenPlay("misc.idle.enraged");
    private static final RawAnimation CHARGE_UP = RawAnimation.begin().thenPlay("misc.charge_up");
    private static final RawAnimation CHARGE = RawAnimation.begin().thenPlay("move.charge");
    private static final RawAnimation BELLY_DRUM = RawAnimation.begin().thenPlay("misc.belly_drum");

    public EliteSmashEntity(EntityType<? extends AoABoss> entityType, Level level) {
        super(entityType, level);
        this.f_19793_ = 1.25f;
    }

    @Override
    protected void addSwingData(AoABoss.SwingData swings) {
        swings.put(0, new AoABoss.SwingData.Swing(20, 13, RawAnimation.begin().thenPlay("attack.axe_swing")));
        swings.put(1, new AoABoss.SwingData.Swing(20, 17, RawAnimation.begin().thenPlay("attack.axe_slam")));
        swings.put(2, new AoABoss.SwingData.Swing(0, 0, RawAnimation.begin().thenPlay("attack.axe_slam")));
    }

    @Override
    @Nullable
    public SoundEvent getMusic() {
        return (SoundEvent)AoASounds.SMASH_MUSIC.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.LARGE_CREATURE_GROAN.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.LARGE_CREATURE_GRUNT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_HEAVY_STEP.get();
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 3.0625f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ENRAGED, (Object)false);
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if ((double)EntityUtil.getCurrentHealthPercent((LivingEntity)this) < 0.3 && !this.isEnraged()) {
            this.enrage();
        }
    }

    protected void enrage() {
        if (!this.isEnraged()) {
            this.m_20088_().m_135381_(ENRAGED, (Object)true);
            EntityUtil.applyAttributeModifierSafely((LivingEntity)this, Attributes.f_22281_, ENRAGED_DAMAGE_MOD, true);
            EntityUtil.applyAttributeModifierSafely((LivingEntity)this, Attributes.f_22284_, ENRAGED_ARMOUR_MOD, true);
            EntityUtil.applyAttributeModifierSafely((LivingEntity)this, Attributes.f_22285_, ENRAGED_TOUGHNESS_MOD, true);
            this.triggerAnim("arms_controller", "enrage");
            new SoundBuilder((Supplier<SoundEvent>)AoASounds.ENTITY_SMASH_ENRAGE).followEntity((Entity)this).category(SoundSource.HOSTILE).execute();
            BrainUtils.setForgettableMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.f_26373_, (Object)true, (int)100);
            BrainUtils.setForgettableMemory((LivingEntity)this, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)100);
        }
    }

    public boolean isEnraged() {
        return (Boolean)this.m_20088_().m_135370_(ENRAGED);
    }

    public boolean m_213824_() {
        return !ATTACK_STATE.is((Entity)this, 1);
    }

    public double getFluidMotionScale(FluidType type) {
        return Math.min(1.0, super.getFluidMotionScale(type) * 4.0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Enraged", this.isEnraged());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Enraged")) {
            this.m_20088_().m_135381_(ENRAGED, (Object)compound.m_128471_("Enraged"));
        }
    }

    @Override
    public List<ExtendedSensor<AoABoss>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor(), new HurtBySensor(), new UnreachableTargetSensor()});
    }

    @Override
    public BrainActivityGroup<AoABoss> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget().startCondition(entity -> !ATTACK_STATE.is((Entity)this, 2)), new WalkOrRunToWalkTarget().startCondition(entity -> !ATTACK_STATE.is((Entity)this, 2))});
    }

    @Override
    public BrainActivityGroup<AoABoss> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().useMemory(MemoryModuleType.f_148206_).startCondition(entity -> !ATTACK_STATE.is((Entity)this, 2)), new Idle().runFor(entity -> entity.m_217043_().m_216339_(15, 45))}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.9f), new Idle().runFor(entity -> entity.m_217043_().m_216339_(30, 60))})});
    }

    public BrainActivityGroup<AoABoss> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new SetWalkTargetToAttackTarget().speedMod(1.1f).startCondition(entity -> !ATTACK_STATE.is((Entity)this, 2)), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new OneRandomBehaviour(new Pair[]{Pair.of((Object)new GroundSlamAttack(this.getSwingWarmupTicks(1)).requiresTarget().whenActivating(entity -> this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)AoASounds.HEAVY_WOODEN_IMPACT.get(), this.m_5720_(), 1.0f, 1.0f)).cooldownFor(entity -> 5 + (int)((float)this.getSwingDurationTicks(1) * entity.m_217043_().m_188501_() * 1.5f)).startCondition(mob -> ATTACK_STATE.is((Entity)this, 1)).whenStopping(entity -> ATTACK_STATE.set((Entity)this, 0)), (Object)20), Pair.of((Object)new FleeTarget().fleeDistance(40).startCondition(entity -> BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.TARGET_UNREACHABLE.get())) && this.isEnraged()), (Object)1)}), new ReactToUnreachableTarget().timeBeforeReacting(entity -> 40).reaction((entity, isTowering) -> {
            this.enrage();
            ATTACK_STATE.set((Entity)this, 1);
        }), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new GroundSlamAttack(this.getSwingWarmupTicks(1)).radius(5).requiresTarget().whenActivating(entity -> this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)AoASounds.HEAVY_WOODEN_IMPACT.get(), this.m_5720_(), 1.0f, 0.5f)).whenStarting(entity -> ATTACK_STATE.set((Entity)this, 1)).startCondition(entity -> {
            LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
            return target != null && target.m_20280_((Entity)entity) < 25.0;
        }).whenStopping(entity -> {
            ATTACK_STATE.set((Entity)this, 0);
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26373_, (Object)true, (int)(5 + (int)((float)this.getSwingDurationTicks(1) * entity.m_217043_().m_188501_() * 5.0f)));
        }), (Object)1), Pair.of((Object)new AnimatableMeleeAttack(this.getSwingWarmupTicks(0)).attackInterval(entity -> this.getSwingDurationTicks(0) + entity.m_217043_().m_216339_(5, 15)).startCondition(mob -> ATTACK_STATE.is((Entity)this, 0)), (Object)5)}).startCondition(entity -> !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26373_)), new OneRandomBehaviour(new ExtendedBehaviour[]{new CustomBehaviour(entity -> {
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26373_, (Object)true, (int)90);
            this.triggerAnim("arms_controller", "belly_drum");
            new SoundBuilder((Supplier<SoundEvent>)AoASounds.ENTITY_SMASH_BELLY_DRUM).isMonster().followEntity((Entity)this).execute();
            EntityUtil.applyPotions((Entity)entity, new EffectBuilder(MobEffects.f_19606_, 100).level(2), new EffectBuilder(MobEffects.f_19596_, 100), new EffectBuilder(MobEffects.f_19600_, 100).level(5));
        }).startCondition(entity -> BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26372_) && !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()))).cooldownFor(entity -> 150).whenStopping(entity -> BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)150)), new ChargeAttack(38).speedModifier(1.6f).targetWhenCharging().whenStarting(entity -> {
            this.triggerAnim("arms_controller", "charge_up");
            ATTACK_STATE.set((Entity)this, 2);
        }).whenStopping(entity -> {
            ATTACK_STATE.set((Entity)this, 0);
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)150);
        }).cooldownFor(entity -> 150)})})});
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "legs_controller", 0, state -> {
            if (state.isMoving()) {
                return state.setAndContinue(this.m_20142_() ? RUN_BOTTOM_HALF : WALK_BOTTOM_HALF);
            }
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "arms_controller", 3, state -> {
            if (ATTACK_STATE.is((Entity)this, 2)) {
                return state.setAndContinue(CHARGE);
            }
            if (this.f_20911_) {
                return state.setAndContinue(this.getSwingAnimation());
            }
            if (state.isMoving()) {
                return state.setAndContinue(this.m_20142_() ? RUN_TOP_HALF : WALK_TOP_HALF);
            }
            return state.setAndContinue(this.isEnraged() ? ENRAGED_IDLE : DefaultAnimations.IDLE);
        }).triggerableAnim("enrage", ENRAGE).triggerableAnim("belly_drum", BELLY_DRUM).triggerableAnim("charge_up", CHARGE_UP)});
    }
}

