/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.boss.nethengeic_wither;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.particletype.CustomisableParticleType;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoAExplosions;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoABrainActivities;
import net.tslat.aoa3.common.registration.entity.AoABrainMemories;
import net.tslat.aoa3.common.registration.entity.AoADamageTypes;
import net.tslat.aoa3.common.registration.entity.AoAMobEffects;
import net.tslat.aoa3.content.entity.ai.movehelper.AirborneMoveControl;
import net.tslat.aoa3.content.entity.base.AoAMonster;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.boss.AoABoss;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.FireballEntity;
import net.tslat.aoa3.library.builder.ParticleBuilder;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.library.object.explosion.StandardExplosion;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PositionAndMotionUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableRangedAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.ConditionlessHeldAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.CustomDelayedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.InvalidateMemory;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomHoverTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetAdditionalAttackTargets;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class EliteNethengeicWitherEntity
extends AoABoss
implements AoARangedAttacker {
    public static final EntityDataHolder<Boolean> FLAME_AURA = EntityDataHolder.register(EliteNethengeicWitherEntity.class, EntityDataSerializers.f_135035_, false, entity -> entity.flameAura, (entity, value) -> {
        entity.flameAura = value;
    });
    public static final EntityDataHolder<Integer> SECOND_HEAD_TARGET = EntityDataHolder.register(EliteNethengeicWitherEntity.class, EntityDataSerializers.f_135028_, -1, entity -> entity.secondHeadTarget, (entity, value) -> {
        entity.secondHeadTarget = value;
    });
    public static final EntityDataHolder<Integer> THIRD_HEAD_TARGET = EntityDataHolder.register(EliteNethengeicWitherEntity.class, EntityDataSerializers.f_135028_, -1, entity -> entity.thirdHeadTarget, (entity, value) -> {
        entity.thirdHeadTarget = value;
    });
    private static final RawAnimation FLAMETHROWER_ANIM = RawAnimation.begin().thenLoop("attack.flamethrower.center");
    private static final RawAnimation CORE_SPIN_ANIM = RawAnimation.begin().thenLoop("attack.core.spin");
    private static final RawAnimation FIRE_BOMB_ANIM = RawAnimation.begin().thenLoop("attack.fire_bomb.idle");
    private static final int FIREBALL_STATE = 0;
    private static final int FLAMETHROWER_STATE = 1;
    private static final int FIRE_BOMB_STATE = 2;
    private boolean crossedThreshold = false;
    private boolean flameAura = false;
    private int secondHeadTarget = -1;
    private int thirdHeadTarget = -1;

    public EliteNethengeicWitherEntity(EntityType<? extends EliteNethengeicWitherEntity> entityType, Level level) {
        super((EntityType<? extends AoABoss>)entityType, level);
        this.f_21342_ = new AirborneMoveControl((Mob)this, 30, true);
        this.m_20242_(true);
    }

    @Override
    protected void addSwingData(AoABoss.SwingData swings) {
        swings.put(0, new AoABoss.SwingData.Swing(10, 6, RawAnimation.begin()));
        swings.put(1, new AoABoss.SwingData.Swing(0, 0, RawAnimation.begin()));
        swings.put(2, new AoABoss.SwingData.Swing(0, 0, RawAnimation.begin()));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.registerDataParams(FLAME_AURA);
        this.registerDataParams(SECOND_HEAD_TARGET);
        this.registerDataParams(THIRD_HEAD_TARGET);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, level);
        navigation.m_26440_(false);
        navigation.m_7008_(true);
        navigation.m_26443_(true);
        return navigation;
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 3.0f;
    }

    @Override
    @Nullable
    public SoundEvent getMusic() {
        return (SoundEvent)AoASounds.NETHENGEIC_WITHER_MUSIC.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11784_;
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_NETHENGEIC_BEAST_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_NETHENGEIC_BEAST_DEATH.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return null;
    }

    public boolean canSwimInFluidType(FluidType type) {
        return type != ForgeMod.EMPTY_TYPE.get();
    }

    @Override
    public List<ExtendedSensor<AoABoss>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor(), new NearbyLivingEntitySensor().setScanRate(entity -> 40), new HurtBySensor()});
    }

    @Override
    public BrainActivityGroup<AoABoss> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new WalkOrRunToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<AoABoss> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new TargetOrRetaliate().useMemory(MemoryModuleType.f_148206_), new SetRandomHoverTarget().speedModifier(0.9f)});
    }

    public BrainActivityGroup<AoABoss> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> {
            if (!target.m_6084_()) return true;
            if (target instanceof Player) {
                Player pl = (Player)target;
                if (pl.m_150110_().f_35934_) return true;
            }
            if (!(this.m_20238_(target.m_20182_()) > Math.pow(this.m_21133_(Attributes.f_22277_), 2.0))) return false;
            return true;
        }), new SetAdditionalAttackTargets().withMemories(new MemoryModuleType[]{(MemoryModuleType)AoABrainMemories.SECOND_ATTACK_TARGET.get(), (MemoryModuleType)AoABrainMemories.THIRD_ATTACK_TARGET.get()}).allowDuplicateTargeting().whenTargeting((owner, memory, target) -> {
            if (memory == AoABrainMemories.SECOND_ATTACK_TARGET.get()) {
                SECOND_HEAD_TARGET.set((Entity)owner, target.m_19879_());
            } else {
                THIRD_HEAD_TARGET.set((Entity)owner, target.m_19879_());
            }
        }), new SetWalkTargetToAttackTarget().speedMod(1.5f).startCondition(entity -> this.hasAura() && !ATTACK_STATE.is((Entity)entity, 2)).stopIf(entity -> !this.hasAura()), new StayWithinDistanceOfAttackTarget().startCondition(entity -> !this.hasAura()).stopIf(entity -> this.hasAura()), new StrafeTarget().startCondition(entity -> !this.hasAura()).stopIf(entity -> this.hasAura()), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new FlamethrowerAttack((MemoryModuleType<LivingEntity>)MemoryModuleType.f_26372_, entity -> PositionAndMotionUtil.moveRelativeToFacing(entity.m_146892_(), entity.m_146908_(), 0.0, 1.0, 0.0)), new FireBombAttack(), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new AnimatableRangedAttack(this.getSwingWarmupTicks(0)).attackInterval(entity -> this.rand().randomNumberBetween(this.getSwingDurationTicks(0), (int)Math.floor((float)this.getSwingDurationTicks(0) * 1.5f))).attackRadius((float)((int)this.m_21133_(Attributes.f_22277_))).whenStarting(entity -> this.triggerAnim("Middle Head", "fireball")).whenStopping(entity -> BrainUtils.setForgettableMemory((LivingEntity)((EliteNethengeicWitherEntity)entity), (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)21)), (Object)10), Pair.of((Object)new CustomDelayedBehaviour(20).whenActivating(entity -> this.toggleAura()).cooldownFor(entity -> entity.m_217043_().m_216332_(400, 800)).whenStarting(entity -> {
            this.triggerAnim("Middle Head", "fire_aura");
            entity.m_5496_((SoundEvent)AoASounds.ENTITY_NETHENGEIC_BEAST_FLAME_AURA_ACTIVATE.get(), 2.0f, 1.0f);
        }).startCondition(entity -> !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()))), (Object)1)})})});
    }

    public Map<Activity, BrainActivityGroup<AoABoss>> getAdditionalTasks() {
        return Map.of((Activity)AoABrainActivities.FIGHT_2.get(), new BrainActivityGroup((Activity)AoABrainActivities.FIGHT_2.get()).priority(11).behaviours(new Behavior[]{new InvalidateMemory((MemoryModuleType)AoABrainMemories.SECOND_ATTACK_TARGET.get()).invalidateIf((entity, memory) -> {
            block4: {
                block2: {
                    block3: {
                        if (!memory.m_6084_()) break block2;
                        if (!(memory instanceof Player)) break block3;
                        Player pl = (Player)memory;
                        if (pl.m_150110_().f_35934_) break block2;
                    }
                    if (!(memory.m_20280_((Entity)entity) > Math.pow((int)this.m_21133_(Attributes.f_22277_), 2.0))) break block4;
                }
                SECOND_HEAD_TARGET.set((Entity)entity, -1);
                return true;
            }
            return false;
        }), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new CustomDelayedBehaviour(this.getSwingWarmupTicks(0)).whenActivating(entity -> {
            LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)AoABrainMemories.THIRD_ATTACK_TARGET.get()));
            if (target != null) {
                this.doFireball(PositionAndMotionUtil.moveRelativeToFacing(entity.m_146892_(), entity.m_146908_(), -1.25, 0.0, -0.25), target);
            }
        }).whenStarting(entity -> this.triggerAnim("Left Head", "fireball")).startCondition(entity -> BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)AoABrainMemories.SECOND_ATTACK_TARGET.get()))), (Object)20), Pair.of((Object)((Object)new FlamethrowerAttack((MemoryModuleType<LivingEntity>)((MemoryModuleType)AoABrainMemories.SECOND_ATTACK_TARGET.get()), entity -> PositionAndMotionUtil.moveRelativeToFacing(entity.m_146892_(), entity.m_146908_(), -1.25, 0.0, -0.25))), (Object)1)}).cooldownFor(entity -> this.rand().randomNumberBetween(this.getSwingDurationTicks(0) * (ATTACK_STATE.is((Entity)entity, 2) ? 4 : 2), this.getSwingDurationTicks(0) * (ATTACK_STATE.is((Entity)entity, 2) ? 6 : 3)))}).requireAndWipeMemoriesOnUse(new MemoryModuleType[]{(MemoryModuleType)AoABrainMemories.SECOND_ATTACK_TARGET.get()}), (Activity)AoABrainActivities.FIGHT_3.get(), new BrainActivityGroup((Activity)AoABrainActivities.FIGHT_3.get()).priority(12).behaviours(new Behavior[]{new InvalidateMemory((MemoryModuleType)AoABrainMemories.THIRD_ATTACK_TARGET.get()).invalidateIf((entity, memory) -> {
            block4: {
                block2: {
                    block3: {
                        if (!memory.m_6084_()) break block2;
                        if (!(memory instanceof Player)) break block3;
                        Player pl = (Player)memory;
                        if (pl.m_150110_().f_35934_) break block2;
                    }
                    if (!(memory.m_20280_((Entity)entity) > Math.pow((int)this.m_21133_(Attributes.f_22277_), 2.0))) break block4;
                }
                THIRD_HEAD_TARGET.set((Entity)entity, -1);
                return true;
            }
            return false;
        }), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new CustomDelayedBehaviour(this.getSwingWarmupTicks(0)).whenActivating(entity -> {
            LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)AoABrainMemories.THIRD_ATTACK_TARGET.get()));
            if (target != null) {
                this.doFireball(PositionAndMotionUtil.moveRelativeToFacing(entity.m_146892_(), entity.m_146908_(), 1.25, -0.5, -0.25), target);
            }
        }).whenStarting(entity -> this.triggerAnim("Right Head", "fireball")).startCondition(entity -> BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)AoABrainMemories.THIRD_ATTACK_TARGET.get()))), (Object)20), Pair.of((Object)((Object)new FlamethrowerAttack((MemoryModuleType<LivingEntity>)((MemoryModuleType)AoABrainMemories.THIRD_ATTACK_TARGET.get()), entity -> PositionAndMotionUtil.moveRelativeToFacing(entity.m_146892_(), entity.m_146908_(), 1.25, -0.5, -0.25))), (Object)1)}).cooldownFor(entity -> this.rand().randomNumberBetween(this.getSwingDurationTicks(0) * (ATTACK_STATE.is((Entity)entity, 2) ? 4 : 2), this.getSwingDurationTicks(0) * (ATTACK_STATE.is((Entity)entity, 2) ? 6 : 3)))}).requireAndWipeMemoriesOnUse(new MemoryModuleType[]{(MemoryModuleType)AoABrainMemories.THIRD_ATTACK_TARGET.get()}));
    }

    public Set<Activity> getAlwaysRunningActivities() {
        return ImmutableSet.of((Object)Activity.f_37978_, (Object)((Activity)AoABrainActivities.FIGHT_2.get()), (Object)((Activity)AoABrainActivities.FIGHT_3.get()));
    }

    private void doFireball(@Nullable Vec3 startPos, LivingEntity target) {
        FireballEntity projectile = new FireballEntity(this.f_19853_, this, BaseMobProjectile.Type.PHYSICAL);
        if (startPos != null) {
            projectile.m_146884_(startPos);
        }
        projectile.m_146922_(this.m_6080_());
        PositionAndMotionUtil.moveRelativeToFacing((Entity)projectile, 0.0, 1.0, 0.0);
        Vec3 targetPos = target.m_146892_();
        if (this.m_21223_() < this.m_21233_() * 0.5f) {
            float timeToTarget = (float)targetPos.m_82546_(projectile.m_20182_()).m_82553_() / 1.6f;
            targetPos = targetPos.m_82549_(new Vec3(target.m_20185_() - target.f_19790_, 0.0, target.m_20189_() - target.f_19792_).m_82542_((double)timeToTarget, (double)timeToTarget, (double)timeToTarget));
        }
        PositionAndMotionUtil.moveTowards((Entity)projectile, targetPos, 1.6, 4 - this.f_19853_.m_46791_().m_19028_());
        projectile.m_20256_(PositionAndMotionUtil.accountForGravity(projectile.m_20182_(), projectile.m_20184_(), target.m_20182_(), projectile.m_7139_()));
        PositionAndMotionUtil.faceTowardsMotion((Entity)projectile);
        this.m_5496_(SoundEvents.f_11705_, 1.0f, 1.0f);
        this.f_19853_.m_7967_((Entity)projectile);
    }

    public void m_6504_(LivingEntity target, float velocity) {
        this.doFireball(null, target);
    }

    @Override
    public void doRangedAttackEntity(@Nullable BaseMobProjectile projectile, Entity target) {
        if (projectile == null) {
            DamageUtil.safelyDealDamage(DamageUtil.positionedEntityDamage(AoADamageTypes.MOB_FLAMETHROWER, (Entity)this, this.m_20182_()), target, 1.0f);
            if (RandomUtil.oneInNChance((int)3) && target.m_20094_() < 300) {
                target.m_20254_((int)Math.ceil((float)Math.max(0, target.m_20094_()) / 20.0f) + 1);
            }
            if (RandomUtil.oneInNChance((int)3) && target instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)target;
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 80, 1));
            }
        } else {
            float dmg = (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get());
            if (ATTACK_STATE.is((Entity)this, 2)) {
                dmg *= 1.5f;
            }
            if (DamageUtil.doProjectileAttack((Entity)this, (Entity)projectile, target, dmg)) {
                target.m_20254_((int)Math.ceil((float)Math.max(0, target.m_20094_()) / 20.0f) + 3);
                if (target instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)target;
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)AoAMobEffects.NETHENGEIC_CURSE.get(), 200, this.f_19853_.m_46791_().m_19028_()));
                }
            }
        }
    }

    @Override
    public void doRangedAttackBlock(@Nullable BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
        if (projectile == null) {
            return;
        }
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            new StandardExplosion(AoAExplosions.NETHENGEIC_WITHER_FIREBALL, serverLevel, (Entity)projectile, (Entity)this).m_46061_();
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.hasAura()) {
            if (DamageUtil.isMeleeDamage(source)) {
                Entity entity = source.m_7640_();
                if (entity instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)entity;
                    DamageUtil.safelyDealDamage(DamageUtil.entityDamage(AoADamageTypes.MOB_FIRE_RECOIL, (Entity)this), (Entity)attacker, 5.0f);
                    attacker.m_20254_((int)Math.ceil((float)Math.max(0, attacker.m_20094_()) / 20.0f) + 2);
                    attacker.m_7292_(new MobEffectInstance((MobEffect)AoAMobEffects.NETHENGEIC_CURSE.get(), 200, 2));
                }
            } else if (DamageUtil.isEnergyDamage(source)) {
                this.m_5634_(amount);
                return false;
            }
        }
        float priorHealth = this.m_21223_();
        if (super.m_6469_(source, amount)) {
            float maxHealth = this.m_21233_();
            float quarterHealth = maxHealth / 4.0f;
            float currentHealth = this.m_21223_();
            for (float checkHealth = maxHealth - quarterHealth; checkHealth > 0.0f; checkHealth -= quarterHealth) {
                if (!(priorHealth > checkHealth) || !(currentHealth < checkHealth)) continue;
                this.crossedThreshold = true;
                break;
            }
            return true;
        }
        return false;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_() != MobEffects.f_19615_ && effect.m_19544_() != AoAMobEffects.NETHENGEIC_CURSE.get() && super.m_7301_(effect);
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    protected void m_20076_() {
    }

    public boolean hasAura() {
        return FLAME_AURA.is((Entity)this, true);
    }

    public void toggleAura() {
        FLAME_AURA.set((Entity)this, FLAME_AURA.get((Entity)this) == false);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.m_5776_()) {
            if (this.hasAura()) {
                for (int i = 0; i < 3; ++i) {
                    double cos = Math.cos(this.m_20185_() * RandomUtil.randomValueBetween((double)-1.0, (double)1.0));
                    double sin = Math.sin(this.m_20189_() * RandomUtil.randomValueBetween((double)-1.0, (double)1.0));
                    double startX = cos * (double)this.m_20205_() + this.m_20185_();
                    double startZ = sin * (double)this.m_20205_() + this.m_20189_();
                    double startY = this.m_20187_();
                    ParticleBuilder.forPos(new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.FIRE_AURA.get()), 0.25f, 5.0f, 1.0f, 1.0f, 1.0f, 0.75f, this.m_19879_()), startX, startY, startZ).velocity(RandomUtil.fiftyFifty() ? -1.0 : 1.0, RandomUtil.fiftyFifty() ? -1.0 : 1.0, RandomUtil.fiftyFifty() ? -1.0 : 1.0).spawnParticles();
                }
            }
            ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + RandomUtil.randomValueBetween((double)-0.2f, (double)0.2f), this.m_20188_() - 1.0 + RandomUtil.randomValueBetween((double)-0.2f, (double)0.2f), this.m_20189_() + RandomUtil.randomValueBetween((double)-0.2f, (double)0.2f)).spawnParticles();
            if (this.m_217043_().m_188503_(10) == 0) {
                ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20188_() - 1.0, this.m_20189_()).spawnParticles();
                if (this.m_20184_().m_165925_() == 0.0) {
                    ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_123800_, this.m_20185_(), this.m_20188_() - 1.0, this.m_20189_()).spawnParticles();
                }
            }
        } else if (this.hasAura() && BrainUtils.getTargetOfEntity((LivingEntity)this) == null) {
            this.toggleAura();
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "living", 0, state -> {
            if (ATTACK_STATE.is((Entity)this, 2)) {
                state.getController().setAnimationSpeed(1.0);
                return state.setAndContinue(CORE_SPIN_ANIM);
            }
            state.getController().setAnimationSpeed((double)(1.0f + (1.0f - this.m_21223_() / this.m_21233_()) * 5.0f));
            state.getController().setAnimation(DefaultAnimations.LIVING);
            return PlayState.CONTINUE;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Walk/Idle", 0, state -> {
            if (ATTACK_STATE.is((Entity)this, 2)) {
                return state.setAndContinue(FIRE_BOMB_ANIM);
            }
            return state.setAndContinue(state.isMoving() ? DefaultAnimations.WALK : DefaultAnimations.IDLE);
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Middle Head", 0, state -> {
            if (ATTACK_STATE.is((Entity)this, 1)) {
                state.setAndContinue(FLAMETHROWER_ANIM);
            }
            return PlayState.STOP;
        }).triggerableAnim("fireball", RawAnimation.begin().thenPlay("attack.fireball.center")).triggerableAnim("fire_aura", RawAnimation.begin().thenPlay("misc.fire_aura"))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Left Head", 0, state -> PlayState.STOP).triggerableAnim("fireball", RawAnimation.begin().thenPlay("attack.fireball.left"))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Right Head", 0, state -> PlayState.STOP).triggerableAnim("fireball", RawAnimation.begin().thenPlay("attack.fireball.right"))});
    }

    private static class FlamethrowerAttack
    extends ConditionlessHeldAttack<EliteNethengeicWitherEntity> {
        private final Function<EliteNethengeicWitherEntity, Vec3> startPosFunction;
        private final MemoryModuleType<LivingEntity> targetMemory;

        public FlamethrowerAttack(MemoryModuleType<LivingEntity> targetMemory, Function<EliteNethengeicWitherEntity, Vec3> startPosFunction) {
            this.startPosFunction = startPosFunction;
            this.targetMemory = targetMemory;
            this.runFor(entity -> RandomUtil.randomNumberBetween((int)160, (int)240));
            this.requiresTarget();
            this.onTick(entity -> {
                Vec3 position = this.startPosFunction.apply((EliteNethengeicWitherEntity)entity);
                double baseX = position.f_82479_;
                double baseY = position.f_82480_;
                double baseZ = position.f_82481_;
                ServerParticlePacket packet = new ServerParticlePacket(ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_123755_, baseX, baseY, baseZ));
                for (int i = 0; i < 5; ++i) {
                    Vec3 velocity = this.target.m_146892_().m_82492_(baseX + RandomUtil.randomScaledGaussianValue((double)0.5), baseY + RandomUtil.randomScaledGaussianValue((double)0.5), baseZ + RandomUtil.randomScaledGaussianValue((double)0.5)).m_82541_().m_82490_((double)0.9f);
                    packet.particle(ParticleBuilder.forPos(new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.BURNING_FLAME.get()), 0.35f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f, entity.m_19879_()), baseX, baseY, baseZ).velocity(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_));
                    packet.particle(ParticleBuilder.forPos((ParticleOptions)(RandomUtil.fiftyFifty() ? ParticleTypes.f_175834_ : ParticleTypes.f_123765_), baseX, baseY, baseZ).velocity(velocity.f_82479_, velocity.f_82480_, velocity.f_82481_));
                }
                AoAPackets.messageNearbyPlayers(packet, (ServerLevel)entity.f_19853_, EntityUtil.getEntityCenter((Entity)entity), 64.0);
                if (this.getRunningTime() % 9 == 0 || this.getRunningTime() % 19 == 0) {
                    entity.m_5496_((SoundEvent)AoASounds.FLAMETHROWER.get(), 2.0f, 1.0f);
                }
                return true;
            });
            this.startCondition(entity -> {
                if (this.targetMemory == MemoryModuleType.f_26372_ && !entity.hasAura()) {
                    return false;
                }
                LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, this.targetMemory);
                return target != null && target.m_6084_();
            });
            this.stopIf(entity -> {
                LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, this.targetMemory);
                return target == null || !target.m_6084_();
            });
            this.whenStarting(entity -> AoAMonster.ATTACK_STATE.set((Entity)entity, 1));
            this.whenStopping(entity -> {
                if (this.targetMemory != MemoryModuleType.f_26372_) {
                    return;
                }
                AoAMonster.ATTACK_STATE.set((Entity)entity, 0);
                if (entity.hasAura()) {
                    entity.toggleAura();
                }
                BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)30);
            });
        }
    }

    private static class FireBombAttack
    extends ConditionlessHeldAttack<EliteNethengeicWitherEntity> {
        private final List<FireballEntity> fireballs = new ObjectArrayList();

        public FireBombAttack() {
            this.runFor(entity -> 280);
            this.onTick(entity -> {
                if (this.runningTime >= 20 && !entity.hasAura()) {
                    entity.toggleAura();
                }
                entity.m_20256_(this.target.m_20182_().m_82546_(entity.m_20182_()).m_82541_().m_82542_(0.0, 0.5, 0.0).m_82520_(0.0, Math.cos(entity.f_19797_) * (double)0.05f, 0.0));
                if (this.runningTime % 14 == 0) {
                    if (!this.fireballs.isEmpty()) {
                        for (FireballEntity fireball : this.fireballs) {
                            Vec3 angle = fireball.m_20182_().m_82546_(entity.m_20182_()).m_82542_(1.0, 0.0, 1.0).m_82541_();
                            fireball.m_146922_((float)Math.atan2(angle.f_82481_, angle.f_82480_));
                            PositionAndMotionUtil.moveTowards((Entity)fireball, fireball.m_20182_().m_82549_(angle.m_82542_(10.0, 10.0, 10.0)), 1.4, 4 - entity.f_19853_.m_46791_().m_19028_());
                            PositionAndMotionUtil.faceTowardsMotion((Entity)fireball);
                        }
                        entity.m_5496_(SoundEvents.f_11705_, 1.0f, 1.0f);
                        this.fireballs.clear();
                    }
                    for (double angle = RandomUtil.randomValueBetween((double)-45.0, (double)45.0) * 0.01745329238474369; angle <= 6.2831854820251465; angle += 0.7853981852531433) {
                        for (double offsetY = -2.0; offsetY <= 2.0; offsetY += 1.0) {
                            FireballEntity projectile = new FireballEntity(entity.f_19853_, (AoARangedAttacker)entity, BaseMobProjectile.Type.PHYSICAL);
                            double xAngle = Math.cos(angle);
                            double zAngle = Math.sin(angle);
                            projectile.m_146884_(entity.m_20182_().m_82520_(2.0 * xAngle, (double)(entity.m_20206_() / 2.0f) + offsetY, 2.0 * zAngle));
                            projectile.m_20334_(0.0, -0.01f, 0.0);
                            entity.f_19853_.m_7967_((Entity)projectile);
                            this.fireballs.add(projectile);
                        }
                    }
                }
                return true;
            });
            this.startCondition(entity -> {
                if (!entity.crossedThreshold || entity.hasAura()) {
                    return false;
                }
                LivingEntity target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26372_);
                return target != null && target.m_6084_();
            });
            this.stopIf(entity -> {
                this.target = (LivingEntity)BrainUtils.getMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26372_);
                return this.target == null;
            });
            this.whenStarting(entity -> {
                entity.triggerAnim("Middle Head", "fire_aura");
                entity.m_21573_().m_26573_();
                entity.m_21570_(0.0f);
                entity.m_21567_(0.0f);
                entity.m_21564_(0.0f);
                entity.m_20256_(Vec3.f_82478_);
                BrainUtils.clearMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26377_);
                AoAMonster.ATTACK_STATE.set((Entity)entity, 2);
                entity.crossedThreshold = false;
            });
            this.whenStopping(entity -> {
                AoAMonster.ATTACK_STATE.set((Entity)entity, 0);
                entity.triggerAnim("Middle Head", "fire_aura");
                BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)25);
                if (!this.fireballs.isEmpty()) {
                    for (FireballEntity fireball : this.fireballs) {
                        Vec3 angle = fireball.m_20182_().m_82546_(entity.m_20182_()).m_82541_();
                        fireball.m_146922_((float)Math.atan2(angle.f_82481_, angle.f_82480_));
                        PositionAndMotionUtil.moveTowards((Entity)fireball, fireball.m_20182_().m_82549_(angle.m_82542_(10.0, 10.0, 10.0)), 1.2, 4 - entity.f_19853_.m_46791_().m_19028_());
                        PositionAndMotionUtil.faceTowardsMotion((Entity)fireball);
                    }
                    entity.m_5496_(SoundEvents.f_11705_, 1.0f, 1.0f);
                    this.fireballs.clear();
                }
                if (entity.hasAura()) {
                    entity.toggleAura();
                }
            });
        }
    }
}

