/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.boss.king_bambambam;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.AoASoundBuilderPacket;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoAExplosions;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAMobs;
import net.tslat.aoa3.content.entity.base.AoAMonster;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.boss.AoABoss;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.content.entity.brain.task.temp.LookAtAttackTarget;
import net.tslat.aoa3.content.entity.brain.task.temp.NearbyItemsSensor;
import net.tslat.aoa3.content.entity.mob.nether.EmbrakeEntity;
import net.tslat.aoa3.content.entity.mob.nether.LittleBamEntity;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.StickyFireballEntity;
import net.tslat.aoa3.library.builder.ParticleBuilder;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.library.object.TriFunction;
import net.tslat.aoa3.library.object.explosion.StandardExplosion;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.PositionAndMotionUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.DelayedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.HeldBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.CustomDelayedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class KingBamBamBamEntity
extends AoABoss
implements AoARangedAttacker {
    public static final EntityDataHolder<Boolean> EXHAUSTED = EntityDataHolder.register(KingBamBamBamEntity.class, EntityDataSerializers.f_135035_, false, entity -> entity.exhausted, (entity, value) -> {
        entity.exhausted = value;
    });
    public static final EntityDataHolder<Boolean> STAFF_CHARGED = EntityDataHolder.register(KingBamBamBamEntity.class, EntityDataSerializers.f_135035_, false, entity -> entity.staffCharged, (entity, value) -> {
        entity.staffCharged = value;
    });
    public static final EntityDataHolder<Integer> ENERGY_LEVEL = EntityDataHolder.register(KingBamBamBamEntity.class, EntityDataSerializers.f_135028_, 100, entity -> entity.energy, (entity, value) -> {
        entity.energy = value;
    });
    private static final RawAnimation EXHAUSTED_ANIM = RawAnimation.begin().thenPlayAndHold("misc.exhaust");
    private static final RawAnimation FIREBALLS_ANIM = RawAnimation.begin().thenPlay("attack.fireballs_start").then("attack.fireballs_loop", new Animation.LoopType(){

        public boolean shouldPlayAgain(GeoAnimatable geoAnimatable, AnimationController<? extends GeoAnimatable> animationController, Animation animation) {
            return AoAMonster.ATTACK_STATE.is((Entity)geoAnimatable, 3);
        }
    }).thenPlay("attack.fireballs_end");
    private static final RawAnimation GET_UP_ANIM = RawAnimation.begin().thenPlay("misc.get_up");
    private static final RawAnimation GOLD_CONSUME_ANIM = RawAnimation.begin().thenPlay("misc.gold_consume");
    private static final RawAnimation STAFF_CHARGE_ANIM = RawAnimation.begin().thenPlay("misc.explosive_charge").thenPlay("misc.explosive_charge_end");
    private static final RawAnimation STAFF_ACTIVE_ANIM = RawAnimation.begin().thenLoop("misc.sphere_spin");
    private static final RawAnimation STAFF_INACTIVE_ANIM = RawAnimation.begin().thenLoop("misc.hide_sphere");
    private static final RawAnimation SUMMON_1_ANIM = RawAnimation.begin().thenLoop("misc.summon");
    private static final RawAnimation SUMMON_2_ANIM = RawAnimation.begin().thenLoop("misc.summon2");
    private static final RawAnimation SUMMON_3_ANIM = RawAnimation.begin().thenLoop("misc.big_summon");
    private static final int SUMMON_1_STATE = 0;
    private static final int SUMMON_2_STATE = 1;
    private static final int SUMMON_3_STATE = 2;
    private static final int FIREBALLS_STATE = 3;
    private boolean exhausted = false;
    private boolean staffCharged = false;
    private int energy = 100;

    public KingBamBamBamEntity(EntityType<? extends KingBamBamBamEntity> entityType, Level level) {
        super((EntityType<? extends AoABoss>)entityType, level);
    }

    @Override
    protected void addSwingData(AoABoss.SwingData swings) {
        swings.put(0, new AoABoss.SwingData.Swing(20, 10, SUMMON_1_ANIM));
        swings.put(1, new AoABoss.SwingData.Swing(20, 12, SUMMON_2_ANIM));
        swings.put(2, new AoABoss.SwingData.Swing(70, 53, SUMMON_3_ANIM));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.registerDataParams(EXHAUSTED);
        this.registerDataParams(STAFF_CHARGED);
        this.registerDataParams(ENERGY_LEVEL);
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 2.15625f;
    }

    public float m_6100_() {
        return 0.75f;
    }

    @Override
    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12303_;
    }

    @Override
    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12304_;
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12301_;
    }

    @Override
    @org.jetbrains.annotations.Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return super.getStepSound(pos, blockState);
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public SoundEvent getMusic() {
        return (SoundEvent)AoASounds.KING_BAMBAMBAM_MUSIC.get();
    }

    @Override
    public List<ExtendedSensor<AoABoss>> getSensors() {
        Object[] objectArray = new ExtendedSensor[3];
        objectArray[0] = new AggroBasedNearbyPlayersSensor<AoABoss>().onlyAttacking((arg_0, arg_1) -> ((TargetingConditions)TargetingConditions.m_148352_().m_148355_()).m_26885_(arg_0, arg_1)).onlyTargeting((arg_0, arg_1) -> ((TargetingConditions)TargetingConditions.m_148353_().m_148355_()).m_26885_(arg_0, arg_1));
        objectArray[1] = new HurtBySensor().setPredicate((source, mob) -> !EntityUtil.isHostileMob((Entity)mob));
        objectArray[2] = new NearbyItemsSensor();
        return ObjectArrayList.of((Object[])objectArray);
    }

    @Override
    public BrainActivityGroup<AoABoss> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new WalkOrRunToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<AoABoss> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new TargetOrRetaliate().useMemory(MemoryModuleType.f_148206_)});
    }

    public BrainActivityGroup<AoABoss> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget(), new LookAtAttackTarget(), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new Rest(), new Fireballs(), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new SummonMinions(SummonMinions.Variant.LITTLE_BAM, x$0 -> this.getSwingWarmupTicks(x$0)).cooldownFor(entity -> entity.rand().randomNumberBetween(25, 35)), (Object)15), Pair.of((Object)new SummonMinions(SummonMinions.Variant.PIGLIN_BRUTE, x$0 -> this.getSwingWarmupTicks(x$0)).cooldownFor(entity -> entity.rand().randomNumberBetween(40, 60)), (Object)10), Pair.of((Object)new SummonMinions(SummonMinions.Variant.EMBRAKE, x$0 -> this.getSwingWarmupTicks(x$0)).cooldownFor(entity -> entity.rand().randomNumberBetween(75, 90)), (Object)5), Pair.of((Object)new CustomDelayedBehaviour(60).whenActivating(entity -> {
            STAFF_CHARGED.set((Entity)entity, true);
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26373_, (Object)true, (int)5);
            if (!EntityRetrievalUtil.getPlayers((Level)entity.f_19853_, (AABB)this.m_20191_().m_82369_(this.m_20156_().m_82542_(3.0, 1.25, 3.0))).isEmpty()) {
                new StandardExplosion(AoAExplosions.KING_BAMBAMBAM_DISCHARGE, (ServerLevel)entity.f_19853_, (Entity)entity, entity.m_20182_().m_82520_(0.0, 0.5, 0.0).m_82549_(entity.m_20156_().m_82542_(1.5, 1.5, 1.5))).m_46061_();
            }
        }).whenStarting(entity -> this.triggerAnim("Sphere", "Charge")).startCondition(entity -> !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26373_)).cooldownFor(entity -> this.rand().randomNumberBetween(2000, 3000)), (Object)50)}).startCondition(entity -> STAFF_CHARGED.is((Entity)entity, false))})});
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.f_19797_ % 5 == 0) {
            this.addEnergy(1);
        }
    }

    @Override
    protected void onHurt(DamageSource source, float amount) {
        if (EXHAUSTED.is((Entity)this, false)) {
            this.consumeEnergy((int)Math.floor(amount));
        }
    }

    public boolean m_6673_(DamageSource source) {
        if (source.m_269533_(DamageTypeTags.f_268415_) && source.m_7639_() instanceof LittleBamEntity) {
            return true;
        }
        return super.m_6673_(source);
    }

    public void addEnergy(int amount) {
        ENERGY_LEVEL.set((Entity)this, Math.min(ENERGY_LEVEL.get((Entity)this) + amount, 100));
    }

    public void consumeEnergy(int amount) {
        ENERGY_LEVEL.set((Entity)this, Math.max(ENERGY_LEVEL.get((Entity)this) - amount, 0));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{DefaultAnimations.genericWalkIdleController((GeoAnimatable)this).setAnimationSpeed((double)1.2f)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Summoning", 0, state -> {
            if (this.f_20911_) {
                return state.setAndContinue(this.getSwingAnimation());
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Sphere", 0, state -> {
            if (STAFF_CHARGED.is((Entity)this, false)) {
                return state.setAndContinue(STAFF_INACTIVE_ANIM);
            }
            return state.setAndContinue(STAFF_ACTIVE_ANIM);
        }).triggerableAnim("Charge", STAFF_CHARGE_ANIM)});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Fireballs", 0, state -> {
            if (ATTACK_STATE.is((Entity)this, 3) || !state.getController().hasAnimationFinished() && state.getController().getCurrentAnimation() != null && state.getController().getCurrentAnimation().animation().name().equals("attack.fireballs_end")) {
                return state.setAndContinue(FIREBALLS_ANIM);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Exhaustion", 5, state -> {
            if (EXHAUSTED.is((Entity)this, true)) {
                return state.setAndContinue(EXHAUSTED_ANIM);
            }
            if (state.isCurrentAnimation(EXHAUSTED_ANIM) || state.isCurrentAnimation(GET_UP_ANIM) && !state.getController().hasAnimationFinished()) {
                return state.setAndContinue(GET_UP_ANIM);
            }
            state.getController().forceAnimationReset();
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Gold Consumption", 0, state -> PlayState.STOP).triggerableAnim("consume", GOLD_CONSUME_ANIM)});
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
    }

    @Override
    public void doRangedAttackEntity(@org.jetbrains.annotations.Nullable BaseMobProjectile projectile, Entity target) {
        if (DamageUtil.doProjectileAttack((Entity)this, (Entity)projectile, target, (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()))) {
            target.m_20254_((int)Math.ceil((float)Math.max(0, target.m_20094_()) / 20.0f) + 2);
        }
    }

    @Override
    public void doRangedAttackBlock(@org.jetbrains.annotations.Nullable BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
    }

    public static class Rest
    extends HeldBehaviour<AoABoss> {
        public Rest() {
            this.runFor(entity -> 200);
        }

        protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return List.of();
        }

        protected boolean checkExtraStartConditions(ServerLevel level, AoABoss entity) {
            return ENERGY_LEVEL.is((Entity)entity, 0);
        }

        protected boolean shouldKeepRunning(AoABoss entity) {
            return !ENERGY_LEVEL.is((Entity)entity, 100);
        }

        protected void start(AoABoss entity) {
            EXHAUSTED.set((Entity)entity, true);
            entity.m_20334_(0.0, 0.0, 0.0);
            entity.m_21573_().m_26573_();
            BrainUtils.clearMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26377_);
            AoAPackets.messageAllPlayersTrackingEntity(new AoASoundBuilderPacket(new SoundBuilder((Supplier<SoundEvent>)AoASounds.ENTITY_KING_BAMBAMBAM_EXHAUSTED).followEntity((Entity)entity)), (Entity)entity);
        }

        protected void stop(AoABoss entity) {
            EXHAUSTED.set((Entity)entity, false);
            ((KingBamBamBamEntity)entity).addEnergy(100);
        }
    }

    public static class Fireballs
    extends HeldBehaviour<AoABoss> {
        private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26373_, (Object)MemoryStatus.VALUE_ABSENT)});

        public Fireballs() {
            this.runFor(entity -> 200);
        }

        protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return MEMORY_REQUIREMENTS;
        }

        protected boolean checkExtraStartConditions(ServerLevel level, AoABoss entity) {
            return STAFF_CHARGED.is((Entity)entity, true);
        }

        protected boolean shouldKeepRunning(AoABoss entity) {
            return !ENERGY_LEVEL.is((Entity)entity, 0);
        }

        protected void start(AoABoss entity) {
            AoAMonster.ATTACK_STATE.set((Entity)entity, 3);
        }

        protected void stop(AoABoss entity) {
            AoAMonster.ATTACK_STATE.set((Entity)entity, 0);
            STAFF_CHARGED.set((Entity)entity, false);
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26373_, (Object)true, (int)60);
        }

        protected void tick(AoABoss entity) {
            if (this.runningTime < 20) {
                return;
            }
            Vec3 forward = entity.m_20156_();
            Vec3 left = Vec3.m_82498_((float)entity.m_146909_(), (float)(entity.m_146908_() + 90.0f));
            for (int i = 0; i < 2; ++i) {
                StickyFireballEntity fireball = new StickyFireballEntity(entity.f_19853_, (KingBamBamBamEntity)entity, BaseMobProjectile.Type.PHYSICAL);
                fireball.m_6034_((forward.f_82479_ + left.f_82479_) * 0.25 + entity.m_20208_(0.25), entity.m_20186_() + 4.5, (forward.f_82481_ + left.f_82481_) * 0.25 + entity.m_20262_(0.25));
                fireball.m_20334_(entity.m_217043_().m_188583_() * (double)0.15f, 1.2f, entity.m_217043_().m_188583_() * (double)0.15f);
                entity.f_19853_.m_7967_((Entity)fireball);
            }
            if (this.getRunningTime() % 9 == 0 || this.getRunningTime() % 20 == 0) {
                entity.m_5496_((SoundEvent)AoASounds.FLAMETHROWER.get(), 2.0f, 0.5f);
            }
        }
    }

    public static class SummonMinions
    extends DelayedBehaviour<AoABoss> {
        private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26373_, (Object)MemoryStatus.VALUE_ABSENT)});
        private static final Item[] LOOT_ITEMS = new Item[]{Items.f_42432_, Items.f_42434_, Items.f_42431_, Items.f_42430_, Items.f_42433_, Items.f_42652_, Items.f_42476_, Items.f_42477_, Items.f_42478_, Items.f_42479_, Items.f_42417_, Items.f_42587_};
        private final Variant variant;

        public SummonMinions(Variant variant, Int2IntFunction delayFunction) {
            super(((Integer)delayFunction.apply((Object)variant.ordinal())).intValue());
            this.variant = variant;
        }

        protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
            return MEMORY_REQUIREMENTS;
        }

        protected void start(AoABoss entity) {
            AoAMonster.ATTACK_STATE.set((Entity)entity, this.variant.ordinal());
            entity.m_6674_(InteractionHand.MAIN_HAND);
            AoAPackets.messageAllPlayersTrackingEntity(new AoASoundBuilderPacket(new SoundBuilder(this.variant.summonSound).followEntity((Entity)entity).category(SoundSource.HOSTILE)), (Entity)entity);
        }

        protected void doDelayedAction(AoABoss entity) {
            Vec3 spawnPos = Vec3.m_82539_((Vec3i)RandomUtil.getRandomPositionWithinRange((BlockPos)entity.m_20183_(), (int)4, (int)2, (int)4, (int)1, (int)0, (int)1, (boolean)false, (Level)entity.f_19853_, (int)5, (state, pos) -> Math.abs((double)pos.m_123342_() - entity.m_20186_()) <= 5.0));
            spawnPos = PositionAndMotionUtil.moveDownToGround(entity.f_19853_, spawnPos);
            LivingEntity minion = this.variant.spawnFunction.apply(entity, spawnPos = PositionAndMotionUtil.moveUpToSurface(entity.f_19853_, spawnPos), (LivingEntity)BrainUtils.memoryOrDefault((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26382_, () -> null));
            if (minion != null) {
                LivingEntity target = BrainUtils.getTargetOfEntity((LivingEntity)entity);
                ((KingBamBamBamEntity)entity).consumeEnergy(this.variant.energyCost);
                if (target != null) {
                    BrainUtils.setMemory((LivingEntity)minion, (MemoryModuleType)MemoryModuleType.f_26372_, (Object)target);
                }
                ServerParticlePacket packet = new ServerParticlePacket();
                packet.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.f_175834_, (Entity)minion).spawnNTimes(50).lifespan(40).ignoreDistanceAndLimits());
                AoAPackets.messageAllPlayersTrackingEntity(packet, (Entity)entity);
                AoAPackets.messageAllPlayersTrackingEntity(new AoASoundBuilderPacket(new SoundBuilder(SoundEvents.f_11705_).followEntity((Entity)entity).category(SoundSource.HOSTILE).pitch(0.5f).varyPitch(0.1f)), (Entity)entity);
            }
        }

        protected void stop(AoABoss entity) {
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26373_, (Object)true, (int)entity.rand().randomNumberBetween((this.variant.ordinal() + 1) * 40, (this.variant.ordinal() + 1) * 60));
        }

        @Nullable
        private static LivingEntity summonLittleBam(final AoABoss entity, Vec3 pos, @org.jetbrains.annotations.Nullable LivingEntity target) {
            LittleBamEntity littleBam = new LittleBamEntity((EntityType)AoAMobs.LITTLE_BAM.get(), entity.f_19853_){
                private final AoABoss kingBamBamBam;
                {
                    super((EntityType<? extends LittleBamEntity>)entityType, world);
                    this.kingBamBamBam = entity;
                }

                public boolean m_6673_(DamageSource source) {
                    return source.m_269533_(DamageTypeTags.f_268415_) || super.m_6673_(source) || source.m_7639_() != null && PlayerUtil.getPlayerOrOwnerIfApplicable(source.m_7639_()) == null;
                }

                public void m_8119_() {
                    super.m_8119_();
                    if (this.kingBamBamBam == null || !this.kingBamBamBam.m_6084_() || this.f_19797_ > 12000) {
                        this.m_146870_();
                    }
                }

                public boolean m_142391_() {
                    return false;
                }

                protected void m_6668_(DamageSource source) {
                    for (int i = 0; i < 3; ++i) {
                        SummonMinions.createMagnetisedItemStack(entity, this.m_146892_().m_82520_(0.0, (double)0.1f, 0.0), new Vec3(entity.rand().randomScaledGaussianValue(0.5), 0.5, entity.rand().randomScaledGaussianValue(0.5)), (Item)entity.rand().getRandomSelection((Object[])LOOT_ITEMS));
                    }
                }

                public void m_6710_(@org.jetbrains.annotations.Nullable LivingEntity target) {
                    if (target != null && target.m_6095_() != EntityType.f_20532_) {
                        return;
                    }
                    super.m_6710_(target);
                }
            };
            littleBam.m_6710_(target);
            littleBam.m_146884_(pos);
            littleBam.m_6518_((ServerLevelAccessor)((ServerLevel)littleBam.f_19853_), littleBam.f_19853_.m_6436_(littleBam.m_20183_()), MobSpawnType.REINFORCEMENT, null, null);
            return entity.f_19853_.m_7967_((Entity)littleBam) ? littleBam : null;
        }

        @Nullable
        private static LivingEntity summonPiglinBrute(final AoABoss entity, Vec3 pos, @org.jetbrains.annotations.Nullable LivingEntity target) {
            PiglinBrute piglin = new PiglinBrute(EntityType.f_20512_, entity.f_19853_){
                private final AoABoss kingBamBamBam;
                {
                    super(pEntityType, pLevel);
                    this.kingBamBamBam = entity;
                }

                public boolean m_6673_(DamageSource source) {
                    return source.m_269533_(DamageTypeTags.f_268415_) || super.m_6673_(source) || source.m_7639_() != null && PlayerUtil.getPlayerOrOwnerIfApplicable(source.m_7639_()) == null;
                }

                public void m_8119_() {
                    super.m_8119_();
                    if (this.kingBamBamBam == null || !this.kingBamBamBam.m_6084_() || this.f_19797_ > 12000) {
                        this.m_146870_();
                    }
                }

                public boolean m_142391_() {
                    return false;
                }

                protected void m_6668_(DamageSource source) {
                    for (int i = 0; i < 3; ++i) {
                        SummonMinions.createMagnetisedItemStack(entity, this.m_146892_().m_82520_(0.0, (double)0.1f, 0.0), new Vec3(entity.rand().randomScaledGaussianValue(0.5), 0.25, entity.rand().randomScaledGaussianValue(0.5)), (Item)entity.rand().getRandomSelection((Object[])LOOT_ITEMS));
                    }
                }

                public void m_6710_(@org.jetbrains.annotations.Nullable LivingEntity target) {
                    if (target != null && target.m_6095_() != EntityType.f_20532_) {
                        return;
                    }
                    super.m_6710_(target);
                }
            };
            piglin.m_6710_(target);
            piglin.m_146884_(pos);
            piglin.m_6518_((ServerLevelAccessor)((ServerLevel)piglin.f_19853_), piglin.f_19853_.m_6436_(piglin.m_20183_()), MobSpawnType.REINFORCEMENT, null, null);
            return entity.f_19853_.m_7967_((Entity)piglin) ? piglin : null;
        }

        @Nullable
        private static LivingEntity summonEmbrake(final AoABoss entity, Vec3 pos, @org.jetbrains.annotations.Nullable LivingEntity target) {
            EmbrakeEntity embrake = new EmbrakeEntity((EntityType)AoAMobs.EMBRAKE.get(), entity.f_19853_){
                private final AoABoss kingBamBamBam;
                {
                    super((EntityType<? extends EmbrakeEntity>)entityType, world);
                    this.kingBamBamBam = entity;
                }

                public boolean m_6673_(DamageSource source) {
                    return source.m_269533_(DamageTypeTags.f_268415_) || super.m_6673_(source) || source.m_7639_() != null && PlayerUtil.getPlayerOrOwnerIfApplicable(source.m_7639_()) == null;
                }

                public void m_8119_() {
                    super.m_8119_();
                    if (this.kingBamBamBam == null || !this.kingBamBamBam.m_6084_() || this.f_19797_ > 12000) {
                        this.m_146870_();
                    }
                }

                public boolean m_142391_() {
                    return false;
                }

                protected void m_6668_(DamageSource source) {
                    for (int i = 0; i < 3; ++i) {
                        SummonMinions.createMagnetisedItemStack(entity, this.m_146892_().m_82520_(0.0, (double)0.1f, 0.0), new Vec3(entity.rand().randomScaledGaussianValue((double)0.3f), 0.25, entity.rand().randomScaledGaussianValue((double)0.3f)), (Item)entity.rand().getRandomSelection((Object[])LOOT_ITEMS));
                    }
                }

                public void m_6710_(@org.jetbrains.annotations.Nullable LivingEntity target) {
                    if (target != null && target.m_6095_() != EntityType.f_20532_) {
                        return;
                    }
                    super.m_6710_(target);
                }
            };
            embrake.m_6710_(target);
            embrake.m_146884_(pos);
            embrake.m_6518_((ServerLevelAccessor)((ServerLevel)embrake.f_19853_), embrake.f_19853_.m_6436_(embrake.m_20183_()), MobSpawnType.REINFORCEMENT, null, null);
            return entity.f_19853_.m_7967_((Entity)embrake) ? embrake : null;
        }

        private static void createMagnetisedItemStack(final AoABoss boss, Vec3 pos, Vec3 velocity, Item item) {
            ItemStack stack = item.m_7968_();
            stack.m_41663_(Enchantments.f_44963_, 1);
            ItemEntity itemEntity = new ItemEntity(boss.f_19853_, pos.f_82479_, pos.f_82480_, pos.f_82481_, stack, velocity.f_82479_, velocity.f_82480_, velocity.f_82481_){
                private final AoABoss magnetisedTo;
                {
                    super(pLevel, pPosX, pPosY, pPosZ, pItemStack, pDeltaX, pDeltaY, pDeltaZ);
                    this.magnetisedTo = boss;
                }

                public void m_8119_() {
                    if (this.magnetisedTo == null || !this.magnetisedTo.m_6084_()) {
                        this.m_146870_();
                    } else if (this.m_20186_() < (double)this.f_19853_.m_141937_()) {
                        this.m_146870_();
                    } else if (this.f_19797_ > 60) {
                        this.f_19864_ = true;
                        this.f_19794_ = true;
                        Vec3 startPos = this.m_146892_().m_82520_(0.0, (double)0.15f, 0.0);
                        Vec3 travelVector = this.magnetisedTo.m_146892_().m_82492_(0.0, (double)0.2f, 0.0).m_82546_(startPos);
                        Vec3 angle = travelVector.m_82541_();
                        double dist = travelVector.m_82553_();
                        ServerParticlePacket particlePacket = new ServerParticlePacket();
                        this.m_20242_(true);
                        this.m_20256_(angle.m_82490_((double)0.08f));
                        float i = 0.25f;
                        while ((double)i < dist) {
                            particlePacket.particle(ParticleBuilder.forPos((ParticleOptions)ParticleTypes.f_175830_, startPos.m_82549_(angle.m_82542_((double)i, (double)i, (double)i))).colourOverride(1.0f, 1.0f, 1.0f, 0.15f));
                            i += 0.5f;
                        }
                        if (this.magnetisedTo.m_20280_((Entity)this) < (double)3.1f) {
                            this.magnetisedTo.m_5634_(50.0f);
                            ((KingBamBamBamEntity)this.magnetisedTo).addEnergy(30);
                            this.magnetisedTo.triggerAnim("Gold Consumption", "consume");
                            AoAPackets.messageAllPlayersTrackingEntity(new AoASoundBuilderPacket(new SoundBuilder(SoundEvents.f_11676_).followEntity((Entity)this.magnetisedTo).category(SoundSource.HOSTILE).pitch(0.3f).varyPitch(0.1f)), (Entity)this.magnetisedTo);
                            particlePacket.particle(ParticleBuilder.forRandomPosInEntity((ParticleOptions)ParticleTypes.f_123750_, (Entity)this.magnetisedTo).spawnNTimes(10));
                            this.m_146870_();
                        } else if (!EntityRetrievalUtil.getPlayers((Level)this.f_19853_, (AABB)this.m_20191_().m_82377_(0.75, 2.0, 0.75)).isEmpty()) {
                            AoAPackets.messageNearbyPlayers(new AoASoundBuilderPacket(new SoundBuilder(SoundEvents.f_11676_).category(SoundSource.PLAYERS).atPos(this.f_19853_, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_)), (ServerLevel)this.f_19853_, this.m_20182_(), 6.0);
                            this.m_146870_();
                        }
                        AoAPackets.messageAllPlayersTrackingEntity(particlePacket, (Entity)this.magnetisedTo);
                    }
                    super.m_8119_();
                }

                public boolean m_142391_() {
                    return false;
                }

                public boolean m_6469_(DamageSource pSource, float pAmount) {
                    this.m_146870_();
                    return true;
                }

                public boolean m_32063_() {
                    if (this.f_19797_ > 5) {
                        this.m_32045_(ItemStack.f_41583_);
                    }
                    return true;
                }
            };
            itemEntity.m_32062_();
            boss.f_19853_.m_7967_((Entity)itemEntity);
        }

        public static enum Variant {
            LITTLE_BAM((Supplier<SoundEvent>)AoASounds.ENTITY_KING_BAMBAMBAM_SUMMON_1, 20, SummonMinions::summonLittleBam),
            PIGLIN_BRUTE((Supplier<SoundEvent>)AoASounds.ENTITY_KING_BAMBAMBAM_SUMMON_2, 30, SummonMinions::summonPiglinBrute),
            EMBRAKE((Supplier<SoundEvent>)AoASounds.ENTITY_KING_BAMBAMBAM_SUMMON_3, 40, SummonMinions::summonEmbrake);

            private final Supplier<SoundEvent> summonSound;
            private final int energyCost;
            private final TriFunction<AoABoss, Vec3, LivingEntity, LivingEntity> spawnFunction;

            private Variant(Supplier<SoundEvent> summonSound, int energyCost, TriFunction<AoABoss, Vec3, LivingEntity, LivingEntity> spawnFunction) {
                this.summonSound = summonSound;
                this.energyCost = energyCost;
                this.spawnFunction = spawnFunction;
            }
        }
    }
}

