/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.boss;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.entity.base.AoAMonster;
import net.tslat.aoa3.data.server.AoANowhereBossArenaListener;
import net.tslat.aoa3.library.builder.SoundBuilder;
import net.tslat.aoa3.util.WorldUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.RawAnimation;

public abstract class AoABoss
extends AoAMonster<AoABoss> {
    private final ServerBossEvent bossStatusTracker = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.NOTCHED_20).m_7003_(false).m_7006_(false);
    private SwingData swingData;
    private int lastArenaBoundTick = -1;

    protected AoABoss(EntityType<? extends AoABoss> entityType, Level level) {
        super(entityType, level);
        this.bossStatusTracker.f_18847_ = this.m_20148_();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.swingData = new SwingData();
        this.addSwingData(this.swingData);
    }

    protected void addSwingData(SwingData swings) {
    }

    @Override
    public int calculateKillXp() {
        return !this.hasDrops ? 0 : 2 * (int)(5.0 + (this.m_21133_(Attributes.f_22276_) + this.m_21133_(Attributes.f_22284_) * 1.75 + this.m_21133_(Attributes.f_22281_) * 2.0) / 10.0);
    }

    @javax.annotation.Nullable
    public abstract SoundEvent getMusic();

    public boolean m_6072_() {
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossStatusTracker.m_6456_(this.m_5446_());
        }
        this.bossStatusTracker.f_18847_ = this.m_20148_();
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossStatusTracker.m_6456_(this.m_5446_());
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.bossStatusTracker.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.f_19853_.m_46472_() == AoADimensions.NOWHERE.key && this.f_19797_ % 60 == 0) {
            if (this.f_19853_.m_6924_(Heightmap.Types.MOTION_BLOCKING, (int)this.m_20185_(), (int)this.m_20189_()) == this.f_19853_.m_141937_()) {
                if (this.lastArenaBoundTick != -1 && this.f_19797_ - this.lastArenaBoundTick >= 180) {
                    this.lastArenaBoundTick = -1;
                    AoANowhereBossArenaListener.NowhereBossArena arena = AoANowhereBossArenaListener.getClosestArena((ServerLevel)this.f_19853_, this.m_20182_());
                    if (arena != null) {
                        this.m_183634_();
                        this.m_146884_(arena.getRandomBossSpawn());
                    } else {
                        this.m_146870_();
                    }
                } else if (this.lastArenaBoundTick == -1) {
                    this.lastArenaBoundTick = this.f_19797_;
                }
            } else if (this.lastArenaBoundTick != -1) {
                this.lastArenaBoundTick = -1;
            }
        }
    }

    public SwingData getSwingData() {
        return this.swingData;
    }

    protected RawAnimation getSwingAnimation() {
        return this.getSwingAnimation((Integer)ATTACK_STATE.get((Entity)this));
    }

    protected RawAnimation getSwingAnimation(int state) {
        return this.swingData.getSwingAnimation(state);
    }

    protected int getSwingDurationTicks() {
        return this.getSwingDurationTicks((Integer)ATTACK_STATE.get((Entity)this));
    }

    protected int getSwingDurationTicks(int state) {
        return this.swingData.getSwingLength(state);
    }

    protected int getSwingWarmupTicks() {
        return this.getSwingWarmupTicks((Integer)ATTACK_STATE.get((Entity)this));
    }

    protected int getSwingWarmupTicks(int state) {
        return this.swingData.getSwingPreHurtTime(state);
    }

    @Override
    public int m_21304_() {
        int time = this.getSwingDurationTicks();
        if (MobEffectUtil.m_19584_((LivingEntity)this)) {
            time -= 1 + MobEffectUtil.m_19586_((LivingEntity)this);
        }
        if (this.m_21023_(MobEffects.f_19599_)) {
            time += (1 + this.m_21124_(MobEffects.f_19599_).m_19564_()) * 2;
        }
        return time;
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossStatusTracker.m_6543_(player);
        if (this.getMusic() != null && this.m_9236_().m_46472_() != AoADimensions.NOWHERE.key) {
            new SoundBuilder(this.getMusic()).isMusic().include(new Player[]{player}).execute();
        }
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossStatusTracker.m_6539_(player);
        if (this.getMusic() != null) {
            new SoundBuilder(this.getMusic()).isMusic().stopSound().include(new Player[]{player}).execute();
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        AoANowhereBossArenaListener.NowhereBossArena arena;
        if (source.m_276093_(DamageTypes.f_268724_) && WorldUtil.isWorld(this.f_19853_, AoADimensions.NOWHERE.key) && !this.f_19853_.m_5776_() && this.m_20186_() < (double)this.f_19853_.m_141937_() && (arena = AoANowhereBossArenaListener.getClosestArena((ServerLevel)this.f_19853_, this.m_20182_())) != null) {
            this.m_183634_();
            this.m_146884_(arena.getRandomBossSpawn());
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public record SwingData(Int2ObjectMap<Swing> data) {
        public SwingData() {
            this((Int2ObjectMap<Swing>)((Int2ObjectMap)Util.m_137469_((Object)new Int2ObjectOpenHashMap(), map -> map.defaultReturnValue((Object)new Swing(0, 0, RawAnimation.begin())))));
        }

        public void put(int key, Swing swing) {
            this.data.put(key, (Object)swing);
        }

        public Swing getSwing(int key) {
            return (Swing)this.data.get(key);
        }

        public int getSwingLength(int key) {
            return this.getSwing(key).animLength();
        }

        public int getSwingPreHurtTime(int key) {
            return this.getSwing(key).warmupTicks();
        }

        public RawAnimation getSwingAnimation(int key) {
            return this.getSwing(key).anim();
        }

        public record Swing(int animLength, int warmupTicks, RawAnimation anim) {
        }
    }
}

