/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.content.entity.base.AoAMonster;
import net.tslat.aoa3.content.entity.base.AoARangedAttacker;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.PositionAndMotionUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableRangedAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StayWithinDistanceOfAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.StrafeTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;

public abstract class AoARangedMob<T extends AoARangedMob<T>>
extends AoAMonster<T>
implements AoARangedAttacker {
    protected AoARangedMob(EntityType<? extends AoARangedMob> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
    }

    public BrainActivityGroup<T> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new InvalidateAttackTarget().invalidateIf((entity, target) -> {
            if (!target.m_6084_()) return true;
            if (target instanceof Player) {
                Player pl = (Player)target;
                if (pl.m_150110_().f_35934_) return true;
            }
            if (!(this.m_20238_(target.m_20182_()) > Math.pow(this.m_21133_(Attributes.f_22277_), 2.0))) return false;
            return true;
        }), this.isStrafingMob() ? new StrafeTarget() : new StayWithinDistanceOfAttackTarget(), new AnimatableRangedAttack(this.getPreAttackTime()).attackInterval(entity -> this.getAttackSwingDuration())});
    }

    @Override
    public int calculateKillXp() {
        return !this.hasDrops ? 0 : (int)(5.0 + (this.m_21133_(Attributes.f_22276_) + this.m_21133_(Attributes.f_22284_) * 1.75 + this.m_21133_(Attributes.f_22285_) * 1.5 + this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()) * 2.0) / 10.0);
    }

    protected boolean isStrafingMob() {
        return false;
    }

    @Nullable
    protected abstract SoundEvent getShootSound();

    protected abstract BaseMobProjectile getNewProjectileInstance();

    @Override
    public void doRangedAttackEntity(@Nullable BaseMobProjectile projectile, Entity target) {
        if (projectile != null) {
            boolean success;
            switch (projectile.getProjectileType()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case MAGIC: {
                    boolean bl = DamageUtil.doMagicProjectileAttack((Entity)this, (Entity)projectile, target, (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()));
                    break;
                }
                case GUN: {
                    boolean bl = DamageUtil.doGunAttack((Entity)this, (Entity)projectile, target, (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()));
                    break;
                }
                case PHYSICAL: {
                    boolean bl = DamageUtil.doProjectileAttack((Entity)this, (Entity)projectile, target, (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()));
                    break;
                }
                case ENERGY: {
                    boolean bl = success = DamageUtil.doEnergyProjectileAttack((Entity)this, (Entity)projectile, target, (float)this.m_21133_((Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get()));
                }
            }
            if (success) {
                this.onProjectileAttack(projectile, target);
            }
        }
    }

    @Override
    public void doRangedAttackBlock(@Nullable BaseMobProjectile projectile, BlockState blockHit, BlockPos pos, Direction sideHit) {
    }

    public void onProjectileAttack(@Nullable BaseMobProjectile projectile, Entity target) {
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        BaseMobProjectile projectile = this.getNewProjectileInstance();
        projectile.m_146922_(this.m_6080_());
        PositionAndMotionUtil.moveRelativeToFacing((Entity)projectile, 0.0, 0.0, 0.0);
        PositionAndMotionUtil.moveTowards((Entity)projectile, target.m_146892_(), 1.6, 4 - this.f_19853_.m_46791_().m_19028_());
        projectile.m_20256_(PositionAndMotionUtil.accountForGravity(projectile.m_20182_(), projectile.m_20184_(), target.m_20182_(), projectile.m_7139_()));
        PositionAndMotionUtil.faceTowardsMotion((Entity)projectile);
        if (this.getShootSound() != null) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getShootSound(), SoundSource.HOSTILE, 1.0f, 1.0f);
        }
        this.f_19853_.m_7967_((Entity)projectile);
    }
}

