/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ForgeHooks;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.content.entity.base.AoAEntityPart;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyLivingEntitySensor;
import net.tslat.aoa3.content.entity.brain.sensor.AggroBasedNearbyPlayersSensor;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FloatToSurfaceOfFluid;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.WalkOrRunToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AoAMonster<T extends AoAMonster<T>>
extends Monster
implements GeoEntity,
SmartBrainOwner<T> {
    public static final EntityDataHolder<Integer> ATTACK_STATE = EntityDataHolder.register(AoAMonster.class, EntityDataSerializers.f_135028_, 0, monster -> monster.attackState, (monster, value) -> {
        monster.attackState = value;
    });
    public static final EntityDataHolder<Boolean> INVULNERABLE = EntityDataHolder.register(AoAMonster.class, EntityDataSerializers.f_135035_, false, Entity::m_20147_, AoAMonster::m_20331_);
    public static final EntityDataHolder<Boolean> IMMOBILE = EntityDataHolder.register(AoAMonster.class, EntityDataSerializers.f_135035_, false, monster -> monster.immobile, (monster, value) -> {
        monster.immobile = value;
    });
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected AoAEntityPart<?>[] parts = new AoAEntityPart[0];
    private EntityDataHolder<?>[] dataParams;
    protected boolean hasDrops = true;
    private int attackState = 0;
    private boolean immobile = false;

    protected AoAMonster(EntityType<? extends AoAMonster> entityType, Level level) {
        super(entityType, level);
        this.m_21573_().m_7008_(true);
    }

    protected void m_8097_() {
        super.m_8097_();
        for (EntityDataHolder<?> dataHolder : this.dataParams = new EntityDataHolder[]{ATTACK_STATE, INVULNERABLE, IMMOBILE}) {
            dataHolder.defineDefault((Entity)this);
        }
    }

    protected final void registerDataParams(EntityDataHolder<?> ... params) {
        EntityDataHolder[] newArray = new EntityDataHolder[this.dataParams.length + params.length];
        System.arraycopy(this.dataParams, 0, newArray, 0, this.dataParams.length);
        System.arraycopy(params, 0, newArray, this.dataParams.length, params.length);
        for (EntityDataHolder<?> param : params) {
            param.defineDefault((Entity)this);
        }
        this.dataParams = newArray;
    }

    protected abstract float m_6431_(Pose var1, EntityDimensions var2);

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return null;
    }

    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        if (!blockState.m_60767_().m_76332_()) {
            BlockState state = this.f_19853_.m_8055_(pos.m_7494_());
            SoundType blockSound = state.m_60734_() == Blocks.f_50125_ ? state.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this) : blockState.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this);
            return blockSound.m_56776_();
        }
        return null;
    }

    public int m_8100_() {
        return 240;
    }

    public final RandomUtil.EasyRandom rand() {
        return new RandomUtil.EasyRandom(this.m_217043_());
    }

    protected Brain.Provider<T> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<ExtendedSensor<T>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new AggroBasedNearbyPlayersSensor(), new AggroBasedNearbyLivingEntitySensor().setPredicate((target, entity) -> {
            OwnableEntity tamedEntity;
            return target instanceof OwnableEntity && (tamedEntity = (OwnableEntity)target).m_21805_() != null;
        }).setScanRate(entity -> 40), new HurtBySensor()});
    }

    public BrainActivityGroup<T> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget(), new WalkOrRunToWalkTarget().startCondition(entity -> IMMOBILE.get((Entity)this) == false), new FloatToSurfaceOfFluid()});
    }

    public BrainActivityGroup<T> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new TargetOrRetaliate().useMemory(MemoryModuleType.f_148206_), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.9f), new Idle().runFor(entity -> entity.m_217043_().m_216339_(30, 60))})});
    }

    protected int getAttackSwingDuration() {
        return 6;
    }

    protected int getPreAttackTime() {
        return 0;
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22266_(Attributes.f_22281_).m_22266_(Attributes.f_22282_).m_22266_((Attribute)AoAAttributes.AGGRO_RANGE.get());
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType spawnReason) {
        return true;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.hasDrops = reason != MobSpawnType.MOB_SUMMONED;
        this.f_21364_ = this.calculateKillXp();
        if (reason == MobSpawnType.SPAWNER) {
            this.f_21364_ = (int)((double)this.f_21364_ * 0.5);
        }
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    public int calculateKillXp() {
        return !this.hasDrops ? 0 : (int)(5.0 + (this.m_21133_(Attributes.f_22276_) + this.m_21133_(Attributes.f_22284_) * 1.75 + this.m_21133_(Attributes.f_22285_) * 1.5) / 10.0);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        SoundEvent stepSound = this.getStepSound(pos, blockIn);
        if (stepSound != null) {
            this.m_5496_(stepSound, 0.15f, 1.0f);
        }
    }

    public int m_21304_() {
        int time = this.getAttackSwingDuration();
        if (MobEffectUtil.m_19584_((LivingEntity)this)) {
            time -= 1 + MobEffectUtil.m_19586_((LivingEntity)this);
        }
        if (this.m_21023_(MobEffects.f_19599_)) {
            time += (1 + this.m_21124_(MobEffects.f_19599_).m_19564_()) * 2;
        }
        return time;
    }

    protected void m_8024_() {
        this.tickBrain((LivingEntity)this);
    }

    @Nullable
    public LivingEntity m_5448_() {
        return BrainUtils.getTargetOfEntity((LivingEntity)this, (LivingEntity)super.m_5448_());
    }

    public boolean m_7327_(Entity target) {
        if (super.m_7327_(target)) {
            this.onAttack(target);
            return true;
        }
        return false;
    }

    protected void m_6475_(DamageSource source, float amount) {
        if (!this.m_6673_(source)) {
            Entity entity;
            if ((amount = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)source, (float)amount)) <= 0.0f) {
                return;
            }
            amount = this.m_21161_(source, amount);
            amount = this.m_6515_(source, amount);
            float adjustedDamage = Math.max(amount - this.m_6103_(), 0.0f);
            float absorbedAmount = amount - adjustedDamage;
            this.m_7911_(this.m_6103_() - absorbedAmount);
            if (absorbedAmount > 0.0f && absorbedAmount < 3.4028235E37f && (entity = source.m_7639_()) instanceof ServerPlayer) {
                ServerPlayer pl = (ServerPlayer)entity;
                pl.m_36222_(Stats.f_12929_, Math.round(absorbedAmount * 10.0f));
            }
            if ((adjustedDamage = ForgeHooks.onLivingDamage((LivingEntity)this, (DamageSource)source, (float)adjustedDamage)) != 0.0f) {
                float currentHealth = this.m_21223_();
                this.m_21231_().m_19289_(source, currentHealth, adjustedDamage);
                this.m_21153_(currentHealth - adjustedDamage);
                this.m_7911_(this.m_6103_() - adjustedDamage);
                this.m_146850_(GameEvent.f_223706_);
                this.onHurt(source, adjustedDamage);
            }
        }
    }

    protected void onAttack(Entity target) {
    }

    protected void onHurt(DamageSource source, float amount) {
    }

    public void m_6667_(DamageSource source) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)source)) {
            return;
        }
        if (!this.m_213877_() && !this.f_20890_) {
            Entity lastAttacker = source.m_7639_();
            LivingEntity killer = this.m_21232_();
            if (this.f_20897_ >= 0 && killer != null) {
                killer.m_5993_((Entity)this, this.f_20897_, source);
            }
            if (this.m_5803_()) {
                this.m_5796_();
            }
            this.f_20890_ = true;
            if (this.f_19853_ instanceof ServerLevel) {
                if (lastAttacker == null || lastAttacker.m_214076_((ServerLevel)this.f_19853_, (LivingEntity)this)) {
                    this.m_146850_(GameEvent.f_223707_);
                    this.m_6668_(source);
                    this.m_21268_(killer);
                }
                this.f_19853_.m_7605_((Entity)this, (byte)3);
            }
            this.m_21231_().m_19296_();
            this.m_20124_(Pose.DYING);
        }
    }

    public void m_20331_(boolean isInvulnerable) {
        if (!INVULNERABLE.is((Entity)this, isInvulnerable)) {
            INVULNERABLE.setRaw((Entity)this, isInvulnerable);
        }
        super.m_20331_(isInvulnerable);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        for (EntityDataHolder<?> dataHolder : this.dataParams) {
            if (dataHolder.checkSync((Entity)this, key)) break;
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("DropsLoot", this.hasDrops);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.hasDrops = compound.m_128471_("DropsLoot");
        INVULNERABLE.set((Entity)this, this.m_20147_());
    }

    public void m_8107_() {
        super.m_8107_();
        for (AoAEntityPart<?> part : this.getParts()) {
            part.updatePosition();
        }
    }

    protected boolean m_6125_() {
        return super.m_6125_() && this.hasDrops;
    }

    public boolean isMultipartEntity() {
        return this.getParts().length > 0;
    }

    public AoAEntityPart<?>[] getParts() {
        return this.parts;
    }

    protected void setParts(AoAEntityPart<?> ... parts) {
        if (this.parts.length > 0) {
            throw new IllegalStateException("Cannot add more parts after having already done so!");
        }
        this.parts = parts;
        this.m_20234_(f_19843_.getAndAdd(this.getParts().length + 1) + 1);
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        int newId = id + 1;
        for (AoAEntityPart<?> part : this.getParts()) {
            part.m_20234_(newId++);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }
}

