/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;

public class AoAEntityPart<T extends LivingEntity>
extends PartEntity<T> {
    private final Vec3 posOffset;
    private float damageMultiplier = 1.0f;
    private final EntityDimensions size;

    public AoAEntityPart(T parent, float width, float height, float offsetX, float offsetY, float offsetZ) {
        super(parent);
        this.size = EntityDimensions.m_20395_((float)width, (float)height);
        this.posOffset = new Vec3((double)offsetX, (double)offsetY, (double)offsetZ);
        this.m_146884_(parent.m_20182_().m_82520_((double)offsetX, (double)offsetY, (double)offsetZ));
        this.m_6210_();
    }

    public AoAEntityPart<T> setDamageMultiplier(float multiplier) {
        this.damageMultiplier = multiplier;
        return this;
    }

    public void updatePosition() {
        LivingEntity parent = (LivingEntity)this.getParent();
        double rot = Math.toRadians(-parent.f_20885_);
        double cos = Math.cos(rot);
        double sin = Math.sin(rot);
        double xRot = cos * this.posOffset.f_82479_ + sin * this.posOffset.f_82481_;
        double zRot = sin * this.posOffset.f_82479_ + cos * this.posOffset.f_82481_;
        this.m_146867_();
        this.m_6034_(parent.m_20182_().f_82479_ + xRot, parent.m_20182_().f_82480_ + this.posOffset.f_82480_, parent.m_20182_().f_82481_ + zRot);
    }

    @Nullable
    public ItemStack m_142340_() {
        return ((LivingEntity)this.getParent()).m_142340_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return !this.m_6673_(source) && ((LivingEntity)this.getParent()).m_6469_(source, amount * this.damageMultiplier);
    }

    public boolean m_6087_() {
        return true;
    }

    public ItemStack getPickedResult(HitResult target) {
        return ((LivingEntity)this.getParent()).m_142340_();
    }

    public boolean m_7306_(Entity entity) {
        return this == entity || this.getParent() == entity;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.size;
    }

    public boolean m_142391_() {
        return false;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }
}

