/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.object.EntityDataHolder;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.RandomUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AoAAmbientNPC
extends PathfinderMob
implements Npc,
GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private EntityDataHolder<?>[] dataParams;

    public AoAAmbientNPC(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        if (this.dataParams == null) {
            this.dataParams = new EntityDataHolder[0];
        }
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        for (EntityDataHolder<?> dataHolder : this.dataParams) {
            if (dataHolder.checkSync((Entity)this, key)) break;
        }
    }

    protected final void registerDataParams(EntityDataHolder<?> ... params) {
        EntityDataHolder[] newArray = new EntityDataHolder[this.dataParams.length + params.length];
        System.arraycopy(this.dataParams, 0, newArray, 0, this.dataParams.length);
        System.arraycopy(params, 0, newArray, this.dataParams.length, params.length);
        for (EntityDataHolder<?> param : params) {
            param.defineDefault((Entity)this);
        }
        this.dataParams = newArray;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, AoAMeleeMob.class, 8.0f, 0.8, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return null;
    }

    public RandomUtil.EasyRandom rand() {
        return new RandomUtil.EasyRandom(this.f_19796_);
    }

    @Nullable
    protected abstract String getInteractMessage(ItemStack var1);

    public boolean m_5545_(LevelAccessor world, MobSpawnType reason) {
        return this.checkSpawnChance(reason) && this.isValidLightLevel(reason) && this.canSpawnAt(reason, world.m_8055_(this.m_20183_().m_7495_()));
    }

    protected boolean canSpawnAt(MobSpawnType reason, BlockState blockState) {
        return reason == MobSpawnType.SPAWNER || blockState.m_60643_((BlockGetter)this.f_19853_, this.m_20183_(), this.m_6095_());
    }

    protected int getSpawnChanceFactor() {
        return 1;
    }

    private boolean checkSpawnChance(MobSpawnType reason) {
        return EntityUtil.isNaturalSpawnReason(reason) || this.getSpawnChanceFactor() <= 1 || this.f_19796_.m_188503_(this.getSpawnChanceFactor()) == 0;
    }

    protected boolean isValidLightLevel(MobSpawnType reason) {
        if (!WorldUtil.isWorld(this.f_19853_, AoADimensions.OVERWORLD.key)) {
            return true;
        }
        BlockPos blockpos = BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20191_().f_82289_, (double)this.m_20189_());
        if (this.f_19853_.m_45517_(LightLayer.SKY, blockpos) > this.f_19796_.m_188503_(32)) {
            return true;
        }
        int light = this.f_19853_.m_46470_() ? this.f_19853_.m_46849_(blockpos, 10) : this.f_19853_.m_46803_(blockpos);
        return light > this.f_19796_.m_188503_(8);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        String msg;
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_41720_() == Items.f_42656_) {
            heldStack.m_41647_(player, (LivingEntity)this, hand);
            return InteractionResult.SUCCESS;
        }
        if (!this.f_19853_.f_46443_ && hand == InteractionHand.MAIN_HAND && (msg = this.getInteractMessage(heldStack)) != null) {
            PlayerUtil.notifyPlayer(player, (Component)Component.m_237115_((String)msg).m_130940_(ChatFormatting.GRAY));
        }
        return super.m_6071_(player, hand);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }
}

