/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.animal;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.entity.ai.mob.CompletePanicGoal;
import net.tslat.aoa3.content.entity.base.AoAAnimal;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class ShikEntity
extends AoAAnimal {
    private static final EntityDataAccessor<Boolean> SCARED = SynchedEntityData.m_135353_(ShikEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DANCING = SynchedEntityData.m_135353_(ShikEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ShikEntity dancePartner = null;

    public ShikEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SCARED, (Object)false);
        this.f_19804_.m_135372_(DANCING, (Object)false);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicAndHideGoal(this, 100, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new ShikDanceGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 0.34375f;
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)AoASounds.ENTITY_SHIK_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_SHIK_DEATH.get();
    }

    @Override
    protected void m_7355_(BlockPos pos, BlockState block) {
    }

    public boolean isScared() {
        return (Boolean)this.f_19804_.m_135370_(SCARED);
    }

    public boolean isDancing() {
        return (Boolean)this.f_19804_.m_135370_(DANCING);
    }

    public boolean m_5545_(LevelAccessor world, MobSpawnType reason) {
        if (!EntityUtil.isNaturalSpawnReason(reason)) {
            return true;
        }
        if (this.m_20186_() >= 120.0) {
            return false;
        }
        BlockPos checkPos = new BlockPos((Vec3i)this.m_20183_());
        BlockState spawnBlock = world.m_8055_(checkPos.m_7495_());
        return spawnBlock.m_60734_() == AoABlocks.DENSE_STONE.get();
    }

    public float m_5610_(BlockPos pos, LevelReader world) {
        return world.m_8055_(pos.m_7495_()).m_204336_(Tags.Blocks.STONE) ? 1.0f : 1.0f - (float)world.m_46803_(pos) / 15.0f;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.f_19797_ > 400;
    }

    public class PanicAndHideGoal
    extends CompletePanicGoal {
        private BlockPos hidePos;

        public PanicAndHideGoal(ShikEntity shik, int timeToPanic, double speed) {
            super((PathfinderMob)shik, timeToPanic, speed);
        }

        @Override
        public boolean m_8036_() {
            if (this.taskOwner.m_217043_().m_188501_() <= 0.1f && !EntityRetrievalUtil.getEntities((Entity)this.taskOwner, (double)5.0, new EntityPredicate().isNot(this.taskOwner.m_6095_())).isEmpty()) {
                return this.getRandomPosition();
            }
            return super.m_8036_();
        }

        @Override
        public void m_8041_() {
            this.taskOwner.f_19794_ = false;
            ((ShikEntity)this.taskOwner).f_19804_.m_135381_(SCARED, (Object)false);
            super.m_8041_();
        }

        @Override
        public void m_8056_() {
            ((ShikEntity)this.taskOwner).f_19804_.m_135381_(SCARED, (Object)true);
            super.m_8056_();
        }

        @Override
        public void m_8037_() {
            if (this.taskOwner.m_217043_().m_188501_() < 0.1f) {
                int z;
                int x;
                BlockPos.MutableBlockPos checkPos;
                if (this.hidePos != null) {
                    if (this.hidePos.m_203198_(this.taskOwner.m_20185_(), this.taskOwner.m_20186_(), this.taskOwner.m_20189_()) < 3.0) {
                        ShikEntity.this.m_146870_();
                        return;
                    }
                    if (this.taskOwner.m_21573_().m_26571_()) {
                        checkPos = new BlockPos.MutableBlockPos();
                        for (x = -1; x <= 1; ++x) {
                            for (z = -1; z <= 1; ++z) {
                                if (this.taskOwner.f_19853_.m_8055_((BlockPos)checkPos.m_122169_(this.taskOwner.m_20185_() + (double)(-x), this.taskOwner.m_20186_(), this.taskOwner.m_20189_() + (double)(-z))).m_60734_() != AoABlocks.DENSE_STONE.get()) continue;
                                ShikEntity.this.m_146870_();
                                return;
                            }
                        }
                    }
                }
                if (this.hidePos == null && this.taskOwner.m_217043_().m_188501_() < 0.1f) {
                    checkPos = new BlockPos.MutableBlockPos();
                    for (x = 0; x <= 3; ++x) {
                        for (z = 0; z <= 3; ++z) {
                            if (this.taskOwner.f_19853_.m_8055_((BlockPos)checkPos.m_122169_(this.taskOwner.m_20185_() + (double)x, this.taskOwner.m_20186_(), this.taskOwner.m_20189_() + (double)z)).m_60734_() == AoABlocks.DENSE_STONE.get()) {
                                ShikEntity.this.m_21573_().m_26519_((double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_(), (double)checkPos.m_123343_() + 0.5, this.speed);
                                ++this.panicTimer;
                                this.hidePos = checkPos.m_7949_();
                                return;
                            }
                            if (this.taskOwner.f_19853_.m_8055_((BlockPos)checkPos.m_122169_(this.taskOwner.m_20185_() + (double)(-x), this.taskOwner.m_20186_(), this.taskOwner.m_20189_() + (double)(-z))).m_60734_() != AoABlocks.DENSE_STONE.get()) continue;
                            this.taskOwner.m_21573_().m_26519_((double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_(), (double)checkPos.m_123343_() + 0.5, this.speed);
                            ++this.panicTimer;
                            this.hidePos = checkPos.m_7949_();
                            return;
                        }
                    }
                }
            }
            super.m_8037_();
        }
    }

    private class ShikDanceGoal
    extends Goal {
        private final ShikEntity shik;
        private Vec3 startPos;
        private int danceTimer = 0;
        private int nextDanceTime = 0;
        private float danceAngleX;
        private float danceAngleZ;

        private ShikDanceGoal(ShikEntity shik) {
            this.shik = shik;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.nextDanceTime + 100 >= this.shik.f_19797_) {
                return false;
            }
            if (this.shik.dancePartner != null && this.shik.dancePartner.m_6084_()) {
                return true;
            }
            if (ShikEntity.this.f_19796_.m_188501_() <= 0.05f) {
                List dancePartners = ShikEntity.this.f_19853_.m_45976_(ShikEntity.class, ShikEntity.this.m_20191_().m_82400_(0.5));
                for (ShikEntity potentialPartner : dancePartners) {
                    if (potentialPartner == this.shik || potentialPartner.isScared() || !potentialPartner.m_6084_() || potentialPartner.dancePartner != null || !potentialPartner.m_142582_((Entity)this.shik) || !this.shik.m_142582_((Entity)potentialPartner)) continue;
                    this.shik.dancePartner = potentialPartner;
                    potentialPartner.dancePartner = this.shik;
                    return true;
                }
            }
            return false;
        }

        public void m_8041_() {
            this.shik.f_19804_.m_135381_(DANCING, (Object)false);
            this.startPos = null;
            this.danceTimer = 0;
            this.shik.m_21573_().m_26573_();
            this.nextDanceTime = ShikEntity.this.f_19797_;
            this.shik.dancePartner = null;
        }

        public void m_8056_() {
            ShikEntity.this.m_21573_().m_26573_();
            this.startPos = ShikEntity.this.m_20182_();
            this.shik.f_19804_.m_135381_(DANCING, (Object)true);
            this.shik.m_21563_().m_24950_(this.shik.dancePartner.m_20185_(), this.shik.dancePartner.m_20186_() + (double)this.shik.dancePartner.m_20192_(), this.shik.dancePartner.m_20189_(), (float)this.shik.dancePartner.m_8085_(), (float)this.shik.dancePartner.m_8132_());
            this.danceAngleX = Mth.m_14031_((float)(this.shik.m_146908_() * (float)Math.PI / 180.0f)) * 2.0f;
            this.danceAngleZ = Mth.m_14089_((float)(this.shik.m_146908_() * (float)Math.PI / 180.0f)) * 2.0f;
            ShikEntity.this.m_21573_().m_26519_(this.startPos.f_82479_ + (double)(this.danceAngleX * 5.0f), this.startPos.f_82480_, this.startPos.f_82481_ + (double)(this.danceAngleZ * 5.0f), 1.25);
        }

        public void m_8037_() {
            ++this.danceTimer;
            this.shik.m_21563_().m_24950_(this.shik.dancePartner.m_20185_(), this.shik.dancePartner.m_20186_() + (double)this.shik.dancePartner.m_20192_(), this.shik.dancePartner.m_20189_(), (float)this.shik.dancePartner.m_8085_(), (float)this.shik.dancePartner.m_8132_());
            this.shik.m_19915_(this.shik.f_20885_, this.shik.m_146909_());
            if (this.danceTimer % 10 == 0 || ShikEntity.this.m_21573_().m_26571_()) {
                this.danceAngleX *= -1.0f;
                this.danceAngleZ *= -1.0f;
                this.shik.m_21573_().m_26573_();
                this.shik.m_21573_().m_26519_(this.startPos.f_82479_ + (double)(this.danceAngleX * 5.0f), this.startPos.f_82480_, this.startPos.f_82481_ + (double)(this.danceAngleZ * 5.0f), 1.25);
            }
        }

        public boolean m_8045_() {
            return this.shik.dancePartner != null && this.startPos != null && this.shik.dancePartner.m_6084_() && this.danceTimer < 100;
        }
    }
}

