/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.mob;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class AdventBowAttackGoal<T extends Mob>
extends Goal {
    private final T shooter;
    private final double moveSpeedAmp;
    private int attackCooldown;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public AdventBowAttackGoal(T shooter, double moveSpeedAmplifier, int attackCooldown, float maxAttackDistance) {
        this.shooter = shooter;
        this.moveSpeedAmp = moveSpeedAmplifier;
        this.attackCooldown = attackCooldown;
        this.maxAttackDistance = maxAttackDistance * maxAttackDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setAttackCooldown(int attackCooldown) {
        this.attackCooldown = attackCooldown;
    }

    public boolean m_8036_() {
        return this.shooter.m_5448_() != null && this.isBowInMainhand();
    }

    protected boolean isBowInMainhand() {
        return this.shooter.m_21205_().m_41720_() instanceof BowItem || this.shooter.m_21206_().m_41720_() instanceof BowItem;
    }

    public boolean m_8045_() {
        return (this.m_8036_() || !this.shooter.m_21573_().m_26571_()) && this.isBowInMainhand();
    }

    public void m_8056_() {
        super.m_8056_();
        this.shooter.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.shooter.m_21561_(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.shooter.m_5810_();
    }

    public void m_8037_() {
        LivingEntity target = this.shooter.m_5448_();
        if (target != null) {
            double distanceToTarget = this.shooter.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            boolean canSeeTarget = this.shooter.m_21574_().m_148306_((Entity)target);
            if (canSeeTarget != this.seeTime > 0) {
                this.seeTime = 0;
            }
            this.seeTime = canSeeTarget ? ++this.seeTime : --this.seeTime;
            if (!(distanceToTarget > (double)this.maxAttackDistance) && this.seeTime >= 20) {
                this.shooter.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                this.shooter.m_21573_().m_5624_((Entity)target, this.moveSpeedAmp);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.shooter.m_217043_().m_188501_() < 0.3) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.shooter.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distanceToTarget > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (distanceToTarget < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.shooter.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.shooter.m_21391_((Entity)target, 30.0f, 30.0f);
            } else {
                this.shooter.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            if (this.shooter.m_6117_()) {
                int maxItemUseTime;
                if (!canSeeTarget && this.seeTime < -60) {
                    this.shooter.m_5810_();
                } else if (canSeeTarget && (maxItemUseTime = this.shooter.m_21252_()) >= 20) {
                    this.shooter.m_5810_();
                    ((RangedAttackMob)this.shooter).m_6504_(target, BowItem.m_40661_((int)maxItemUseTime));
                    this.attackTime = this.attackCooldown;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.shooter.m_6672_(ProjectileUtil.m_37297_(this.shooter, (Item)Items.f_42411_));
            }
        }
    }
}

