/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai;

import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.scores.Team;
import net.tslat.aoa3.content.entity.ai.ExtendedGoal;

public abstract class ExtendedTargetGoal<T extends Mob>
extends ExtendedGoal<T> {
    protected boolean requireLineOfSight = false;
    protected boolean mustBePathable = false;
    protected int occludedTargetMemoryTime = 60;
    protected int nextPathCheck;
    protected boolean canPathTo = false;
    protected int targetOccludedTime;
    @Nullable
    protected LivingEntity target = null;

    protected ExtendedTargetGoal(T entity) {
        super(entity);
    }

    public ExtendedTargetGoal<T> requireLineOfSight() {
        this.requireLineOfSight = true;
        return this;
    }

    public ExtendedTargetGoal<T> onlyPathableTargets() {
        this.mustBePathable = true;
        return this;
    }

    public ExtendedTargetGoal<T> rememberLostTargetsFor(int ticks) {
        this.occludedTargetMemoryTime = ticks;
        return this;
    }

    @Override
    public boolean m_8045_() {
        if (!super.m_8045_()) {
            return false;
        }
        if (this.target == null && (this.target = this.entity.m_5448_()) == null) {
            return false;
        }
        if (!this.entity.m_6779_(this.target)) {
            return false;
        }
        Team team = this.entity.m_5647_();
        if (team != null && team == this.target.m_5647_()) {
            return false;
        }
        double followRange = this.getTargetingRange();
        if (this.entity.m_20280_((Entity)this.target) > followRange * followRange) {
            return false;
        }
        if (this.requireLineOfSight) {
            if (this.entity.m_21574_().m_148306_((Entity)this.target)) {
                this.targetOccludedTime = 0;
            } else if (this.targetOccludedTime++ > ExtendedTargetGoal.m_186073_((int)this.occludedTargetMemoryTime)) {
                return false;
            }
        }
        this.entity.m_6710_(this.target);
        return true;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.targetOccludedTime = 0;
        this.nextPathCheck = 0;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.entity.m_6710_(null);
        this.target = null;
    }

    protected boolean isAttackable(LivingEntity target, TargetingConditions predicate) {
        if (!predicate.m_26885_((LivingEntity)this.entity, target)) {
            return false;
        }
        if (!this.entity.m_21444_(target.m_20183_())) {
            return false;
        }
        if (this.mustBePathable) {
            if (this.nextPathCheck-- <= 0) {
                this.canPathTo = this.canPathTo(target);
            }
            return this.canPathTo;
        }
        return true;
    }

    protected boolean canPathTo(LivingEntity entity) {
        this.nextPathCheck = ExtendedTargetGoal.m_186073_((int)(10 + this.entity.m_217043_().m_188503_(5)));
        Path path = this.entity.m_21573_().m_6570_((Entity)this.target, 0);
        if (path == null) {
            return false;
        }
        Node pathEnd = path.m_77395_();
        if (pathEnd == null) {
            return false;
        }
        return Math.pow(pathEnd.f_77271_ - this.target.m_146903_(), 2.0) + Math.pow(pathEnd.f_77273_ - this.target.m_146907_(), 2.0) <= 2.25;
    }

    protected double getTargetingRange() {
        return this.entity.m_21133_(Attributes.f_22277_);
    }
}

