/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai;

import java.util.function.Consumer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.tslat.smartbrainlib.util.RandomUtil;

public abstract class ExtendedGoal<T extends Mob>
extends Goal {
    protected final T entity;
    private Consumer<ExtendedGoal<T>> onStart = goal -> {};
    private Consumer<ExtendedGoal<T>> onStop = goal -> {};
    private Consumer<ExtendedGoal<T>> onTelegraphStart = goal -> {};
    private IntProvider maxRunningTime = ConstantInt.m_146483_((int)Integer.MAX_VALUE);
    private IntProvider cooldownProvider = ConstantInt.m_146483_((int)-1);
    protected int chargeUpTime = 0;
    protected int actionTelegraphTicks = 0;
    protected int taskExpiresAt = Integer.MAX_VALUE;
    protected int runningTime = 0;
    protected long nextAvailableTime = 0L;
    protected int nextActionTelegraphCompleteTime = 0;
    private boolean trackingTime = false;

    protected ExtendedGoal(T entity) {
        this.entity = entity;
    }

    public ExtendedGoal<T> onStart(Consumer<ExtendedGoal<T>> consumer) {
        this.onStart = consumer;
        return this;
    }

    public ExtendedGoal<T> onStop(Consumer<ExtendedGoal<T>> consumer) {
        this.onStop = consumer;
        return this;
    }

    public ExtendedGoal<T> onTelegraphStart(Consumer<ExtendedGoal<T>> consumer) {
        this.onTelegraphStart = consumer;
        return this;
    }

    public ExtendedGoal<T> cooldown(IntProvider cooldownProvider) {
        this.cooldownProvider = cooldownProvider;
        return this;
    }

    public ExtendedGoal<T> maxRuntime(IntProvider ticksProvider) {
        this.maxRunningTime = ticksProvider;
        this.trackingTime = true;
        return this;
    }

    public ExtendedGoal<T> chargeUpTime(int ticks) {
        this.chargeUpTime = ticks;
        this.trackingTime = true;
        return this;
    }

    public ExtendedGoal<T> actionTelegraphTicks(int ticks) {
        this.actionTelegraphTicks = ticks;
        this.trackingTime = true;
        return this;
    }

    public boolean m_8036_() {
        return this.nextAvailableTime < ((Mob)this.entity).f_19853_.m_46467_();
    }

    public boolean m_8045_() {
        return this.runningTime < this.taskExpiresAt;
    }

    public boolean m_183429_() {
        return this.trackingTime;
    }

    public void m_8056_() {
        super.m_8056_();
        this.onStart.accept(this);
        this.runningTime = 0;
        this.taskExpiresAt = this.maxRunningTime.m_214085_((RandomSource)RandomUtil.RANDOM);
    }

    public void m_8041_() {
        super.m_8041_();
        this.onStop.accept(this);
        this.nextAvailableTime = ((Mob)this.entity).f_19853_.m_46467_() + (long)this.cooldownProvider.m_214085_((RandomSource)RandomUtil.RANDOM);
        this.nextActionTelegraphCompleteTime = 0;
    }

    public void m_8037_() {
        ++this.runningTime;
    }

    protected boolean hasChargedUp() {
        return this.chargeUpTime <= this.runningTime;
    }

    protected boolean hasActionTelegraphFinished() {
        return this.nextActionTelegraphCompleteTime <= this.runningTime;
    }

    protected void startTelegraphingNextAction() {
        this.nextActionTelegraphCompleteTime = this.runningTime + this.actionTelegraphTicks;
        this.onTelegraphStart.accept(this);
    }

    protected boolean isTelegraphingAction() {
        return this.nextActionTelegraphCompleteTime < Integer.MAX_VALUE;
    }

    protected void resetActionTelegraph() {
        this.nextActionTelegraphCompleteTime = Integer.MAX_VALUE;
    }
}

