/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.plants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.IPlantable;
import net.tslat.aoa3.util.BlockUtil;

public class StackablePlant
extends Block
implements IForgeShearable,
IPlantable {
    protected Supplier<Block> hatBlock = () -> this;
    protected Supplier<Block> stemBlock = () -> this;
    protected final List<Material> growthMaterials;

    public StackablePlant(BlockBehaviour.Properties properties, Material ... growthMaterial) {
        super(properties);
        this.growthMaterials = Arrays.asList(growthMaterial);
    }

    public StackablePlant(Material material, MaterialColor mapColour, SoundType sound, Material ... growthMaterial) {
        super(new BlockUtil.CompactProperties(material, mapColour).sound(sound).noClip().get());
        this.growthMaterials = Arrays.asList(growthMaterial);
    }

    public StackablePlant(MaterialColor mapColour, Material ... growthMaterials) {
        this(Material.f_76300_, mapColour, SoundType.f_56740_, growthMaterials);
    }

    public StackablePlant setStemBlock(Supplier<Block> block) {
        this.stemBlock = block;
        return this;
    }

    public StackablePlant setHatBlock(Supplier<Block> block) {
        this.hatBlock = block;
        return this;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos newPos = pos.m_7494_();
        BlockState blockState = world.m_8055_(newPos);
        Block block = blockState.m_60734_();
        while (block == this.stemBlock.get() || block == this.hatBlock.get()) {
            world.m_7731_(newPos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, newPos, Block.m_49956_((BlockState)blockState));
            if (!world.m_5776_() && !player.m_7500_()) {
                StackablePlant.m_49881_((BlockState)state, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
                StackablePlant.m_49881_((BlockState)blockState, (Level)world, (BlockPos)newPos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
            newPos = newPos.m_7494_();
            blockState = world.m_8055_(newPos);
            block = blockState.m_60734_();
        }
        super.m_5707_(world, pos, state, player);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState targetState = world.m_8055_(pos.m_7495_());
        return (this.growthMaterials.isEmpty() || this.growthMaterials.contains(targetState.m_60767_())) && targetState.m_60804_((BlockGetter)world, pos.m_7495_()) || targetState.m_60734_() == this.stemBlock.get();
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, world, pos, facingPos);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return true;
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.AIR && !this.f_60443_ || super.m_7357_(state, worldIn, pos, type);
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public BlockState getPlant(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() != this) {
            return this.m_49966_();
        }
        return state;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((ItemLike)Item.m_41439_((Block)this)));
        return drops;
    }
}

