/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.generation.plants;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.IPlantable;
import net.tslat.aoa3.util.BlockUtil;

public class GenericPlantBlock
extends Block
implements IForgeShearable,
IPlantable {
    private static final VoxelShape SHAPE = Shapes.m_83064_((AABB)new AABB(0.1, 0.0, 0.1, 0.9, 0.9, 0.9));
    protected final List<Material> growthMaterials;

    public GenericPlantBlock(Material material, MaterialColor mapColour, SoundType sound, int lightLevel, Material ... growthMaterials) {
        super(new BlockUtil.CompactProperties(material, mapColour).stats(0.0f, 0.0f).sound(sound).light(lightLevel).noClip().get());
        this.growthMaterials = Arrays.asList(growthMaterials);
    }

    public GenericPlantBlock(Material material, MaterialColor mapColour, SoundType sound, Material ... growthMaterials) {
        this(material, mapColour, sound, 0, growthMaterials);
    }

    public GenericPlantBlock(Material material, MaterialColor mapColour, Material ... growthMaterials) {
        this(material, mapColour, SoundType.f_56740_, growthMaterials);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockState targetState = world.m_8055_(pos.m_7495_());
        return (this.growthMaterials.isEmpty() || this.growthMaterials.contains(targetState.m_60767_())) && targetState.m_60804_((BlockGetter)world, pos.m_7495_());
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.AIR && !this.f_60443_ || super.m_7357_(state, worldIn, pos, type);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, world, pos, facingPos);
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return true;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState getPlant(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() != this) {
            return this.m_49966_();
        }
        return state;
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        if (!world.m_5776_()) {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(new ItemStack((ItemLike)Item.m_41439_((Block)this)));
            return drops;
        }
        return new ArrayList<ItemStack>();
    }
}

