/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.portal;

import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.common.particletype.PortalFloaterParticleType;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.functional.portal.PortalBlock;
import net.tslat.aoa3.data.server.AoANowhereParkourCourseListener;
import net.tslat.aoa3.event.dimension.NowhereEvents;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;

public class NowhereActivityPortal
extends PortalBlock {
    private static final EnumProperty<Activity> ACTIVITY = EnumProperty.m_61587_((String)"activity", Activity.class);

    public NowhereActivityPortal() {
        super(AoADimensions.NOWHERE.key, MaterialColor.f_76366_, 0);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(ACTIVITY, (Comparable)((Object)Activity.UTILITY)));
    }

    @Override
    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity.m_20202_() == null && !entity.m_20160_() && entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            if (WorldUtil.isWorld(pl.f_19853_, AoADimensions.NOWHERE.key)) {
                if (pl.f_19818_ > 0) {
                    pl.f_19818_ = 30;
                    return;
                }
                pl.f_19818_ = 100;
                ((Activity)((Object)state.m_61143_(ACTIVITY))).activate(pl);
            }
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVITY});
    }

    @Override
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        for (int i = 0; i < 4; ++i) {
            int colour;
            double posXStart = (float)pos.m_123341_() + rand.m_188501_();
            double posYStart = (float)pos.m_123342_() + rand.m_188501_();
            double posZStart = (float)pos.m_123343_() + rand.m_188501_();
            double motionX = ((double)rand.m_188501_() - 0.5) * 0.5;
            double motionY = ((double)rand.m_188501_() - 0.5) * 0.5;
            double motionZ = ((double)rand.m_188501_() - 0.5) * 0.5;
            int randomMod = rand.m_188503_(2) * 2 - 1;
            switch ((Activity)((Object)state.m_61143_(ACTIVITY))) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case PARKOUR: {
                    int n = 39103;
                    break;
                }
                case PARKOUR_1: {
                    int n = 9175295;
                    break;
                }
                case PARKOUR_2: {
                    int n = 262388;
                    break;
                }
                case PARKOUR_3: {
                    int n = 12449536;
                    break;
                }
                case PARKOUR_4: {
                    int n = 0xFFCC00;
                    break;
                }
                case PARKOUR_5: {
                    int n = 14711552;
                    break;
                }
                case PARKOUR_6: {
                    int n = 0xD30000;
                    break;
                }
                case BOSSES: {
                    int n = 0xBA0000;
                    break;
                }
                case DUNGEON: {
                    int n = 9502944;
                    break;
                }
                case UTILITY: {
                    int n = 29210;
                    break;
                }
                case RETURN: {
                    int n = colour = 0xFFFFFF;
                }
            }
            if (world.m_8055_(pos.m_122024_()).m_60734_() != this && world.m_8055_(pos.m_122029_()).m_60734_() != this) {
                posXStart = (double)pos.m_123341_() + 0.5 + 0.25 * (double)randomMod;
                motionX = rand.m_188501_() * 2.0f * (float)randomMod;
            } else {
                posZStart = (double)pos.m_123343_() + 0.5 + 0.25 * (double)randomMod;
                motionZ = rand.m_188501_() * 2.0f * (float)randomMod;
            }
            world.m_7106_((ParticleOptions)new PortalFloaterParticleType.Data(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), colour), posXStart, posYStart, posZStart, motionX, motionY, motionZ);
        }
    }

    public static enum Activity implements StringRepresentable
    {
        PARKOUR(21.5, 10.5, 22.0, 90.0f, pl -> {
            ServerPlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
            plData.storeInventoryContents();
        }),
        PARKOUR_1(pl -> Activity.findParkourCourse(pl, 1), pl -> ItemUtil.givePlayerItemOrDrop((Player)pl, new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()))),
        PARKOUR_2(pl -> Activity.findParkourCourse(pl, 2), pl -> ItemUtil.givePlayerItemOrDrop((Player)pl, new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()))),
        PARKOUR_3(pl -> Activity.findParkourCourse(pl, 3), pl -> ItemUtil.givePlayerItemOrDrop((Player)pl, new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()))),
        PARKOUR_4(pl -> Activity.findParkourCourse(pl, 4), pl -> ItemUtil.givePlayerItemOrDrop((Player)pl, new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()))),
        PARKOUR_5(pl -> Activity.findParkourCourse(pl, 5), pl -> ItemUtil.givePlayerItemOrDrop((Player)pl, new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()))),
        PARKOUR_6(pl -> Activity.findParkourCourse(pl, 6), pl -> ItemUtil.givePlayerItemOrDrop((Player)pl, new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()))),
        BOSSES(17.5, 502.5, 3.5, 0.0f),
        DUNGEON(6.5, 1501.5, 16.5, -90.0f),
        UTILITY(25.5, 1001.5, 16.0, 90.0f),
        RETURN(pl -> Activity.doReturnPortalTeleport(pl, 16.5, 1501.5, 16.5, 180.0f), pl -> {
            if (!NowhereEvents.isInParkourRegion(pl.m_20183_())) {
                ItemUtil.clearInventoryOfItems((Player)pl, new ItemStack((ItemLike)AoAItems.RETURN_CRYSTAL.get()));
                PlayerUtil.getAdventPlayer(pl).returnItemStorage();
                PlayerUtil.resetToDefaultStatus(pl);
            }
        });

        private final Predicate<ServerPlayer> teleportFunction;
        private final Consumer<ServerPlayer> afterTeleportFunction;

        private Activity(Predicate<ServerPlayer> teleportFunction, Consumer<ServerPlayer> afterTeleportFunction) {
            this.teleportFunction = teleportFunction;
            this.afterTeleportFunction = afterTeleportFunction;
        }

        private Activity(double x, double y, double z) {
            this(x, y, z, 0.0f);
        }

        private Activity(double x, double y, double z, float rot) {
            this(x, y, z, rot, null);
        }

        private Activity(double x, double y, @Nullable double z, float rot, Consumer<ServerPlayer> afterTeleportFunction) {
            this(pl -> {
                pl.f_8906_.m_9774_(x, y, z, rot, pl.m_146909_());
                return true;
            }, afterTeleportFunction == null ? pl -> {} : afterTeleportFunction);
        }

        public String m_7912_() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        public void teleport(ServerPlayer pl) {
            AoAScheduler.scheduleSyncronisedTask(() -> this.teleportFunction.test(pl), 1);
        }

        public void activate(ServerPlayer pl) {
            AoAScheduler.scheduleSyncronisedTask(() -> {
                if (this.teleportFunction.test(pl)) {
                    this.afterTeleportFunction.accept(pl);
                }
            }, 1);
        }

        private static boolean doReturnPortalTeleport(ServerPlayer pl, double x, double y, double z, float rot) {
            AoANowhereParkourCourseListener.NowhereParkourCourse course;
            if (NowhereEvents.isInParkourRegion(pl.m_20183_()) && (course = AoANowhereParkourCourseListener.getCourseForPosition(pl.m_9236_(), pl.m_20182_())) != null) {
                course.grantRewards(pl);
                AoANowhereParkourCourseListener.NowhereParkourCourse nextCourse = AoANowhereParkourCourseListener.getNextCourse(course);
                if (nextCourse != null) {
                    nextCourse.teleportPlayerToCourse(pl);
                    return true;
                }
            }
            pl.f_8906_.m_9774_(x, y, z, rot, pl.m_146909_());
            return true;
        }

        private static boolean findParkourCourse(ServerPlayer pl, int tier) {
            AoANowhereParkourCourseListener.NowhereParkourCourse course = AoANowhereParkourCourseListener.getFirstCourseForTier(tier);
            if (course == null) {
                return false;
            }
            course.teleportPlayerToCourse(pl);
            return true;
        }
    }
}

