/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.misc;

import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.content.block.functional.misc.TrophyBlock;
import net.tslat.aoa3.content.block.tileentity.TrophyTileEntity;
import net.tslat.aoa3.content.item.misc.summoning.BossTokenItem;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RegistryUtil;
import org.jetbrains.annotations.Nullable;

public class GoldTrophyBlock
extends TrophyBlock
implements BossTokenItem {
    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        TrophyTileEntity trophyTile;
        ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TrophyTileEntity && (trophyTile = (TrophyTileEntity)tile).getEntityId() != null) {
            CompoundTag nbt = new CompoundTag();
            CompoundTag dataTag = new CompoundTag();
            dataTag.m_128359_("EntityID", ((TrophyTileEntity)tile).getEntityId());
            dataTag.m_128379_("OriginalTrophy", ((TrophyTileEntity)tile).isOriginal());
            nbt.m_128365_("BlockEntityTag", (Tag)dataTag);
            stack.m_41751_(nbt);
            if (trophyTile.getCachedEntity() != null) {
                Entity cachedEntity = ((TrophyTileEntity)tile).getCachedEntity();
                MutableComponent entityName = cachedEntity == null ? Component.m_237113_((String)"") : cachedEntity.m_6095_().m_20676_();
                stack.m_41714_((Component)LocaleUtil.getLocaleMessage("block.aoa3.gold_trophy.desc", ChatFormatting.GOLD, new Component[]{entityName}));
            }
        }
        return stack;
    }

    @Override
    public Entity spawnBoss(ServerLevel level, Vec3 position, ItemStack itemStack) {
        return EntitySpawningUtil.spawnEntity(level, this.getEntityType(itemStack), position, MobSpawnType.TRIGGERED);
    }

    @Nullable
    public EntityType<?> getEntityType(ItemStack stack) {
        if (!TrophyBlock.isOriginal(stack)) {
            return null;
        }
        EntityType<?> cachedEntity = TrophyBlock.getCachedEntityType(stack);
        if (cachedEntity == null) {
            return null;
        }
        ResourceLocation id = RegistryUtil.getId(cachedEntity);
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(id.m_135827_(), "elite_" + id.m_135815_()));
    }
}

