/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.altar;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.functional.altar.BossAltarBlock;
import net.tslat.aoa3.content.block.functional.misc.DustopianLamp;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.smartbrainlib.util.RandomUtil;

public class PrimordialShrine
extends BossAltarBlock {
    public PrimordialShrine() {
        super(MaterialColor.f_76388_);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_46791_() == Difficulty.PEACEFUL && player instanceof ServerPlayer) {
            PlayerUtil.notifyPlayer(player, (Component)Component.m_237115_((String)"message.feedback.spawnBoss.difficultyFail"));
            return InteractionResult.FAIL;
        }
        if (!world.f_46443_ && this.checkActivationConditions(player, hand, state, pos)) {
            this.doActivationEffect(player, hand, state, pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected boolean checkActivationConditions(Player player, InteractionHand hand, BlockState state, BlockPos pos) {
        if (!WorldUtil.isWorld(player.f_19853_, AoADimensions.DUSTOPIA.key)) {
            return false;
        }
        return this.checkLamps(player.f_19853_, pos.m_7918_(5, 1, -3), pos.m_7918_(4, 1, -1), pos.m_7918_(3, 3, 1), pos.m_7918_(1, 5, 1), pos.m_7918_(-1, 5, 1), pos.m_7918_(-3, 3, 1), pos.m_7918_(-4, 1, -1), pos.m_7918_(-5, 1, -3));
    }

    private boolean checkLamps(Level world, BlockPos ... positions) {
        for (BlockPos pos : positions) {
            BlockState state = world.m_8055_(pos);
            if (state.m_60734_() == AoABlocks.DUSTOPIAN_LAMP.get() && ((Boolean)state.m_61143_((Property)DustopianLamp.LIT)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void doActivationEffect(Player player, InteractionHand hand, BlockState state, BlockPos blockPos) {
        Level world = player.f_19853_;
        BlockState lampOff = (BlockState)((Block)AoABlocks.DUSTOPIAN_LAMP.get()).m_49966_().m_61124_((Property)DustopianLamp.LIT, (Comparable)Boolean.valueOf(false));
        world.m_46597_((BlockPos)RandomUtil.getRandomSelection((Object[])new BlockPos[]{blockPos.m_7918_(5, 1, -3), blockPos.m_7918_(4, 1, -1), blockPos.m_7918_(3, 3, 1), blockPos.m_7918_(1, 5, 1), blockPos.m_7918_(-1, 5, 1), blockPos.m_7918_(-3, 3, 1), blockPos.m_7918_(-4, 1, -1), blockPos.m_7918_(-5, 1, -3)}), lampOff);
    }

    @Override
    protected Item getActivationItem() {
        return null;
    }
}

