/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.altar;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class GuardianAltar
extends Block {
    public GuardianAltar() {
        super(new BlockUtil.CompactProperties(Material.f_76278_, MaterialColor.f_76417_).stats(35.0f, 1000.0f).get());
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (!WorldUtil.isWorld(world, AoADimensions.HAVEN.key)) {
            return InteractionResult.FAIL;
        }
        if (heldStack.m_41720_() == AoAItems.VOLIANT_HEART.get()) {
            if (!world.f_46443_) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (world.m_46681_(pos.m_121945_(direction), direction) != 0) continue;
                    return InteractionResult.FAIL;
                }
                if (!world.m_6443_(Monster.class, new AABB((double)(pos.m_123341_() - 15), (double)(pos.m_123342_() - 15), (double)(pos.m_123343_() - 15), (double)(pos.m_123341_() + 15), (double)(pos.m_123342_() + 15), (double)(pos.m_123343_() + 15)), entity -> !entity.m_6072_()).isEmpty()) {
                    return InteractionResult.FAIL;
                }
                if (!player.m_7500_()) {
                    heldStack.m_41774_(1);
                }
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockPos checkPos = pos.m_121945_(direction);
                    if (world.m_8055_(checkPos).m_60734_() != Blocks.f_50088_) continue;
                    this.breakWire(world, checkPos, 0);
                }
                for (Player pl : world.m_45976_(Player.class, new AABB((double)(pos.m_123341_() - 25), (double)(pos.m_123342_() - 25), (double)(pos.m_123343_() - 25), (double)(pos.m_123341_() + 26), (double)(pos.m_123342_() + 26), (double)(pos.m_123343_() + 26)))) {
                    pl.m_213846_((Component)LocaleUtil.getLocaleMessage("message.mob.four_guardians.spawn"));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private int breakWire(Level world, BlockPos curPos, int currentCount) {
        world.m_7967_((Entity)new ItemEntity(world, (double)curPos.m_123341_(), (double)curPos.m_123342_(), (double)curPos.m_123343_(), new ItemStack((ItemLike)Blocks.f_50088_)));
        world.m_46597_(curPos, Blocks.f_50016_.m_49966_());
        ++currentCount;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos newPos = curPos.m_121945_(direction);
            if (world.m_8055_(newPos).m_60734_() == Blocks.f_50088_) {
                currentCount = this.breakWire(world, newPos, currentCount);
            }
            if (currentCount < 20) continue;
            return currentCount;
        }
        return currentCount;
    }
}

