/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.tslat.aoa3.library.constant.BossDropsScheme;

public final class ServerConfig {
    public final ForgeConfigSpec.BooleanValue allowUnsafeInfusion;
    public final ForgeConfigSpec.IntValue portalSearchRadius;
    public final ForgeConfigSpec.BooleanValue easyCorruptedTravellers;
    public final ForgeConfigSpec.BooleanValue allowNonPlayerPortalTravel;
    public final ForgeConfigSpec.DoubleValue globalXpModifier;
    public final ForgeConfigSpec.BooleanValue saveLootFromExplosions;
    public final ForgeConfigSpec.BooleanValue disableSkills;
    public final ForgeConfigSpec.EnumValue<BossDropsScheme> bossDropsScheme;
    public final ForgeConfigSpec.BooleanValue skillsLeaderboardEnabled;
    public final ForgeConfigSpec.IntValue maxLeaderboardThreads;
    public final ForgeConfigSpec.BooleanValue dontCacheDatabase;
    public final ForgeConfigSpec.ConfigValue<String> databaseUsername;
    public final ForgeConfigSpec.ConfigValue<String> databasePassword;

    public ServerConfig(ForgeConfigSpec.Builder configBuilder) {
        configBuilder.comment("AoA server-side configuration options").push("General Settings");
        this.allowUnsafeInfusion = configBuilder.comment("Set this to false to disable enchantments that breach level caps").translation("config.aoa3.server.allowUnsafeInfusion").define("allowUnsafeInfusion", true);
        this.portalSearchRadius = configBuilder.comment(new String[]{"Adjust this value to modify how far to look for safe/existing portal locations.", "The lower the value, the faster it runs"}).translation("config.aoa3.server.portalSearchRadius").defineInRange("portalSearchRadius", 24, 1, 128);
        this.easyCorruptedTravellers = configBuilder.comment("Set this to true to make Corrupted Travellers easier to find, causing them to glow through blocks when nearby.").translation("config.aoa3.server.easyCorruptedTravellers").define("easyCorruptedTravellers", false);
        this.allowNonPlayerPortalTravel = configBuilder.comment("Set to false to stop non-player entities from using the AoA portal system.").translation("config.aoa3.server.allowNonPlayerPortalTravel").define("allowNonPlayerPortalTravel", true);
        this.globalXpModifier = configBuilder.comment(new String[]{"Modifier for global xp gain for all players for AoA skills.", "Higher numbers means more xp gained"}).translation("config.aoa3.server.globalXpModifier").defineInRange("globalXpModifier", 1.0, 0.0, 1000.0);
        this.saveLootFromExplosions = configBuilder.comment("Set to false to stop AoA saving loot-drops from explosions.").translation("config.aoa3.server.saveLootFromExplosions").define("saveLootFromExplosions", true);
        this.disableSkills = configBuilder.comment(new String[]{"Set to false to disable all AoA Skills for the server.", "This may give a slight performance improvement.", "NOTE: This will cause any player who logs in to lose any levels & xp they may have previously stored. Only turn this on if you intend for the server to run without skills."}).translation("config.aoa3.server.disableSkills").define("disableSkills", false);
        this.bossDropsScheme = configBuilder.comment("Select the method in which Nowhere boss loot should be distributed on kill.").translation("config.aoa3.server.bossDropsScheme").defineEnum("bossDropsScheme", (Enum)BossDropsScheme.SPLIT_BETWEEN_PLAYERS);
        configBuilder.pop();
        configBuilder.comment("AoA Leaderboard configuration options").push("Leaderboard Settings");
        this.skillsLeaderboardEnabled = configBuilder.comment(new String[]{"Set to false to disable the skills leaderboard entirely.", "NOTE: Disabling the leaderboard will prevent it from updating its data, and game data changes while the leaderboard is disabled will not be tracked if re-enabled."}).translation("config.aoa3.server.skillsLeaderboardEnabled").define("skillsLeaderboardEnabled", false);
        this.maxLeaderboardThreads = configBuilder.comment(new String[]{"The amount of threads & connections to the skills database AoA will try to make. Less threads may produce a negligible memory usage improvement, and more threads may improve database performance on larger servers.", "You shouldn't need to change this unless you know what you're doing."}).translation("config.aoa3.server.maxLeaderboardThreads").defineInRange("maxLeaderboardThreads", 4, 1, 100);
        this.dontCacheDatabase = configBuilder.comment("Set this to false to disable in-memory databases for leaderboards. This can save on RAM usage, but may reduce performance of the leaderboard's functionality and increase disk usage.").translation("config.aoa3.server.dontCacheDatabase").define("dontCacheDatabase", false);
        this.databaseUsername = configBuilder.comment("The username to use for leaderboard database connection. You shouldn't need to change this.").translation("config.aoa3.server.databaseUsername").define("databaseUsername", (Object)"User");
        this.databasePassword = configBuilder.comment(new String[]{"The password to use along with the databaseUsername for leaderboard database connection. You shouldn't need to change this.", "NOTE: If setting your own password, be aware this will be stored in easily accessible plaintext. Use a throwaway password."}).translation("config.aoa3.server.databasePassword").define("databasePassword", (Object)"Password");
        configBuilder.pop();
    }
}

