/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.entity.AoAAnimals;
import net.tslat.aoa3.common.registration.entity.AoAMobs;
import net.tslat.aoa3.common.registration.entity.AoANpcs;
import net.tslat.aoa3.content.entity.mob.nether.NethengeicBeastEntity;
import net.tslat.aoa3.util.WorldUtil;
import org.apache.logging.log4j.Level;

public final class AoAEntitySpawnPlacements {
    private static final SpawnPlacements.Type AMPHIBIOUS = SpawnPlacements.Type.create((String)"AMPHIBIOUS", (level, pos, entityType) -> NaturalSpawner.canSpawnAtBody((SpawnPlacements.Type)(level.m_6425_(pos).m_76178_() ? SpawnPlacements.Type.ON_GROUND : SpawnPlacements.Type.IN_WATER), (LevelReader)level, (BlockPos)pos, (EntityType)entityType));

    public static void lateInit() {
        Logging.logStatusMessage("Setting entity spawn placements");
        AoAEntitySpawnPlacements.setOverworldSpawnPlacements();
    }

    public static void setOverworldSpawnPlacements() {
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.ANCIENT_GOLEM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_DAY_MONSTER.noLowerThanY(65));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.BOMB_CARRIER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_DAY_MONSTER.noLowerThanY(55).spawnChance(0.2f));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.BUSH_BABY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, SpawnBuilder.DEFAULT_DAY_MONSTER.noLowerThanY(65));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.CHARGER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_DAY_MONSTER);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.CHOMPER.get(), AMPHIBIOUS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_DAY_MONSTER);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.CYCLOPS.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_DAY_MONSTER.noLowerThanY(55));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.EMBRAKE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new SpawnBuilder().noPeacefulSpawn().spawnChance(0.5f).noSpawnOn(Blocks.f_50451_).ifValidSpawnBlock());
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.FLAMEWALKER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new SpawnBuilder().noPeacefulSpawn().noSpawnOn(Blocks.f_50451_).ifValidSpawnBlock());
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.GHOST.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_MONSTER.noHigherThanY(0).spawnChance(0.5f));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.GOBLIN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_DAY_MONSTER);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.ICE_GIANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_DAY_MONSTER.spawnChance(0.06666667f));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.INFERNAL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new SpawnBuilder().noPeacefulSpawn().spawnChance(0.1f).noSpawnOn(Blocks.f_50451_).ifValidSpawnBlock());
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.KING_CHARGER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_DAY_MONSTER.spawnChance(0.05f));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.LEAFY_GIANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_DAY_MONSTER.spawnChance(0.06666667f));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.LITTLE_BAM.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new SpawnBuilder().noPeacefulSpawn().spawnChance(0.5f).noSpawnOn(Blocks.f_50451_).ifValidSpawnBlock());
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.NETHENGEIC_BEAST.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new SpawnBuilder().noPeacefulSpawn().noSpawnOn(Blocks.f_50451_).ifValidSpawnBlock().and(NethengeicBeastEntity::checkSpawnConditions));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.SAND_GIANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_DAY_MONSTER.spawnChance(0.06666667f));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.SASQUATCH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_DAY_MONSTER.noLowerThanY(55));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.STONE_GIANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_DAY_MONSTER.spawnChance(0.06666667f));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.TREE_SPIRIT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_DAY_MONSTER.noLowerThanY(55).spawnChance(0.1f));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.VOID_WALKER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_MONSTER.noHigherThanY(0));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.WOOD_GIANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_DAY_MONSTER.spawnChance(0.06666667f));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.YETI.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_DAY_MONSTER.noLowerThanY(45).spawnChance(0.5f));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.SHINY_SQUID.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new SpawnBuilder(GlowSquid::m_217017_).spawnChance(0.001f));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoANpcs.LOTTOMAN.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new SpawnBuilder().ifValidSpawnBlock());
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoANpcs.UNDEAD_HERALD.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new SpawnBuilder().ifValidSpawnBlock());
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.BLUE_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.CANDLEFISH.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_LAVA_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.CHARRED_CHAR.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_LAVA_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.CHOCAW.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.CRIMSON_SKIPPER.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_LAVA_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.CRIMSON_STRIPEFISH.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_LAVA_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.DARK_HATCHETFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.GREEN_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.HYDRONE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.IRONBACK.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.JAMFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.PARAPIRANHA.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.PEARL_STRIPEFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.PURPLE_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.RAINBOWFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.RAZORFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.RED_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.REEFTOOTH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.ROCKETFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.SAILBACK.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.SAPPHIRE_STRIDER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.SKELECANTH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.WHITE_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.YELLOW_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.TURQUOISE_STRIPEFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.VIOLET_SKIPPER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnBuilder.DEFAULT_FISH);
    }

    private static <T extends Mob> void setSpawnPlacement(EntityType<T> entityType, SpawnPlacements.Type placementType, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<? extends Mob> spawnPredicate) {
        try {
            if (SpawnPlacements.m_21752_(entityType) == SpawnPlacements.Type.NO_RESTRICTIONS) {
                SpawnPlacements.m_21754_(entityType, (SpawnPlacements.Type)placementType, (Heightmap.Types)heightmap, spawnPredicate);
            }
        }
        catch (IllegalStateException ex) {
            Logging.logMessage(Level.WARN, "Caught duplicate spawn placement registration from: " + ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString());
        }
    }

    private static final class SpawnBuilder<T extends Mob>
    implements SpawnPlacements.SpawnPredicate<T> {
        static final SpawnBuilder<Mob> DEFAULT_FISH = new SpawnBuilder().onlySpawnIn(Blocks.f_49990_).onlySpawnUnder(Blocks.f_49990_);
        static final SpawnBuilder<Mob> DEFAULT_LAVA_FISH = new SpawnBuilder().onlySpawnIn(Blocks.f_49991_).onlySpawnUnder(Blocks.f_49991_);
        static final SpawnBuilder<Mob> DEFAULT_MONSTER = new SpawnBuilder().noPeacefulSpawn().defaultMonsterLightLevels().ifValidSpawnBlock();
        static final SpawnBuilder<Mob> DEFAULT_DAY_MONSTER = new SpawnBuilder().noPeacefulSpawn().onlyDuringDay().defaultMonsterBlockLightLevels().difficultyBasedSpawnChance(0.12f).ifValidSpawnBlock();
        private final SpawnPlacements.SpawnPredicate<T> predicate;

        SpawnBuilder() {
            this((entityType, world, spawnType, pos, rand) -> true);
        }

        SpawnBuilder(SpawnPlacements.SpawnPredicate<T> predicate) {
            this.predicate = predicate;
        }

        public boolean m_217080_(EntityType<T> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource rand) {
            return this.predicate.m_217080_(entityType, level, spawnType, pos, rand);
        }

        SpawnBuilder<T> noPeacefulSpawn() {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && level.m_46791_() != Difficulty.PEACEFUL);
        }

        SpawnBuilder<T> ifValidSpawnBlock() {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)rand));
        }

        SpawnBuilder<T> noLowerThanY(int minY) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && pos.m_123342_() >= minY);
        }

        SpawnBuilder<T> noHigherThanY(int maxY) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && pos.m_123342_() <= maxY);
        }

        SpawnBuilder<T> betweenYLevels(int minY, int maxY) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && pos.m_123342_() >= minY && pos.m_123342_() <= maxY);
        }

        SpawnBuilder<T> spawnChance(float chance) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && rand.m_188501_() < chance);
        }

        SpawnBuilder<T> difficultyBasedSpawnChance(float chance) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && rand.m_188501_() < chance * level.m_6436_(pos).m_19056_());
        }

        SpawnBuilder<T> noSpawnOn(TagKey<Block> blockTag) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && !level.m_8055_(pos.m_7495_()).m_204336_(blockTag));
        }

        SpawnBuilder<T> noSpawnOn(Block block) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && !level.m_8055_(pos.m_7495_()).m_60713_(block));
        }

        SpawnBuilder<T> onlySpawnOn(TagKey<Block> blockTag) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && level.m_8055_(pos.m_7495_()).m_204336_(blockTag));
        }

        SpawnBuilder<T> onlySpawnOn(Block block) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && level.m_8055_(pos.m_7495_()).m_60713_(block));
        }

        SpawnBuilder<T> onlySpawnIn(TagKey<Block> blockTag) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && level.m_8055_(pos).m_204336_(blockTag));
        }

        SpawnBuilder<T> onlySpawnIn(Block block) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && level.m_8055_(pos).m_60713_(block));
        }

        SpawnBuilder<T> onlySpawnUnder(TagKey<Block> blockTag) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && level.m_8055_(pos.m_7494_()).m_204336_(blockTag));
        }

        SpawnBuilder<T> onlySpawnUnder(Block block) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && level.m_8055_(pos.m_7494_()).m_60713_(block));
        }

        SpawnBuilder<T> minLightLevel(int lightLevel) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && WorldUtil.getLightLevel(level, pos, false, false) >= lightLevel);
        }

        SpawnBuilder<T> maxLightLevel(int lightLevel) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && WorldUtil.getLightLevel(level, pos, false, false) <= lightLevel);
        }

        SpawnBuilder<T> defaultMonsterLightLevels() {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && Monster.m_219009_((ServerLevelAccessor)level, (BlockPos)pos, (RandomSource)rand));
        }

        SpawnBuilder<T> defaultMonsterBlockLightLevels() {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && WorldUtil.getLightLevel(level, pos, true, false) <= level.m_6042_().m_223570_());
        }

        SpawnBuilder<T> onlyDuringDay() {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && level.m_6018_().m_46461_());
        }

        SpawnBuilder<T> and(SpawnPlacements.SpawnPredicate<T> predicate) {
            return new SpawnBuilder<T>((entityType, level, spawnType, pos, rand) -> this.predicate.m_217080_(entityType, level, spawnType, pos, rand) && predicate.m_217080_(entityType, level, spawnType, pos, rand));
        }
    }
}

