/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.advent.AoAStartupCache;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.common.registration.item.AoAArmour;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.item.AoATools;
import net.tslat.aoa3.common.registration.item.AoAWeapons;
import net.tslat.aoa3.util.LocaleUtil;

public final class AoACreativeModeTabs {
    public static CreativeModeTab MISC_ITEMS;
    public static CreativeModeTab FOOD;
    public static CreativeModeTab TOOLS;
    public static CreativeModeTab ARMOUR;
    public static CreativeModeTab SWORDS;
    public static CreativeModeTab GREATBLADES;
    public static CreativeModeTab MAULS;
    public static CreativeModeTab GUNS;
    public static CreativeModeTab CANNONS;
    public static CreativeModeTab SHOTGUNS;
    public static CreativeModeTab SNIPERS;
    public static CreativeModeTab BLASTERS;
    public static CreativeModeTab CROSSBOWS;
    public static CreativeModeTab BOWS;
    public static CreativeModeTab THROWN_WEAPONS;
    public static CreativeModeTab STAVES;
    public static CreativeModeTab VULCANES;
    public static CreativeModeTab AMMUNITION;
    public static CreativeModeTab TABLETS;
    public static CreativeModeTab GENERATION_BLOCKS;
    public static CreativeModeTab DECORATION_BLOCKS;
    public static CreativeModeTab FUNCTIONAL_BLOCKS;
    public static CreativeModeTab BANNERS;

    public static void init() {
        AdventOfAscension.modEventBus.addListener(EventPriority.NORMAL, false, CreativeModeTabEvent.Register.class, AoACreativeModeTabs::registerTabs);
        AdventOfAscension.modEventBus.addListener(EventPriority.NORMAL, false, CreativeModeTabEvent.BuildContents.class, AoACreativeModeTabs::fillVanillaTabs);
    }

    private static void registerTabs(CreativeModeTabEvent.Register ev) {
        MISC_ITEMS = AoACreativeModeTabs.register(ev, "miscellaneous", () -> new ItemStack((ItemLike)AoAItems.LIMONITE_INGOT.get()), () -> MISC_ITEMS, CreativeModeTabs.f_256731_);
        FOOD = AoACreativeModeTabs.register(ev, "food", () -> new ItemStack((ItemLike)AoAItems.COOKED_RAINBOWFISH.get()), () -> FOOD, MISC_ITEMS);
        TOOLS = AoACreativeModeTabs.register(ev, "tools", () -> new ItemStack((ItemLike)AoATools.LIMONITE_PICKAXE.get()), () -> TOOLS, FOOD);
        ARMOUR = AoACreativeModeTabs.register(ev, "armour", () -> new ItemStack((ItemLike)AoAArmour.ALACRITY_ARMOUR.chestplate.get()), () -> ARMOUR, TOOLS);
        SWORDS = AoACreativeModeTabs.register(ev, "swords", () -> new ItemStack((ItemLike)AoAWeapons.LIMONITE_SWORD.get()), () -> SWORDS, ARMOUR);
        GREATBLADES = AoACreativeModeTabs.register(ev, "greatblades", () -> new ItemStack((ItemLike)AoAWeapons.BLOODLURKER.get()), () -> GREATBLADES, SWORDS);
        MAULS = AoACreativeModeTabs.register(ev, "mauls", () -> new ItemStack((ItemLike)AoAWeapons.HORIZON_MAUL.get()), () -> MAULS, GREATBLADES);
        GUNS = AoACreativeModeTabs.register(ev, "guns", () -> new ItemStack((ItemLike)AoAWeapons.SQUAD_GUN.get()), () -> GUNS, MAULS);
        CANNONS = AoACreativeModeTabs.register(ev, "cannons", () -> new ItemStack((ItemLike)AoAWeapons.BLAST_CANNON.get()), () -> CANNONS, GUNS);
        SHOTGUNS = AoACreativeModeTabs.register(ev, "shotguns", () -> new ItemStack((ItemLike)AoAWeapons.BLAST_BARREL.get()), () -> SHOTGUNS, CANNONS);
        SNIPERS = AoACreativeModeTabs.register(ev, "snipers", () -> new ItemStack((ItemLike)AoAWeapons.BOLT_RIFLE.get()), () -> SNIPERS, SHOTGUNS);
        BLASTERS = AoACreativeModeTabs.register(ev, "blasters", () -> new ItemStack((ItemLike)AoAWeapons.LASER_BLASTER.get()), () -> BLASTERS, SNIPERS);
        CROSSBOWS = AoACreativeModeTabs.register(ev, "crossbows", () -> new ItemStack((ItemLike)AoAWeapons.LUNAR_CROSSBOW.get()), () -> CROSSBOWS, BLASTERS);
        BOWS = AoACreativeModeTabs.register(ev, "bows", () -> new ItemStack((ItemLike)AoAWeapons.SPEED_BOW.get()), () -> BOWS, CROSSBOWS);
        THROWN_WEAPONS = AoACreativeModeTabs.register(ev, "thrown_weapons", () -> new ItemStack((ItemLike)AoAWeapons.GRENADE.get()), () -> THROWN_WEAPONS, BOWS);
        STAVES = AoACreativeModeTabs.register(ev, "staves", () -> new ItemStack((ItemLike)AoAWeapons.CELESTIAL_STAFF.get()), () -> STAVES, THROWN_WEAPONS);
        VULCANES = AoACreativeModeTabs.register(ev, "vulcanes", () -> new ItemStack((ItemLike)AoAWeapons.VULCANE.get()), () -> VULCANES, STAVES);
        AMMUNITION = AoACreativeModeTabs.register(ev, "ammunition", () -> new ItemStack((ItemLike)AoAItems.LIMONITE_BULLET.get()), () -> AMMUNITION, VULCANES);
        TABLETS = AoACreativeModeTabs.register(ev, "tablets", () -> new ItemStack((ItemLike)AoAItems.AGILITY_TABLET.get()), () -> TABLETS, AMMUNITION);
        GENERATION_BLOCKS = AoACreativeModeTabs.register(ev, "worldgen_blocks", () -> new ItemStack((ItemLike)AoABlocks.LELYETIAN_GRASS.get()), () -> GENERATION_BLOCKS, TABLETS);
        DECORATION_BLOCKS = AoACreativeModeTabs.register(ev, "decoration_blocks", () -> new ItemStack((ItemLike)AoABlocks.BARON_STONE_BRICKS.get()), () -> DECORATION_BLOCKS, GENERATION_BLOCKS);
        FUNCTIONAL_BLOCKS = AoACreativeModeTabs.register(ev, "functional_blocks", () -> new ItemStack((ItemLike)AoABlocks.SHADOW_ALTAR.get()), () -> FUNCTIONAL_BLOCKS, DECORATION_BLOCKS);
        BANNERS = AoACreativeModeTabs.register(ev, "banners", () -> new ItemStack((ItemLike)AoABlocks.ANCIENT_BANNER.get()), () -> BANNERS, FUNCTIONAL_BLOCKS);
    }

    private static CreativeModeTab register(CreativeModeTabEvent.Register ev, String id, Supplier<ItemStack> icon, Supplier<CreativeModeTab> tab, CreativeModeTab afterTab) {
        return ev.registerCreativeModeTab(AdventOfAscension.id(id), List.of(), List.of(afterTab), builder -> builder.m_257941_((Component)LocaleUtil.getLocaleMessage("itemGroup.aoa3." + id)).m_257737_(icon).m_257501_((arg_0, arg_1) -> AoACreativeModeTabs.lambda$register$46((Supplier)tab, arg_0, arg_1)));
    }

    private static void fillVanillaTabs(CreativeModeTabEvent.BuildContents ev) {
        ev.m_246601_(AoAStartupCache.getItemsForTab(ev.getTab()));
    }

    private static /* synthetic */ void lambda$register$46(Supplier tab, CreativeModeTab.ItemDisplayParameters displayParams, CreativeModeTab.Output output) {
        output.m_246601_(AoAStartupCache.getItemsForTab((CreativeModeTab)tab.get()));
    }
}

