/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.particletype;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.common.registration.AoAParticleTypes;

public class PortalFloaterParticleType
extends ParticleType<Data> {
    public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("portal_x").forGetter(data -> data.portalPos.m_7096_()), (App)Codec.DOUBLE.fieldOf("portal_y").forGetter(data -> data.portalPos.m_7098_()), (App)Codec.DOUBLE.fieldOf("portal_z").forGetter(data -> data.portalPos.m_7094_()), (App)Codec.FLOAT.fieldOf("red").forGetter(data -> Float.valueOf(data.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(data -> Float.valueOf(data.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(data -> Float.valueOf(data.blue)), (App)Codec.FLOAT.fieldOf("alpha").forGetter(data -> Float.valueOf(data.alpha))).apply((Applicative)instance, (x, y, z, red, green, blue, alpha) -> new Data(new Vec3(x.doubleValue(), y.doubleValue(), z.doubleValue()), red.floatValue(), green.floatValue(), blue.floatValue(), alpha.floatValue())));

    public PortalFloaterParticleType(boolean alwaysShow) {
        super(alwaysShow, Data.DESERIALIZER);
    }

    public Codec<Data> m_7652_() {
        return CODEC;
    }

    public static class Data
    implements ParticleOptions {
        public final Vec3 portalPos;
        public final float red;
        public final float green;
        public final float blue;
        public final float alpha;
        public static final ParticleOptions.Deserializer<Data> DESERIALIZER = new ParticleOptions.Deserializer<Data>(){

            public Data fromCommand(ParticleType<Data> particleType, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                double x = reader.readDouble();
                reader.expect(' ');
                double y = reader.readDouble();
                reader.expect(' ');
                double z = reader.readDouble();
                reader.expect(' ');
                float red = (float)reader.readDouble();
                reader.expect(' ');
                float green = (float)reader.readDouble();
                reader.expect(' ');
                float blue = (float)reader.readDouble();
                reader.expect(' ');
                float alpha = (float)reader.readDouble();
                return new Data(new Vec3(x, y, z), red, green, blue, alpha);
            }

            public Data fromNetwork(ParticleType<Data> particleType, FriendlyByteBuf buffer) {
                return new Data(new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble()), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        };

        public Data(Vec3 portalPos, int colour) {
            this(portalPos, (float)(colour >> 16) / 255.0f, (float)(colour >> 8 & 0xFF) / 255.0f, (float)(colour & 0xFF) / 255.0f, (float)(colour >> 24) / 255.0f);
        }

        public Data(Vec3 portalPos, float red, float green, float blue, float alpha) {
            this.portalPos = portalPos;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha == 0.0f ? 1.0f : alpha;
        }

        public ParticleType<?> m_6012_() {
            return (ParticleType)AoAParticleTypes.PORTAL_FLOATER.get();
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeDouble(this.portalPos.f_82479_);
            buffer.writeDouble(this.portalPos.f_82480_);
            buffer.writeDouble(this.portalPos.f_82481_);
            buffer.writeFloat(this.red);
            buffer.writeFloat(this.green);
            buffer.writeFloat(this.blue);
            buffer.writeFloat(this.alpha);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.alpha));
        }
    }
}

