/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.particletype;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomisableParticleType
extends ParticleType<Data> {
    public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("particle_type").forGetter(data -> ForgeRegistries.PARTICLE_TYPES.getKey(data.particleType).toString()), (App)Codec.FLOAT.fieldOf("scale").forGetter(data -> Float.valueOf(data.scale)), (App)Codec.FLOAT.fieldOf("age_modifier").forGetter(data -> Float.valueOf(data.ageModifier)), (App)Codec.FLOAT.fieldOf("red").forGetter(data -> Float.valueOf(data.red)), (App)Codec.FLOAT.fieldOf("green").forGetter(data -> Float.valueOf(data.green)), (App)Codec.FLOAT.fieldOf("blue").forGetter(data -> Float.valueOf(data.blue)), (App)Codec.FLOAT.fieldOf("alpha").forGetter(data -> Float.valueOf(data.alpha)), (App)Codec.INT.fieldOf("entity_id").forGetter(data -> data.entitySourceId)).apply((Applicative)instance, (type, scale, ageMod, red, green, blue, alpha, entityId) -> new Data((ParticleType<Data>)((ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(new ResourceLocation(type))), scale.floatValue(), ageMod.floatValue(), red.floatValue(), green.floatValue(), blue.floatValue(), alpha.floatValue(), (int)entityId)));

    public CustomisableParticleType(boolean alwaysShow) {
        super(alwaysShow, Data.DESERIALIZER);
    }

    public Codec<Data> m_7652_() {
        return CODEC;
    }

    public static class Data
    implements ParticleOptions {
        public final ParticleType<Data> particleType;
        public final float scale;
        public final float ageModifier;
        public final float red;
        public final float green;
        public final float blue;
        public final float alpha;
        public final int entitySourceId;
        public static final ParticleOptions.Deserializer<Data> DESERIALIZER = new ParticleOptions.Deserializer<Data>(){

            public Data fromCommand(ParticleType<Data> particleType, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float scale = (float)reader.readDouble();
                reader.expect(' ');
                float ageMod = (float)reader.readDouble();
                reader.expect(' ');
                float red = (float)reader.readDouble();
                reader.expect(' ');
                float green = (float)reader.readDouble();
                reader.expect(' ');
                float blue = (float)reader.readDouble();
                reader.expect(' ');
                float alpha = (float)reader.readDouble();
                reader.expect(' ');
                int entityId = reader.readInt();
                return new Data(particleType, scale, ageMod, red, green, blue, alpha, entityId);
            }

            public Data fromNetwork(ParticleType<Data> particleType, FriendlyByteBuf buffer) {
                return new Data(particleType, buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.m_130242_());
            }
        };

        public Data(ParticleType<Data> particleType, int colour) {
            this(particleType, 1.0f, 1.0f, colour);
        }

        public Data(ParticleType<Data> particleType, float scale, float ageModifier, int colour) {
            this(particleType, scale, ageModifier, (float)(colour >> 16) / 255.0f, (float)(colour >> 8 & 0xFF) / 255.0f, (float)(colour & 0xFF) / 255.0f, (float)(colour >> 24) / 255.0f, -1);
        }

        public Data(ParticleType<Data> particleType, float scale, float ageModifier, float red, float green, float blue, float alpha, int entityId) {
            this.scale = scale;
            this.ageModifier = ageModifier;
            this.particleType = particleType;
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
            this.entitySourceId = entityId;
        }

        public ParticleType<?> m_6012_() {
            return this.particleType;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeFloat(this.scale);
            buffer.writeFloat(this.ageModifier);
            buffer.writeFloat(this.red);
            buffer.writeFloat(this.green);
            buffer.writeFloat(this.blue);
            buffer.writeFloat(this.alpha);
            buffer.m_130130_(this.entitySourceId);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f %.2f %.2f %s", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), Float.valueOf(this.scale), Float.valueOf(this.ageModifier), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.alpha), this.entitySourceId);
        }
    }
}

