/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.packet.packets.AoAPacket;

public class UpdateClientMovementPacket
implements AoAPacket {
    private Float x;
    private Float y;
    private Float z;
    private final Operation operation;

    public UpdateClientMovementPacket(Operation operation) {
        this.operation = operation;
    }

    public UpdateClientMovementPacket x(Float x) {
        this.x = x;
        return this;
    }

    public UpdateClientMovementPacket y(Float y) {
        this.y = y;
        return this;
    }

    public UpdateClientMovementPacket z(Float z) {
        this.z = z;
        return this;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.x != null);
        if (this.x != null) {
            buffer.writeFloat(this.x.floatValue());
        }
        buffer.writeBoolean(this.y != null);
        if (this.y != null) {
            buffer.writeFloat(this.y.floatValue());
        }
        buffer.writeBoolean(this.z != null);
        if (this.z != null) {
            buffer.writeFloat(this.z.floatValue());
        }
        buffer.writeInt(this.operation.toOrdinal());
    }

    public static UpdateClientMovementPacket decode(FriendlyByteBuf buffer) {
        Float x = buffer.readBoolean() ? Float.valueOf(buffer.readFloat()) : null;
        Float y = buffer.readBoolean() ? Float.valueOf(buffer.readFloat()) : null;
        Float z = buffer.readBoolean() ? Float.valueOf(buffer.readFloat()) : null;
        return new UpdateClientMovementPacket(Operation.fromOrdinal(buffer.readInt())).x(x).y(y).z(z);
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> ClientOperations.adjustPlayerMovement(this.x, this.y, this.z, this.operation));
        context.get().setPacketHandled(true);
    }

    public static enum Operation {
        SET(0),
        ADD(1),
        MULTIPLY(2),
        MAX(3),
        MIN(4);

        private final int ordinal;

        private Operation(int ordinal) {
            this.ordinal = ordinal;
        }

        public static Operation fromOrdinal(int ordinal) {
            return switch (ordinal) {
                case 1 -> ADD;
                case 2 -> MULTIPLY;
                case 3 -> MAX;
                case 4 -> MIN;
                default -> SET;
            };
        }

        public int toOrdinal() {
            return this.ordinal;
        }
    }
}

